/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode.tests;

import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class RDFSClassCodeTestCase
extends AbstractJenaTestCase {
    public void testSimpleRDFSNamedClass() {
        String NAME = "Test-Class";
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Test-Class");
        RDFSClassCode code = new RDFSClassCode(cls);
        RDFSClassCodeTestCase.assertEquals((String)"Test_Class", (String)code.getJavaName());
        RDFSClassCodeTestCase.assertSize(0, code.getPropertyCodes());
    }

    public void testRDFSNamedClassWithSimpleProperty() {
        String CLASS_NAME = "TestClass";
        String PROPERTY_NAME = "property";
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("TestClass");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(cls);
        RDFSClassCode code = new RDFSClassCode(cls);
        RDFSClassCodeTestCase.assertEquals((String)"TestClass", (String)code.getJavaName());
        RDFSClassCodeTestCase.assertSize(1, code.getPropertyCodes());
        RDFPropertyAtClassCode pc = (RDFPropertyAtClassCode)code.getPropertyCodes().iterator().next();
        RDFSClassCodeTestCase.assertEquals((Object)property, (Object)pc.getRDFProperty());
    }
}

