/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaNormalizer;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.ProgressDisplay;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JenaCreator {
    private Map anonMap = new HashMap();
    private int classCount;
    private int classProgressCount;
    private boolean forReasoning;
    private boolean inferred;
    private boolean logging = false;
    private OWLModel owlModel;
    private OntModel ontModel;
    private Model owlFullModel;
    private ProgressDisplay progressDisplay;
    private Set systemOwnSlots = new HashSet();
    private Collection targetClses;
    private Map todoIndividualsWithObjectProperties = new HashMap();
    public static final String LOGGING_PROPERTY = String.valueOf(JenaCreator.class.getName()) + ".logging";

    public JenaCreator(OWLModel owlModel, Collection targetClses, ProgressDisplay progressDisplay) {
        this(owlModel, false, false, targetClses, progressDisplay);
    }

    public JenaCreator(OWLModel owlModel, boolean forReasoning, Collection targetClses, ProgressDisplay progressDisplay) {
        this(owlModel, forReasoning, false, targetClses, progressDisplay);
    }

    public JenaCreator(OWLModel owlModel, boolean forReasoning, boolean inferred, Collection targetClses, ProgressDisplay progressDisplay) {
        this.targetClses = targetClses;
        this.inferred = inferred;
        this.owlModel = owlModel;
        this.forReasoning = forReasoning;
        this.progressDisplay = progressDisplay;
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:cardinality"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:minCardinality"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:maxCardinality"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:allValuesFrom"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:someValuesFrom"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:hasValue"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:onProperty"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:imports"));
        this.systemOwnSlots.add(owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:complementOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:intersectionOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:unionOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("owl:equivalentClass"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("rdfs:subClassOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("rdf:type"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("protege:inferredSuperclassOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("protege:inferredSubclassOf"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("protege:inferredType"));
        this.systemOwnSlots.add(owlModel.getRDFProperty("protege:classificationStatus"));
        this.logging = ApplicationProperties.getBooleanProperty((String)LOGGING_PROPERTY, (boolean)false);
    }

    private void addDisjointClasses(OWLNamedClass namedCls, OntClass ontClass) {
        for (RDFSClass superClass : namedCls.getDisjointClasses()) {
            OntClass superOntClass = this.getOntClass(superClass);
            ontClass.addDisjointWith((Resource)superOntClass);
        }
    }

    private void addEquivalentClasses(OWLNamedClass namedCls, OntClass ontClass) {
        Collection clses = this.inferred ? namedCls.getInferredEquivalentClasses() : namedCls.getEquivalentClasses();
        for (RDFSClass superClass : clses) {
            OntClass superOntClass = this.getOntClass(superClass);
            ontClass.addEquivalentClass((Resource)superOntClass);
        }
    }

    private void addEquivalentProperties(OWLProperty property, OntProperty ontProperty) {
        for (OWLProperty equivalentProperty : property.getEquivalentProperties()) {
            OntProperty equivalentOntProperty = this.getOntProperty(equivalentProperty);
            ontProperty.addEquivalentProperty((Property)equivalentOntProperty);
        }
    }

    private void addImports(OWLOntology oi, Ontology ontology) {
        String ns = this.ontModel.getNsPrefixURI("");
        if (ns.endsWith("#")) {
            ns = ns.substring(0, ns.length() - 1);
        }
        this.ontModel.getDocumentManager().addIgnoreImport(ns);
        for (String uri : oi.getImports()) {
            ontology.addImport(this.ontModel.getResource(uri));
            this.ontModel.getDocumentManager().loadImport(this.ontModel, uri);
        }
    }

    private void addPropertyValues(RDFResource rdfResource, OntResource ontResource) {
        if (!this.forReasoning) {
            Collection properties = rdfResource.getPossibleRDFProperties();
            properties.add(this.owlModel.getRDFProperty(":SLOT-CONSTRAINTS"));
            for (RDFProperty property : properties) {
                if (this.isSystemOwnSlot(rdfResource, property) && !property.isAnnotationProperty()) continue;
                if (rdfResource instanceof RDFIndividual && property instanceof OWLObjectProperty && rdfResource.getPropertyValueCount(property) > 0) {
                    ArrayList<RDFProperty> list = (ArrayList<RDFProperty>)this.todoIndividualsWithObjectProperties.get(rdfResource);
                    if (list == null) {
                        list = new ArrayList<RDFProperty>();
                        this.todoIndividualsWithObjectProperties.put(rdfResource, list);
                    }
                    list.add(property);
                    continue;
                }
                this.addPropertyValues(rdfResource, ontResource, property);
            }
        }
    }

    private void addPropertyValues2(RDFResource rdfResource, OntResource ontResource) {
        List list = (List)this.todoIndividualsWithObjectProperties.get(rdfResource);
        for (RDFProperty property : list) {
            this.addPropertyValues(rdfResource, ontResource, property);
        }
    }

    private void addPropertyValues(RDFResource instance, OntResource ontResource, RDFProperty rdfProperty) {
        Property property = this.getProperty(rdfProperty);
        RDFSDatatype rangeDatatype = rdfProperty.getRangeDatatype();
        for (Object value : instance.getPropertyValues(rdfProperty)) {
            if (value instanceof RDFResource) {
                Resource valueResource = this.getResource((RDFResource)value);
                ontResource.addProperty(property, (RDFNode)valueResource);
                continue;
            }
            if (this.owlModel.getRDFXMLLiteralType().equals(rangeDatatype)) {
                ontResource.addProperty(property, (RDFNode)this.ontModel.createTypedLiteral(value, XMLLiteralType.theXMLLiteralType));
                continue;
            }
            Literal literal = JenaCreator.createLiteral(value, this.ontModel);
            ontResource.addProperty(property, (RDFNode)literal);
        }
    }

    private void addSuperclasses(RDFSNamedClass rdfsClass, OntClass ontClass) {
        Collection superClasses = rdfsClass.getPureSuperclasses();
        if (this.inferred && rdfsClass instanceof OWLNamedClass) {
            OWLNamedClass namedCls = (OWLNamedClass)rdfsClass;
            Iterator it = superClasses.iterator();
            while (it.hasNext()) {
                Cls superCls = (Cls)it.next();
                if (!(superCls instanceof RDFSNamedClass)) continue;
                it.remove();
            }
            superClasses.addAll(namedCls.getInferredSuperclasses());
            superClasses.removeAll(namedCls.getInferredEquivalentClasses());
        }
        if (!(superClasses.size() <= 0 || superClasses.size() <= 1 && superClasses.iterator().next().equals(this.owlModel.getOWLThingClass()))) {
            for (Cls superCls : superClasses) {
                RDFSClass superClass = (RDFSClass)superCls;
                OntClass superOntClass = this.getOntClass(superClass);
                ontClass.addSuperClass((Resource)superOntClass);
            }
        }
    }

    private void addSuperproperties(RDFProperty property, OntProperty ontProperty) {
        for (RDFProperty superProperty : property.getSuperproperties(false)) {
            OntProperty superOntProperty = this.getOntProperty(superProperty);
            ontProperty.addSuperProperty((Property)superOntProperty);
        }
    }

    private void addTodoPropertyValues() {
        for (RDFResource resource : this.todoIndividualsWithObjectProperties.keySet()) {
            OntResource ontResource = this.getOntResource(resource);
            this.addPropertyValues2(resource, ontResource);
        }
    }

    private void createAdditionalAnonymousSuperclassesOfIncludedClass(OWLNamedClass namedCls) {
        OntClass ontClass = this.ontModel.getOntClass(namedCls.getURI());
        for (Cls superCls : namedCls.getSuperclasses(false)) {
            if (!(superCls instanceof OWLAnonymousClass) || superCls.isIncluded()) continue;
            OntClass superClass = this.getOntClass((OWLAnonymousClass)superCls);
            if (superCls.hasDirectSuperclass((Cls)namedCls)) {
                ontClass.addEquivalentClass((Resource)superClass);
                continue;
            }
            ontClass.addSuperClass((Resource)superClass);
        }
    }

    private OntClass createAnonymousClass(OWLAnonymousClass anonymousCls) {
        if (anonymousCls instanceof OWLLogicalClass) {
            return this.createLogicalClass((OWLLogicalClass)anonymousCls);
        }
        if (anonymousCls instanceof OWLEnumeratedClass) {
            return this.createEnumeratedClass((OWLEnumeratedClass)anonymousCls);
        }
        return this.createRestriction((OWLRestriction)anonymousCls);
    }

    private Restriction createCardinalityRestriction(OWLCardinalityBase restriction) {
        int cardinality = restriction.getCardinality();
        RDFProperty property = restriction.getOnProperty();
        OntProperty ontProperty = this.getOntProperty(property);
        if (restriction instanceof OWLMaxCardinality) {
            return this.ontModel.createMaxCardinalityRestriction(null, (Property)ontProperty, cardinality);
        }
        if (restriction instanceof OWLMinCardinality) {
            return this.ontModel.createMinCardinalityRestriction(null, (Property)ontProperty, cardinality);
        }
        return this.ontModel.createCardinalityRestriction(null, (Property)ontProperty, cardinality);
    }

    public static DataRange createDataRange(OWLDataRange dataRange, OntModel ontModel) {
        ArrayList<Literal> members = new ArrayList<Literal>();
        if (dataRange.getOneOf() != null) {
            for (Object value : dataRange.getOneOf().getValues()) {
                Literal literal = JenaCreator.createLiteral(value, ontModel);
                members.add(literal);
            }
        }
        RDFList literals = ontModel.createList(members.iterator());
        return ontModel.createDataRange(literals);
    }

    private static Literal createLiteral(Object value, OntModel ontModel) {
        if (value instanceof RDFSLiteral) {
            RDFSLiteral literal = (RDFSLiteral)value;
            if (literal.getLanguage() != null) {
                return ontModel.createLiteral(literal.getString(), literal.getLanguage());
            }
            return ontModel.createTypedLiteral(literal.getString(), XMLSchemaDatatypes.getRDFDatatype(literal.getDatatype()));
        }
        return ontModel.createTypedLiteral(value);
    }

    private OntProperty createDatatypeProperty(OWLDatatypeProperty datatypeProperty) {
        DatatypeProperty ontProperty = this.ontModel.createDatatypeProperty(datatypeProperty.getURI());
        this.adjustOntPropertyRDFType(datatypeProperty, (OntProperty)ontProperty);
        return ontProperty;
    }

    private EnumeratedClass createEnumeratedClass(OWLEnumeratedClass enumerationCls) {
        RDFList list = this.createOntResourceList(enumerationCls.getOneOf());
        return this.ontModel.createEnumeratedClass(null, list);
    }

    private HasValueRestriction createHasValueRestriction(OWLHasValue hasRestriction) {
        OntProperty property = this.getOntProperty(hasRestriction.getOnProperty());
        Object node = null;
        Object value = hasRestriction.getHasValue();
        node = value instanceof RDFResource ? this.getIndividual((RDFResource)value) : this.ontModel.createTypedLiteral(value);
        return this.ontModel.createHasValueRestriction(null, (Property)property, (RDFNode)node);
    }

    private Individual createIndividual(RDFResource rdfResource, boolean anon) {
        if (this.logging) {
            this.log("Creating RDFIndividual for " + rdfResource.getBrowserText());
        }
        Iterator it = null;
        it = this.inferred && !rdfResource.getInferredTypes().isEmpty() ? rdfResource.getInferredTypes().iterator() : rdfResource.getProtegeTypes().iterator();
        RDFSClass type = (RDFSClass)it.next();
        OntClass ontClass = this.getOntClass(type);
        Individual individual = this.ontModel.getIndividual(rdfResource.getURI());
        if (individual == null) {
            String uri = null;
            if (!rdfResource.isAnonymous() && !type.equals(this.owlModel.getRDFListClass())) {
                uri = rdfResource.getURI();
            }
            individual = this.ontModel.createIndividual(uri, (Resource)ontClass);
            while (it.hasNext()) {
                RDFSClass addType = (RDFSClass)it.next();
                OntClass addOntClass = this.getOntClass(addType);
                if (addOntClass == null) continue;
                individual.addRDFType((Resource)addOntClass);
            }
            if (anon) {
                this.anonMap.put(rdfResource, individual);
            }
            this.addPropertyValues(rdfResource, (OntResource)individual);
        }
        return individual;
    }

    private void createIndividuals() {
        Iterator it = this.getRDFSClassIterator();
        while (it.hasNext()) {
            RDFSNamedClass rdfsClass = (RDFSNamedClass)it.next();
            for (Instance instance : rdfsClass.getInstances(false)) {
                if (!(instance instanceof RDFResource) || instance instanceof RDFProperty) continue;
                RDFResource RDFResource2 = (RDFResource)instance;
                this.getOntResource(RDFResource2);
            }
        }
    }

    private OntClass createLogicalClass(OWLLogicalClass logicalCls) {
        if (logicalCls instanceof OWLNAryLogicalClass) {
            ArrayList<OntClass> operands = new ArrayList<OntClass>();
            OWLNAryLogicalClass nc = (OWLNAryLogicalClass)logicalCls;
            for (RDFSClass operandClass : nc.getOperands()) {
                operands.add(this.getOntClass(operandClass));
            }
            if (logicalCls instanceof OWLIntersectionClass) {
                return this.ontModel.createIntersectionClass(null, this.ontModel.createList(operands.iterator()));
            }
            return this.ontModel.createUnionClass(null, this.ontModel.createList(operands.iterator()));
        }
        OWLComplementClass cc = (OWLComplementClass)logicalCls;
        RDFSClass complement = cc.getComplement();
        return this.ontModel.createComplementClass(null, (Resource)this.getOntClass(complement));
    }

    private OntClass createNamedClass(RDFSNamedClass rdfsClass) {
        if (this.logging) {
            this.log("Creating named OntClass for " + rdfsClass.getBrowserText());
        }
        ++this.classProgressCount;
        if (this.progressDisplay != null) {
            this.progressDisplay.setProgressValue((double)this.classProgressCount / (double)this.classCount);
        }
        OntClass ontClass = this.ontModel.createClass(rdfsClass.getURI());
        if (!this.forReasoning) {
            for (RDFSClass type : rdfsClass.getRDFTypes()) {
                if (this.owlModel.getOWLNamedClassClass().equals(type)) continue;
                ontClass.addRDFType((Resource)this.getOntClass(type));
            }
        }
        if (rdfsClass.isDeprecated()) {
            ontClass.addRDFType(OWL.DeprecatedClass);
        }
        this.addSuperclasses(rdfsClass, ontClass);
        if (rdfsClass instanceof OWLNamedClass) {
            OWLNamedClass namedCls = (OWLNamedClass)rdfsClass;
            this.addEquivalentClasses(namedCls, ontClass);
            this.addDisjointClasses(namedCls, ontClass);
        }
        this.addPropertyValues(rdfsClass, (OntResource)ontClass);
        return ontClass;
    }

    private OntProperty createObjectProperty(OWLObjectProperty objectProperty) {
        ObjectProperty ontProperty = this.ontModel.createObjectProperty(objectProperty.getURI());
        this.adjustOntPropertyRDFType(objectProperty, (OntProperty)ontProperty);
        if (objectProperty.isSymmetric()) {
            ontProperty.addRDFType(OWL.SymmetricProperty);
        }
        if (objectProperty.isTransitive()) {
            ontProperty.addRDFType(OWL.TransitiveProperty);
        }
        if (objectProperty.getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty inverseSlot = (OWLObjectProperty)objectProperty.getInverseProperty();
            OntProperty inverseProperty = this.getOntProperty(inverseSlot);
            ontProperty.setInverseOf((Property)inverseProperty);
        }
        return ontProperty;
    }

    private void createOntClasses() {
        Iterator it = this.getRDFSClassIterator();
        while (it.hasNext()) {
            RDFSNamedClass rdfsClass = (RDFSNamedClass)it.next();
            this.getOntClass(rdfsClass);
            if (!(rdfsClass instanceof OWLNamedClass) || !rdfsClass.isIncluded()) continue;
            this.createAdditionalAnonymousSuperclassesOfIncludedClass((OWLNamedClass)rdfsClass);
        }
    }

    public OntModel createOntModel() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        Model owlFullModel = Jena.addOWLFullModel(ontModel);
        this.run(ontModel, owlFullModel);
        return ontModel;
    }

    public OntModel createOntModelWithoutOWLFullModel() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        Model owlFullModel = Jena.addOWLFullModel(ontModel);
        this.run(ontModel, owlFullModel);
        ontModel.removeSubModel(owlFullModel);
        return ontModel;
    }

    private void createOntologies() {
        for (OWLOntology owlOntology : this.owlModel.getOWLOntologyClass().getInstances(false)) {
            if (owlOntology.isIncluded() && !owlOntology.equals(this.owlModel.getDefaultOWLOntology())) continue;
            String ontologyURI = owlOntology.getURI();
            Ontology ontology = this.ontModel.createOntology(ontologyURI);
            this.addImports(owlOntology, ontology);
            JenaNormalizer.assignRDFTypesToMetaclassInstances(this.ontModel, this.owlFullModel);
            this.addPropertyValues(owlOntology, (OntResource)ontology);
        }
        Jena.ensureOWLFullModelIsLastModel(this.ontModel, this.owlFullModel);
    }

    OntProperty createOntProperty(RDFProperty property) {
        if (this.logging) {
            this.log("Creating OntProperty for " + property.getBrowserText());
        }
        OntProperty ontProperty = null;
        ontProperty = property instanceof OWLDatatypeProperty ? this.createDatatypeProperty((OWLDatatypeProperty)property) : (property instanceof OWLObjectProperty ? this.createObjectProperty((OWLObjectProperty)property) : this.createRDFProperty(property));
        if (property.isAnnotationProperty()) {
            ontProperty.addRDFType(OWL.AnnotationProperty);
        }
        if (property.isDeprecated()) {
            ontProperty.addRDFType(OWL.DeprecatedProperty);
        }
        this.addSuperproperties(property, ontProperty);
        this.addPropertyValues(property, (OntResource)ontProperty);
        this.setPropertyDomain(property, ontProperty);
        if (property.isFunctional()) {
            ontProperty.addRDFType(OWL.FunctionalProperty);
        }
        if (property instanceof OWLProperty) {
            OWLProperty owlProperty = (OWLProperty)property;
            if (owlProperty.isInverseFunctional()) {
                ontProperty.addRDFType(OWL.InverseFunctionalProperty);
            }
            this.addEquivalentProperties(owlProperty, ontProperty);
        }
        return ontProperty;
    }

    private void adjustOntPropertyRDFType(RDFProperty property, OntProperty ontProperty) {
        if (!this.forReasoning && !property.getProtegeType().isSystem()) {
            OntClass metaClass = this.getOntClass(property.getProtegeType());
            ontProperty.setRDFType((Resource)metaClass);
            this.owlFullModel.add((Resource)ontProperty, RDF.type, (RDFNode)RDF.Property);
        }
    }

    private void createOntProperties() {
        for (RDFProperty rdfProperty : this.owlModel.getUserDefinedRDFProperties()) {
            if (!rdfProperty.isEditable()) continue;
            this.getOntProperty(rdfProperty);
        }
    }

    private RDFList createOntResourceList(Collection instances) {
        ArrayList<OntResource> members = new ArrayList<OntResource>();
        for (RDFResource RDFResource2 : instances) {
            OntResource ontResource = this.getOntResource(RDFResource2);
            members.add(ontResource);
        }
        return this.ontModel.createList(members.iterator());
    }

    private void createPrefixes(OntModel ontModel) {
        Set set = ontModel.getNsPrefixMap().keySet();
        for (String prefix : set) {
            ontModel.removeNsPrefix(prefix);
        }
        String defaultNS = this.owlModel.getNamespaceManager().getDefaultNamespace();
        ontModel.setNsPrefix("", defaultNS);
        for (String prefix : this.owlModel.getNamespaceManager().getPrefixes()) {
            String ns = this.owlModel.getNamespaceManager().getNamespaceForPrefix(prefix);
            ontModel.setNsPrefix(prefix, ns);
        }
    }

    private Restriction createQuantifierRestriction(OWLQuantifierRestriction restriction) {
        OntProperty property = this.getOntProperty(restriction.getOnProperty());
        RDFResource filler = restriction.getFiller();
        OntResource jenaFiller = null;
        if (filler instanceof RDFSClass) {
            jenaFiller = this.getOntResource(restriction.getFiller());
        } else if (filler instanceof OWLDataRange) {
            jenaFiller = JenaCreator.createDataRange((OWLDataRange)filler, this.ontModel);
        } else {
            String uri = filler.getURI();
            jenaFiller = this.ontModel.getResource(uri);
        }
        if (restriction instanceof OWLAllValuesFrom) {
            return this.ontModel.createAllValuesFromRestriction(null, (Property)property, (Resource)jenaFiller);
        }
        return this.ontModel.createSomeValuesFromRestriction(null, (Property)property, (Resource)jenaFiller);
    }

    private OntProperty createRDFProperty(RDFProperty rdfProperty) {
        OntProperty ontProperty = this.ontModel.createOntProperty(rdfProperty.getURI());
        this.adjustOntPropertyRDFType(rdfProperty, ontProperty);
        return ontProperty;
    }

    private Restriction createRestriction(OWLRestriction restriction) {
        if (restriction instanceof OWLQuantifierRestriction) {
            return this.createQuantifierRestriction((OWLQuantifierRestriction)restriction);
        }
        if (restriction instanceof OWLCardinalityBase) {
            return this.createCardinalityRestriction((OWLCardinalityBase)restriction);
        }
        return this.createHasValueRestriction((OWLHasValue)restriction);
    }

    private void ensureProtegeMetaOntologyImported() {
        Ontology defaultOntology = this.getDefaultOntology();
        Resource o = this.ontModel.getResource(ProtegeNames.FILE);
        if (!Jena.set((Iterator)defaultOntology.listImports()).contains(o)) {
            defaultOntology.addImport(o);
            this.ontModel.getDocumentManager().loadImport(this.ontModel, ProtegeNames.FILE);
        }
    }

    private Ontology getDefaultOntology() {
        return (Ontology)this.ontModel.listOntologies().next();
    }

    private Individual getIndividual(RDFResource rdfResource) {
        if (rdfResource.isAnonymous()) {
            Individual individual = (Individual)this.anonMap.get(rdfResource);
            if (individual != null) {
                return individual;
            }
            return this.createIndividual(rdfResource, true);
        }
        Individual individual = this.ontModel.getIndividual(rdfResource.getURI());
        if (individual == null) {
            individual = this.createIndividual(rdfResource, false);
        }
        return individual;
    }

    private Iterator getRDFSClassIterator() {
        Collection collection = null;
        if (this.targetClses != null) {
            collection = this.targetClses;
        } else {
            collection = this.owlModel.getUserDefinedRDFSNamedClasses();
            if (this.owlModel instanceof JenaOWLModel) {
                collection.add(this.owlModel.getRDFSNamedClass(":PAL-CONSTRAINT"));
            }
            collection.add(this.owlModel.getOWLThingClass());
        }
        this.classCount = collection.size();
        return collection.iterator();
    }

    private OntClass getOntClass(RDFSClass rdfsClass) {
        if (rdfsClass instanceof RDFSNamedClass) {
            OntClass ontClass;
            Resource resource;
            if (rdfsClass.isIncluded() && !(resource = this.ontModel.getResource(rdfsClass.getURI())).hasProperty(RDF.type, (RDFNode)RDFS.Class) && !resource.hasProperty(RDF.type, (RDFNode)OWL.Class)) {
                this.owlFullModel.add(this.ontModel.getResource(rdfsClass.getURI()), RDF.type, (RDFNode)OWL.Class);
            }
            if ((ontClass = this.ontModel.getOntClass(rdfsClass.getURI())) == null) {
                ontClass = this.createNamedClass((RDFSNamedClass)rdfsClass);
            }
            return ontClass;
        }
        OntClass ontClass = this.createAnonymousClass((OWLAnonymousClass)rdfsClass);
        this.addPropertyValues(rdfsClass, (OntResource)ontClass);
        return ontClass;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    private OntProperty getOntProperty(RDFProperty property) {
        String uri = property.getURI();
        Resource res = this.ontModel.getResource(uri);
        if (res != null && res.canAs(OntProperty.class)) {
            return (OntProperty)res.as(OntProperty.class);
        }
        return this.createOntProperty(property);
    }

    private OntResource getOntResource(RDFResource rdfResource) {
        if (rdfResource instanceof RDFSClass) {
            return this.getOntClass((RDFSClass)rdfResource);
        }
        if (rdfResource instanceof RDFProperty) {
            return this.getOntProperty((RDFProperty)rdfResource);
        }
        return this.getIndividual(rdfResource);
    }

    public Model getOWLFullModel() {
        return this.owlFullModel;
    }

    private Property getProperty(RDFProperty property) {
        if (property.isEditable()) {
            return this.getOntProperty(property);
        }
        return this.ontModel.getProperty(property.getURI());
    }

    private Resource getResource(RDFResource rdfResource) {
        if (rdfResource instanceof RDFSDatatype && !rdfResource.isEditable()) {
            return this.ontModel.getResource(rdfResource.getURI());
        }
        return this.getOntResource(rdfResource);
    }

    private boolean isSystemOwnSlot(Instance instance, Slot slot) {
        if (instance instanceof OWLEnumeratedClass && slot.getName().equals("owl:oneOf")) {
            return true;
        }
        return this.systemOwnSlots.contains(slot);
    }

    private void log(String msg) {
        if (this.logging) {
            System.out.println("[JenaCreator] " + msg);
        }
    }

    public void run(OntModel ontModel, Model owlFullModel) {
        long startTime = System.currentTimeMillis();
        this.log("Starting JenaCreator...");
        this.ontModel = ontModel;
        this.owlFullModel = owlFullModel;
        if (this.progressDisplay != null) {
            this.progressDisplay.start();
            this.progressDisplay.setProgressText("Creating classes...");
        }
        this.createPrefixes(ontModel);
        this.createOntologies();
        this.createOntClasses();
        if (this.targetClses == null) {
            if (this.progressDisplay != null) {
                this.progressDisplay.setProgressText("Creating properties...");
            }
            this.createOntProperties();
        }
        if (this.progressDisplay != null) {
            this.progressDisplay.setProgressText("Creating individuals...");
        }
        this.createIndividuals();
        this.addTodoPropertyValues();
        this.createAllDifferents();
        this.log("Terminated after " + (System.currentTimeMillis() - startTime) + " ms");
        if (this.progressDisplay != null) {
            this.progressDisplay.stop();
        }
    }

    private void createAllDifferents() {
        RDFSNamedClass adc = this.owlModel.getRDFSNamedClass("owl:AllDifferent");
        for (OWLAllDifferent owlAllDifferent : adc.getInstances(true)) {
            if (owlAllDifferent.isIncluded()) continue;
            AllDifferent allDifferent = this.ontModel.createAllDifferent();
            for (RDFResource resource : owlAllDifferent.getDistinctMembers()) {
                Resource r = this.getResource(resource);
                allDifferent.addDistinctMember(r);
            }
        }
    }

    private void setPropertyDomain(RDFProperty property, OntProperty ontProperty) {
        if (this.owlModel.getOWLThingClass().equals(property.getDomain(false))) {
            ontProperty.removeDomain((Resource)ontProperty.getDomain());
        }
    }
}

