/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import java.util.Arrays;

public class CreateEquivalentClassesTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateDefinition() {
        OWLNamedClass person = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        cls.removeSuperclass(this.owlModel.getOWLThingClass());
        cls.addSuperclass(person);
        cls.addEquivalentClass(this.owlModel.createOWLIntersectionClass(Arrays.asList(person, this.owlModel.createOWLMinCardinality(slot, 1))));
        OntModel ontModel = this.runJenaCreator();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateEquivalentClassesTestCase.assertFalse((boolean)ontClass.listSuperClasses().hasNext());
        ExtendedIterator it = ontClass.listEquivalentClasses();
        OntClass equi = (OntClass)it.next();
        CreateEquivalentClassesTestCase.assertTrue((boolean)equi.canAs(IntersectionClass.class));
        CreateEquivalentClassesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateInferredEquivalentClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedSubclass("B", a);
        a.addInferredSuperclass(b);
        b.addInferredSuperclass(a);
        OntModel ontModel = this.runJenaCreator(false, true);
        OntClass aClass = ontModel.getOntClass(a.getURI());
        OntClass bClass = ontModel.getOntClass(b.getURI());
        CreateEquivalentClassesTestCase.assertTrue((boolean)aClass.hasEquivalentClass((Resource)bClass));
        CreateEquivalentClassesTestCase.assertFalse((boolean)bClass.hasSuperClass((Resource)aClass));
    }
}

