/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph.tests;

import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegePrefixMapping;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ProtegePrefixMappingTestCase
extends AbstractJenaTestCase {
    public void testDefaultOWLModel() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        ProtegePrefixMappingTestCase.assertEquals((String)ts.getDefaultNamespace(), (String)mapping.getNsPrefixURI(""));
        String owlURI = this.owlThing.getNamespace();
        ProtegePrefixMappingTestCase.assertEquals((String)"owl", (String)mapping.getNsURIPrefix(owlURI));
        ProtegePrefixMappingTestCase.assertEquals((String)owlURI, (String)mapping.getNsPrefixURI("owl"));
    }

    public void testExpandPrefixOWLThing() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        ProtegePrefixMappingTestCase.assertEquals((String)this.owlThing.getURI(), (String)mapping.expandPrefix(this.owlThing.getName()));
    }

    public void testExpandInvalidPrefix() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        String invalidName = "aldi:Test";
        ProtegePrefixMappingTestCase.assertEquals((String)invalidName, (String)mapping.expandPrefix(invalidName));
    }

    public void testExpandPrefixFromDefaultNamespace() {
        OWLNamedClass resource = this.owlModel.createOWLNamedClass("Class");
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        ProtegePrefixMappingTestCase.assertEquals((String)resource.getURI(), (String)mapping.expandPrefix(resource.getName()));
    }

    public void testShortFormOWLThing() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        ProtegePrefixMappingTestCase.assertEquals((String)this.owlThing.getName(), (String)mapping.shortForm(OWL.Thing.getURI()));
    }

    public void testShortFormInvalid() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ProtegePrefixMapping mapping = new ProtegePrefixMapping(this.owlModel, ts);
        String invalidName = "http://aldi.de#Test";
        ProtegePrefixMappingTestCase.assertEquals((String)invalidName, (String)mapping.shortForm(invalidName));
    }
}

