/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;

public class ImportInstancesTestCase
extends AbstractOWLImporterTestCase {
    public void testImportInstance() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty oldAgeSlot = this.owlModel.createOWLDatatypeProperty("age", this.owlModel.getXSDint());
        OWLObjectProperty oldChildrenSlot = this.owlModel.createOWLObjectProperty("children");
        oldAgeSlot.setDomain(oldCls);
        oldChildrenSlot.setDomain(oldCls);
        RDFResource oldInstance = oldCls.createInstance("John");
        RDFResource oldChild = oldCls.createInstance("Child");
        oldInstance.setDirectOwnSlotValue(oldAgeSlot, new Integer(42));
        oldInstance.setDirectOwnSlotValue(oldChildrenSlot, oldChild);
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newAgeSlot = kb.getSlot(oldAgeSlot.getName());
        Slot newChildrenSlot = kb.getSlot(oldChildrenSlot.getName());
        Instance newInstance = kb.getInstance(oldInstance.getName());
        Instance newChild = kb.getInstance(oldChild.getName());
        ImportInstancesTestCase.assertNotNull((Object)newInstance);
        ImportInstancesTestCase.assertEquals((Object)newCls, (Object)newInstance.getDirectType());
        ImportInstancesTestCase.assertEquals((Object)new Integer(42), (Object)newInstance.getDirectOwnSlotValue(newAgeSlot));
        ImportInstancesTestCase.assertEquals((Object)newChild, (Object)newInstance.getDirectOwnSlotValue(newChildrenSlot));
    }
}

