/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Iterator;

public class CreateDatatypeEnumerationTestCase
extends AbstractProtege2JenaTestCase {
    public void estCreateAllRestrictionWithInt() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDint());
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, new RDFSLiteral[]{this.owlModel.createRDFSLiteral(new Integer(1)), this.owlModel.createRDFSLiteral(new Integer(2))}));
        OntModel newModel = this.createOntModel();
        OntClass ontClass = newModel.getOntClass(cls.getURI());
        OntClass superClass = null;
        ExtendedIterator it = ontClass.listSuperClasses();
        while (it.hasNext()) {
            superClass = (OntClass)it.next();
            if (superClass.canAs(AllValuesFromRestriction.class)) break;
        }
        AllValuesFromRestriction restriction = (AllValuesFromRestriction)superClass.as(AllValuesFromRestriction.class);
        DataRange dataRange = (DataRange)restriction.getAllValuesFrom().as(DataRange.class);
        CreateDatatypeEnumerationTestCase.assertSize(2, (Iterator)dataRange.listOneOf());
        ExtendedIterator it2 = dataRange.listOneOf();
        Literal firstLiteral = (Literal)((RDFNode)it2.next()).as(Literal.class);
        CreateDatatypeEnumerationTestCase.assertEquals((Object)XMLSchemaDatatypes.getDefaultXSDDatatype(ValueType.INTEGER), (Object)firstLiteral.getDatatype());
        CreateDatatypeEnumerationTestCase.assertEquals((int)1, (int)firstLiteral.getInt());
        Literal secondLiteral = (Literal)((RDFNode)it2.next()).as(Literal.class);
        CreateDatatypeEnumerationTestCase.assertEquals((int)2, (int)secondLiteral.getInt());
    }

    public void testCreateAllRestrictionWithString() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, new RDFSLiteral[]{this.owlModel.createRDFSLiteral("A"), this.owlModel.createRDFSLiteral("B")}));
        OntModel newModel = this.createOntModel();
        OntClass ontClass = newModel.getOntClass(cls.getURI());
        OntClass superClass = null;
        ExtendedIterator it = ontClass.listSuperClasses();
        while (it.hasNext()) {
            superClass = (OntClass)it.next();
            if (superClass.canAs(AllValuesFromRestriction.class)) break;
        }
        AllValuesFromRestriction restriction = (AllValuesFromRestriction)superClass.as(AllValuesFromRestriction.class);
        DataRange dataRange = (DataRange)restriction.getAllValuesFrom().as(DataRange.class);
        CreateDatatypeEnumerationTestCase.assertSize(2, (Iterator)dataRange.listOneOf());
        ExtendedIterator it2 = dataRange.listOneOf();
        Literal firstLiteral = (Literal)((RDFNode)it2.next()).as(Literal.class);
        CreateDatatypeEnumerationTestCase.assertEquals((Object)XMLSchemaDatatypes.getDefaultXSDDatatype(ValueType.STRING), (Object)firstLiteral.getDatatype());
        CreateDatatypeEnumerationTestCase.assertEquals((String)"A", (String)firstLiteral.getString());
        Literal secondLiteral = (Literal)((RDFNode)it2.next()).as(Literal.class);
        CreateDatatypeEnumerationTestCase.assertEquals((String)"B", (String)secondLiteral.getString());
    }
}

