/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import java.util.Arrays;

public class CreateOWLEquivalentClassesTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateDefinition() {
        OWLNamedClass person = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        cls.removeSuperclass(this.owlModel.getOWLThingClass());
        cls.addSuperclass(person);
        cls.addEquivalentClass(this.owlModel.createOWLIntersectionClass(Arrays.asList(person, this.owlModel.createOWLMinCardinality(property, 1))));
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateOWLEquivalentClassesTestCase.assertFalse((boolean)ontClass.listSuperClasses(true).hasNext());
        ExtendedIterator it = ontClass.listEquivalentClasses();
        OntClass equi = (OntClass)it.next();
        CreateOWLEquivalentClassesTestCase.assertTrue((boolean)equi.canAs(IntersectionClass.class));
        CreateOWLEquivalentClassesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateNamedEquivalentClasses() {
        OWLNamedClass classA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass classB = this.owlModel.createOWLNamedClass("B");
        classA.addEquivalentClass(classB);
        OntModel ontModel = this.createOntModel();
        OntClass ontClassA = ontModel.getOntClass(classA.getURI());
        OntClass ontClassB = ontModel.getOntClass(classB.getURI());
        CreateOWLEquivalentClassesTestCase.assertEquals((Object)ontClassB, (Object)ontClassA.getEquivalentClass());
        CreateOWLEquivalentClassesTestCase.assertEquals((Object)ontClassA, (Object)ontClassB.getEquivalentClass());
        CreateOWLEquivalentClassesTestCase.assertFalse((boolean)ontClassA.hasProperty(RDFS.subClassOf, (RDFNode)ontClassB));
        CreateOWLEquivalentClassesTestCase.assertFalse((boolean)ontClassB.hasProperty(RDFS.subClassOf, (RDFNode)ontClassA));
    }
}

