/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.rdf2owl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import java.util.Iterator;

public class RDF2OWL {
    private Model model;

    public RDF2OWL(Model model) {
        this.model = model;
    }

    private void convertRDFSClasses() {
        StmtIterator it = this.model.listStatements(null, RDF.type, (RDFNode)RDFS.Class);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource clazz = s.getSubject();
            s.getModel().add(clazz, RDF.type, (RDFNode)OWL.Class);
            it.remove();
            this.log("Converted rdfs:Class " + clazz + " into owl:Class");
        }
    }

    private void convertProperties() {
        StmtIterator it = this.model.listStatements(null, RDF.type, (RDFNode)RDF.Property);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource property = s.getSubject();
            Resource type = this.getPropertyType(property);
            s.getModel().add(property, RDF.type, (RDFNode)type);
            it.remove();
            this.log("Converted rdf:Property " + property + " into " + type);
        }
    }

    private void convertRDFSResource() {
        StmtIterator it = this.model.listStatements(null, null, (RDFNode)RDFS.Resource);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            s.getModel().add(s.getSubject(), s.getPredicate(), (RDFNode)OWL.Thing);
            this.log("Replaced triple " + s + " with (x, x, owl:Thing)");
            it.remove();
        }
    }

    private Resource getPropertyType(Resource property) {
        StmtIterator it = this.model.listStatements(property, RDFS.range, null);
        if (it.hasNext()) {
            while (it.hasNext()) {
                Statement s = it.nextStatement();
                RDFNode n = s.getObject();
                if (!n.canAs(Resource.class) || !this.model.contains((Resource)n.as(Resource.class), RDF.type, (RDFNode)OWL.Class)) continue;
                return OWL.ObjectProperty;
            }
        }
        return OWL.DatatypeProperty;
    }

    private void log(String message) {
        System.out.println("[RDF2OWL] " + message);
    }

    public void run() {
        this.unifyRDFSVersion();
        this.convertRDFSResource();
    }

    private void unifyRDFSVersion() {
        String[] oldRDFSNSs = new String[]{"http://www.w3.org/TR/1999/PR-rdf-schema-19990303#"};
        int i = 0;
        while (i < oldRDFSNSs.length) {
            String oldRDFSNS = oldRDFSNSs[i];
            this.unifyRDFSVersion(oldRDFSNS);
            ++i;
        }
    }

    private void unifyRDFSVersion(String ns) {
        Iterator it = Jena.cloneIt((Iterator)this.model.listStatements());
        while (it.hasNext()) {
            Resource oldResource;
            Statement s = (Statement)it.next();
            Resource newSubject = s.getSubject();
            Property newPredicate = s.getPredicate();
            RDFNode newObject = s.getObject();
            boolean changed = false;
            if (ns.equals(newSubject.getNameSpace())) {
                changed = true;
                newSubject = this.model.getResource(String.valueOf(RDFS.getURI()) + newSubject.getLocalName());
            }
            if (ns.equals(newPredicate.getNameSpace())) {
                changed = true;
                newPredicate = this.model.getProperty(String.valueOf(RDFS.getURI()) + newPredicate.getLocalName());
            }
            if (newObject.canAs(Resource.class) && ns.equals((oldResource = (Resource)newObject.as(Resource.class)).getNameSpace())) {
                changed = true;
                newObject = this.model.getResource(String.valueOf(RDFS.getURI()) + oldResource.getLocalName());
            }
            if (!changed) continue;
            this.model.add(newSubject, newPredicate, newObject);
            this.log("Replaced deprecated triple " + s + " with " + newSubject + ", " + newPredicate + ", " + newObject);
            it.remove();
        }
    }
}

