/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class JenaTripleStore
extends AbstractTripleStore {
    public JenaTripleStore(OWLModel owlModel, NarrowFrameStore frameStore, TripleStoreModel tripleStoreModel) {
        super(owlModel, tripleStoreModel, frameStore);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JenaTripleStore) {
            return this.frameStore.getName().equals(((JenaTripleStore)obj).frameStore.getName());
        }
        return false;
    }

    public Iterator listTriples() {
        OWLModel kb = this.owlModel;
        HashSet<Slot> ignoreProperties = new HashSet<Slot>();
        ignoreProperties.add(this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES"));
        ignoreProperties.add(kb.getSlot(":DIRECT-INSTANCES"));
        ignoreProperties.add(kb.getSlot(":DIRECT-TYPE"));
        ignoreProperties.add(kb.getSlot("protege:classificationStatus"));
        ignoreProperties.add(kb.getSlot("protege:inferredSuperclassOf"));
        ignoreProperties.add(kb.getSlot("protege:inferredSubclassOf"));
        ignoreProperties.add(kb.getSlot("protege:inferredType"));
        ArrayList<DefaultTriple> triples = new ArrayList<DefaultTriple>();
        Collection records = ((InMemoryFrameDb)this.frameStore).getRecords();
        for (Record record : records) {
            Slot predicate;
            Frame subject = record.getFrame();
            if (!(subject instanceof RDFResource) || !((predicate = record.getSlot()) instanceof RDFProperty) || record.getFacet() != null || record.isTemplate() || ignoreProperties.contains(predicate)) continue;
            List values = record.getValues();
            for (Object object : values) {
                if (object instanceof String && DefaultRDFSLiteral.isRawValue((String)object)) {
                    object = new DefaultRDFSLiteral(this.owlModel, (String)object);
                }
                DefaultTriple triple = new DefaultTriple((RDFResource)subject, (RDFProperty)predicate, object);
                triples.add(triple);
            }
        }
        return triples.iterator();
    }
}

