/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractOWLClassDisplay
implements OWLClassDisplay {
    private RDFProperty commentedOutProperty;

    public String getDisplayText(RDFSClass cls) {
        if (cls instanceof RDFSNamedClass) {
            return cls.getBrowserText();
        }
        if (cls instanceof OWLRestriction) {
            return String.valueOf(this.getCommentText(cls)) + this.getDisplayTextOfOWLRestriction((OWLRestriction)cls);
        }
        if (cls instanceof OWLNAryLogicalClass) {
            return String.valueOf(this.getCommentText(cls)) + this.getDisplayTextOfOWLNAryLogicalClass((OWLNAryLogicalClass)cls);
        }
        if (cls instanceof OWLComplementClass) {
            return String.valueOf(this.getCommentText(cls)) + this.getDisplayTextOfOWLComplementClass((OWLComplementClass)cls);
        }
        if (cls instanceof OWLEnumeratedClass) {
            return String.valueOf(this.getCommentText(cls)) + this.getDisplayTextOfOWLEnumeratedClass((OWLEnumeratedClass)cls);
        }
        return null;
    }

    protected String getCommentText(RDFSClass cls) {
        if (cls.isAnonymous() && cls.getOWLModel().isProtegeMetaOntologyImported() && cls.getPropertyValue(cls.getOWLModel().getRDFProperty("protege:isCommentedOut")) != null) {
            return "// ";
        }
        return "";
    }

    public String getSymbol(OWLAnonymousClass cls) {
        if (cls instanceof OWLRestriction) {
            if (cls instanceof OWLSomeValuesFrom) {
                return this.getOWLSomeValuesFromSymbol();
            }
            if (cls instanceof OWLAllValuesFrom) {
                return this.getOWLAllValuesFromSymbol();
            }
            if (cls instanceof OWLHasValue) {
                return this.getOWLHasValueSymbol();
            }
            if (cls instanceof OWLCardinality) {
                return this.getOWLCardinalitySymbol();
            }
            if (cls instanceof OWLMaxCardinality) {
                return this.getOWLMaxCardinalitySymbol();
            }
            if (cls instanceof OWLMinCardinality) {
                return this.getOWLMinCardinalitySymbol();
            }
            throw new IllegalArgumentException("Unknown restriction type " + cls.getClass());
        }
        if (cls instanceof OWLIntersectionClass) {
            return this.getOWLIntersectionOfSymbol();
        }
        if (cls instanceof OWLUnionClass) {
            return this.getOWLUnionOfSymbol();
        }
        if (cls instanceof OWLComplementClass) {
            return this.getOWLComplementOfSymbol();
        }
        throw new IllegalArgumentException("Unexpected class type " + cls.getClass());
    }

    protected String getDisplayTextOfOWLComplementClass(OWLComplementClass cls) {
        String key = this.getOWLComplementOfSymbol();
        if (key.length() > 1) {
            return String.valueOf(key) + " " + this.getNestedDisplayText(cls.getComplement());
        }
        return String.valueOf(key) + this.getNestedDisplayText(cls.getComplement());
    }

    protected String getDisplayTextOfOWLEnumeratedClass(OWLEnumeratedClass cls) {
        Collection values = cls.getOneOf();
        String str = "{";
        Iterator it = values.iterator();
        while (it.hasNext()) {
            RDFResource resource = (RDFResource)it.next();
            str = String.valueOf(str) + resource.getBrowserText();
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + " ";
        }
        return String.valueOf(str) + "}";
    }

    protected String getDisplayTextOfOWLRestriction(OWLRestriction restriction) {
        RDFProperty onProperty = restriction.getOnProperty();
        return String.valueOf(onProperty != null ? onProperty.getBrowserText() : "?") + " " + this.getSymbol(restriction) + " " + this.getOWLRestrictionFillerText(restriction);
    }

    protected String getOWLRestrictionFillerText(OWLRestriction restriction) {
        if (restriction instanceof OWLQuantifierRestriction) {
            RDFResource filler = ((OWLQuantifierRestriction)restriction).getFiller();
            if (filler instanceof RDFSClass) {
                return this.getNestedDisplayText((RDFSClass)filler);
            }
            return restriction.getFillerText();
        }
        return restriction.getFillerText();
    }

    protected String getDisplayTextOfOWLNAryLogicalClass(OWLNAryLogicalClass cls) {
        Collection operands = cls.getOperands();
        if (operands.size() == 0) {
            return "<empty " + cls.getClass() + ">";
        }
        String operator = this.getSymbol(cls);
        String text = "";
        Iterator it = operands.iterator();
        while (it.hasNext()) {
            RDFSClass operand = (RDFSClass)it.next();
            text = String.valueOf(text) + this.getNestedDisplayText(operand);
            if (!it.hasNext()) continue;
            text = String.valueOf(text) + " " + operator + " ";
        }
        return text;
    }

    protected String getNestedDisplayText(RDFSClass cls) {
        if (cls instanceof RDFSNamedClass || cls instanceof OWLEnumeratedClass || cls instanceof OWLComplementClass) {
            return this.getDisplayText(cls);
        }
        return "(" + this.getDisplayText(cls) + ")";
    }
}

