/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractOWLModelTestCase;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.util.Collection;

public class ParseEnumeratedClassesTestCase
extends AbstractOWLModelTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseEnumerationOfIndividuals() throws Exception {
        ProfilesManager.setProfile(this.owlModel, OWLProfiles.OWL_DL.getURI());
        OWLNamedClass genderCls = this.owlModel.createOWLNamedClass("Gender");
        genderCls.createInstance("male");
        genderCls.createInstance("female");
        String expression = "{male female}";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseEnumeratedClassesTestCase.assertTrue((boolean)(aClass instanceof OWLEnumeratedClass));
        OWLEnumeratedClass enumeratedClass = (OWLEnumeratedClass)aClass;
        Collection resources = enumeratedClass.getOneOf();
        ParseEnumeratedClassesTestCase.assertEquals((int)2, (int)resources.size());
        ParseEnumeratedClassesTestCase.assertTrue((boolean)resources.contains(this.owlModel.getRDFResourceByBrowserText("male")));
        ParseEnumeratedClassesTestCase.assertTrue((boolean)resources.contains(this.owlModel.getRDFResourceByBrowserText("female")));
    }

    public void testParseEnumerationOfClassesAndSlots() throws Exception {
        ProfilesManager.setProfile(this.owlModel, OWLProfiles.OWL_Full.getURI());
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("Male");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("hasChildren");
        String expression = "{Male hasChildren}";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseEnumeratedClassesTestCase.assertTrue((boolean)(aClass instanceof OWLEnumeratedClass));
        OWLEnumeratedClass enumeratedClass = (OWLEnumeratedClass)aClass;
        Collection resources = enumeratedClass.getOneOf();
        ParseEnumeratedClassesTestCase.assertEquals((int)2, (int)resources.size());
        ParseEnumeratedClassesTestCase.assertTrue((boolean)resources.contains(maleCls));
        ParseEnumeratedClassesTestCase.assertTrue((boolean)resources.contains(slot));
    }

    public void testParseEnumerationOfClassesAndSlotsInOWLDL() throws Exception {
        ProfilesManager.setProfile(this.owlModel, OWLProfiles.OWL_DL.getURI());
        this.owlModel.createOWLNamedClass("Male");
        this.owlModel.createOWLObjectProperty("hasChildren");
        String expression = "{Male hasChildren}";
        try {
            this.parser.parseClass(this.owlModel, expression);
            ParseEnumeratedClassesTestCase.assertFalse((String)"Expected to fail parsing!", (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

