/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class OWLFrameStoreTestCase
extends AbstractJenaTestCase {
    public void testAddIntersectionClass() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass operandCls = this.owlModel.createOWLNamedClass("Person");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(operandCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(testCls));
        intersectionCls.addSuperclass(testCls);
        OWLFrameStoreTestCase.assertEquals((int)1, (int)testCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)testCls.getEquivalentClasses().size());
        OWLFrameStoreTestCase.assertEquals((int)1, (int)intersectionCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)intersectionCls.getEquivalentClasses().size());
        testCls.addSuperclass(intersectionCls);
        testCls.removeSuperclass(this.owlThing);
        OWLFrameStoreTestCase.assertEquals((int)2, (int)testCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)testCls.getPureSuperclasses().size());
        OWLFrameStoreTestCase.assertTrue((boolean)testCls.isSubclassOf(operandCls));
        OWLFrameStoreTestCase.assertEquals((int)1, (int)testCls.getEquivalentClasses().size());
        OWLFrameStoreTestCase.assertEquals((int)1, (int)intersectionCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)1, (int)intersectionCls.getEquivalentClasses().size());
    }

    public void testAddNamedClsToIntersectionClass() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass operandCls = this.owlModel.createOWLNamedClass("Person");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(operandCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(testCls));
        testCls.addSuperclass(intersectionCls);
        OWLFrameStoreTestCase.assertEquals((int)2, (int)testCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)testCls.getEquivalentClasses().size());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)intersectionCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)intersectionCls.getEquivalentClasses().size());
        intersectionCls.addSuperclass(testCls);
        testCls.removeSuperclass(this.owlThing);
        OWLFrameStoreTestCase.assertEquals((int)2, (int)testCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)0, (int)testCls.getPureSuperclasses().size());
        OWLFrameStoreTestCase.assertTrue((boolean)testCls.isSubclassOf(operandCls));
        OWLFrameStoreTestCase.assertEquals((int)1, (int)testCls.getEquivalentClasses().size());
        OWLFrameStoreTestCase.assertEquals((int)1, (int)intersectionCls.getSuperclassCount());
        OWLFrameStoreTestCase.assertEquals((int)1, (int)intersectionCls.getEquivalentClasses().size());
    }

    public void testRemoveIntersectionCls() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass operandCls = this.owlModel.createOWLNamedClass("Person");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(operandCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(testCls));
        testCls.addEquivalentClass(intersectionCls);
        testCls.removeSuperclass(this.owlThing);
        OWLFrameStoreTestCase.assertSize(2, testCls.getSuperclasses(false));
        OWLFrameStoreTestCase.assertSize(0, testCls.getPureSuperclasses());
        OWLFrameStoreTestCase.assertSize(1, testCls.getEquivalentClasses());
        OWLFrameStoreTestCase.assertSize(1, intersectionCls.getEquivalentClasses());
        testCls.removeSuperclass(intersectionCls);
        OWLFrameStoreTestCase.assertSize(0, testCls.getSuperclasses(false));
    }

    public void testRemoveNamedClsFromIntersectionCls() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass operandCls = this.owlModel.createOWLNamedClass("Person");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(operandCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(testCls));
        testCls.addEquivalentClass(intersectionCls);
        testCls.removeSuperclass(this.owlThing);
        OWLFrameStoreTestCase.assertSize(2, testCls.getSuperclasses(false));
        OWLFrameStoreTestCase.assertSize(0, testCls.getPureSuperclasses());
        OWLFrameStoreTestCase.assertSize(1, testCls.getEquivalentClasses());
        OWLFrameStoreTestCase.assertSize(1, intersectionCls.getEquivalentClasses());
        intersectionCls.removeSuperclass(testCls);
        OWLFrameStoreTestCase.assertSize(1, testCls.getSuperclasses(false));
        OWLFrameStoreTestCase.assertTrue((boolean)(testCls.getSuperclasses(false).iterator().next() instanceof OWLIntersectionClass));
    }

    public void testDuplicateSuperclass() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass personCls = this.owlModel.createOWLNamedSubclass("Person", animalCls);
        Collection oldSuperclasses = personCls.getSuperclasses(false);
        personCls.addSuperclass(animalCls);
        OWLFrameStoreTestCase.assertEquals((Object)oldSuperclasses, (Object)personCls.getSuperclasses(false));
    }

    public void testDeleteEquivalentClsWithEquivalentNamedCls() {
        OWLNamedClass testCls = this.owlModel.createOWLNamedClass("Test");
        OWLNamedClass operandCls = this.owlModel.createOWLNamedClass("Operand");
        testCls.addEquivalentClass(operandCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(operandCls);
        intersectionCls.addOperand(this.owlModel.createOWLComplementClass(operandCls));
        testCls.addEquivalentClass(intersectionCls);
        OWLFrameStoreTestCase.assertSize(2, testCls.getEquivalentClasses());
        OWLFrameStoreTestCase.assertSize(1, testCls.getPureSuperclasses());
        OWLFrameStoreTestCase.assertEquals((Object)this.owlThing, testCls.getPureSuperclasses().iterator().next());
        OWLFrameStoreTestCase.assertSize(3, testCls.getSuperclasses(false));
        intersectionCls.removeSuperclass(testCls);
        OWLFrameStoreTestCase.assertSize(1, testCls.getEquivalentClasses());
        OWLFrameStoreTestCase.assertSize(2, testCls.getPureSuperclasses());
        testCls.removeSuperclass(intersectionCls);
        OWLFrameStoreTestCase.assertSize(1, testCls.getPureSuperclasses());
        OWLFrameStoreTestCase.assertEquals((Object)this.owlThing, testCls.getPureSuperclasses().iterator().next());
        OWLFrameStoreTestCase.assertSize(2, testCls.getSuperclasses(false));
    }

    public void testAddSuperclass() {
        OWLNamedClass r = this.owlModel.createOWLNamedClass("R");
        OWLNamedClass a = this.owlModel.createOWLNamedSubclass("A", r);
        OWLNamedClass b = this.owlModel.createOWLNamedSubclass("B", a);
        OWLFrameStoreTestCase.assertEquals((int)1, (int)b.getSuperclassCount());
        b.addSuperclass(r);
        OWLFrameStoreTestCase.assertEquals((int)2, (int)b.getSuperclassCount());
        OWLFrameStoreTestCase.assertTrue((boolean)b.getSuperclasses(false).contains(r));
        OWLFrameStoreTestCase.assertTrue((boolean)b.getSuperclasses(false).contains(a));
    }
}

