/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class SetClassTypeTestCase
extends AbstractJenaTestCase {
    public void testChangeNamedClsToRDFSClassSuperclasses() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("hasChildren");
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(slot, 1));
        SetClassTypeTestCase.assertSize(2, cls.getSuperclasses(false));
        cls.setProtegeType(this.owlModel.getRDFSNamedClassClass());
        SetClassTypeTestCase.assertSize(1, cls.getSuperclasses(false));
    }

    public void testChangeNamedClsToRDFSClassEquivalentClasses() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Parent", superCls);
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("hasChildren");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(slot, 1);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(superCls);
        intersectionCls.addOperand(restriction);
        cls.addEquivalentClass(intersectionCls);
        SetClassTypeTestCase.assertSize(2, cls.getSuperclasses(false));
        cls.setProtegeType(this.owlModel.getRDFSNamedClassClass());
        SetClassTypeTestCase.assertSize(1, cls.getSuperclasses(false));
        SetClassTypeTestCase.assertEquals((Object)superCls, cls.getSuperclasses(false).iterator().next());
    }
}

