/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class SetPropertyTypeTestCase
extends AbstractJenaTestCase {
    public void testDeleteRestrictionsOnD2O() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Cls");
        hostCls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        int oldCount = this.owlModel.getClsCount();
        hostCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, this.owlModel.getXSDstring()));
        property.setProtegeType(this.owlModel.getOWLObjectPropertyClass());
        SetPropertyTypeTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
        SetPropertyTypeTestCase.assertEquals((Object)this.owlModel.getOWLObjectPropertyClass(), (Object)property.getProtegeType());
        SetPropertyTypeTestCase.assertNull((Object)property.getRange());
    }

    public void testDeleteRestrictionsOnO2D() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Cls");
        hostCls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        int oldCount = this.owlModel.getClsCount();
        hostCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, hostCls));
        property.setProtegeType(this.owlModel.getOWLDatatypePropertyClass());
        SetPropertyTypeTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
        SetPropertyTypeTestCase.assertEquals((Object)this.owlModel.getOWLDatatypePropertyClass(), (Object)property.getProtegeType());
        SetPropertyTypeTestCase.assertNull((Object)property.getRange());
    }

    public void testDeleteNestedRestrictionsOnD2O() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Cls");
        hostCls.addSuperclass(this.owlModel.createOWLMinCardinality(slot, 1));
        int oldCount = this.owlModel.getClsCount();
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, this.owlModel.getXSDstring()));
        unionCls.addOperand(this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, this.owlModel.getXSDint()));
        hostCls.addSuperclass(unionCls);
        slot.setProtegeType(this.owlModel.getOWLObjectPropertyClass());
        SetPropertyTypeTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
        SetPropertyTypeTestCase.assertEquals((Object)this.owlModel.getOWLObjectPropertyClass(), (Object)slot.getProtegeType());
    }
}

