/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.jena.graph.JenaModelFactory;
import edu.stanford.smi.protegex.owl.model.DefaultTaskManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNames;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.TaskManager;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStoreManager;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.NoopProgressDisplay;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.project.DefaultOWLProject;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.model.query.SPARQLQueryResults;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTuple;
import edu.stanford.smi.protegex.owl.model.validator.DefaultPropertyValueValidator;
import edu.stanford.smi.protegex.owl.model.validator.PropertyValueValidator;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.ui.widget.OWLFormWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public abstract class AbstractOWLModel
extends DefaultKnowledgeBase
implements NamespaceManagerListener,
OWLModel {
    private static transient Logger log = Log.getLogger(AbstractOWLModel.class);
    private Cls owlAllDifferentClass;
    private Cls owlAnnotationPropertyClass;
    private Cls owlDeprecatedClassClass;
    private Cls owlDeprecatedPropertyClass;
    private Cls owlFunctionalPropertyClass;
    private Cls owlInverseFunctionalPropertyClass;
    private Cls owlSymmetricPropertyClass;
    private Cls owlTransitivePropertyClass;
    private Cls owlAllValuesFromClass;
    private Cls anonymousClassMetaCls;
    private Cls anonymousRootCls;
    private Cls owlDataRangeClass;
    private Cls owlEnumeratedClassClass;
    private Cls rdfExternalResourceClass;
    private Cls rdfListClass;
    private Cls owlOntologyClass;
    private Cls owlClassMetaCls;
    private Cls owlRestrictionClass;
    private Cls owlSomeValuesFromClass;
    private Cls owlHasValueClass;
    private Cls owlMinCardinalityClass;
    private Cls owlMaxCardinalityClass;
    private Cls owlCardinalityClass;
    private Cls owlLogicalClassClass;
    private Cls owlIntersectionClassClass;
    private Cls rdfStatementClass;
    private Cls rdfAltClass;
    private Cls rdfBagClass;
    private Cls rdfsNamedClassClass;
    private Cls rdfsContainerClass;
    private Cls rdfsDatatypeClass;
    private Cls rdfSeqClass;
    private Cls owlUnionClassClass;
    private Cls owlComplementClassClass;
    private Cls owlNamedClassClass;
    private Cls owlNothingClass;
    private Cls rdfsLiteralClass;
    private Cls rdfPropertyClass;
    private Cls owlDatatypePropertyClass;
    private Cls owlObjectPropertyClass;
    private Slot owlAllValuesFromProperty;
    private Slot owlBackwardCompatibleWithProperty;
    private Slot owlCardinalityProperty;
    private Slot owlComplementOfProperty;
    private Slot owlDisjointWithProperty;
    private Slot owlEquivalentClassProperty;
    private Slot owlValuesFromProperty;
    private Slot rdfsDomainProperty;
    private Slot rdfsRangeProperty;
    private Slot rdfsSubClassOfProperty;
    private Slot rdfsSubPropertyOfProperty;
    private Slot protegeClassificationStatusProperty;
    private Slot rdfsCommentProperty;
    private Slot owlDifferentFromProperty;
    private Slot owlDistinctMembersProperty;
    private Slot owlEquivalentPropertyProperty;
    private Slot owlHasValueProperty;
    private Slot owlIncompatibleWithProperty;
    private Slot owlInverseOfProperty;
    private Slot protegeInferredTypeProperty;
    private Slot protegeInferredSubclassesProperty;
    private Slot protegeInferredSuperclassesProperty;
    private Slot owlIntersectionOfProperty;
    private Slot rdfsIsDefinedByProperty;
    private Slot rdfsLabelProperty;
    private Slot owlLogicalOperandsProperty;
    private Slot owlMaxCardinalityProperty;
    private Slot owlMinCardinalityProperty;
    private Slot nameSlot;
    private Slot owlOnPropertyProperty;
    private Slot owlImportsProperty;
    private Slot owlOntologyPrefixesProperty;
    private Slot owlOneOfProperty;
    private Slot owlUnionOfProperty;
    private Slot owlPriorVersionProperty;
    private Slot rdfFirstProperty;
    private Slot rdfObjectProperty;
    private Slot rdfPredicateProperty;
    private Slot rdfRestSlot;
    private Slot rdfSubjectProperty;
    private Slot rdfTypeProperty;
    private Slot rdfValueProperty;
    private Slot rdfsMemberProperty;
    private Slot owlResourceURIProperty;
    private Slot owlSameAsProperty;
    private Slot rdfsSeeAlsoProperty;
    private Slot owlSomeValuesFromProperty;
    private Slot owlVersionInfoProperty;
    private Slot protegeSubclassesDisjointProperty;
    private RDFSDatatype xsdBoolean;
    private RDFSDatatype xsdDouble;
    private RDFSDatatype xsdFloat;
    private RDFSDatatype xsdLong;
    private RDFSDatatype xsdInt;
    private RDFSDatatype xsdShort;
    private RDFSDatatype xsdByte;
    private RDFSDatatype xsdString;
    private RDFSDatatype xsdBase64Binary;
    private RDFSDatatype xsdDate;
    private RDFSDatatype xsdTime;
    private RDFSDatatype xsdDateTime;
    private RDFSDatatype xsdDuration;
    private RDFSDatatype xsdAnyURI;
    private RDFSDatatype xsdDecimal;
    private RDFSDatatype xsdInteger;
    private RDFSDatatype xmlLiteralType;
    private Set floatDatatypes = new HashSet();
    private Set integerDatatypes = new HashSet();
    private int systemID = 9001;
    private boolean inInit = true;
    private Model jenaModel;
    public static final String ANONYMOUS_BASE = "@";
    private boolean bootstrapped = false;
    private OWLClassDisplay owlClassRenderer = OWLClassDisplayFactory.getDefaultDisplay();
    private OWLFrameStore owlFrameStore;
    private OWLProject owlProject;
    private PropertyValueValidator propertyValueValidator = new DefaultPropertyValueValidator();
    public static final String DEFAULT_TODO_PREFIX = "TODO";
    public static final String[] DEFAULT_USED_LANGUAGES = new String[]{"de", "en", "es", "fr", "it", "nl", "pt", "ru"};
    private boolean loadDefaults = true;
    private NamespaceManager namespaceManager;
    private Instance rdfNilIndividual;
    private OWLNamedClass owlThingClass;
    private static final String SEARCH_SYNONYMS_KEY = "OWL-SEARCH-SYNONYMS-SLOTS";
    private static final String SEARCH_SYNONYMS_SEPARATOR = ",";
    private static final String VALID_SYMBOLS = "-.";
    private Set defaultAnonymousTypes = new HashSet();
    public static final String DEFAULT_ANNOTATION_PROPERTY_NAME = "annotationProperty";
    public static final String DEFAULT_CLASS_NAME = "Class";
    public static final String DEFAULT_DATATYPE_PROPERTY_NAME = "datatypeProperty";
    public static final String DEFAULT_INDIVIDUAL_NAME = "Individual";
    public static final String DEFAULT_OBJECT_PROPERTY_NAME = "objectProperty";
    public static final String DEFAULT_PROPERTY_NAME = "property";
    private RDFSDatatypeFactory rdfsDatatypeFactory = new DefaultRDFSDatatypeFactory(this);
    private TaskManager taskManager;
    private RepositoryManager repositoryManager;
    private int anonCount = 1;
    private static final String AUTO_REPAIR_ENABLED = "TestAutoRepairEnabled";
    private static final String TEST_LIST_NAME = "DisabledTest";
    private static final String TESTGROUP_LIST_NAME = "DisabledTestGroups";
    private int lastGen = 1;

    public AbstractOWLModel(KnowledgeBaseFactory factory) {
        super(factory);
        this.resetSystemFrames();
    }

    public AbstractOWLModel(KnowledgeBaseFactory factory, NamespaceManager namespaceManager) {
        super(factory);
        this.resetSystemFrames();
        this.initialize(namespaceManager);
    }

    private void resetSystemFrames() {
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get((KnowledgeBase)this);
        if (mnfs == null) {
            this.adjustThing();
            this.initOWLFrameFactoryInvocationHandler();
            String name = this.getRootCls().getDirectType().getName();
            if (name.equals(":STANDARD-CLASS")) {
                this.bootstrap();
            }
        } else {
            NarrowFrameStore systemFrameStore = mnfs.getSystemFrameStore();
            NarrowFrameStore oldActiveFrameStore = mnfs.setActiveFrameStore(systemFrameStore);
            this.adjustThing();
            this.initOWLFrameFactoryInvocationHandler();
            this.bootstrap();
            mnfs.setActiveFrameStore(oldActiveFrameStore);
        }
    }

    public void initialize(NamespaceManager namespaceManager) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 2 initialization of OWL Model starts");
        }
        this.namespaceManager = namespaceManager;
        namespaceManager.addNamespaceManagerListener(this);
        this.setGenerateDeletingFrameEventsEnabled(true);
        this.inInit = false;
        namespaceManager.init(this);
        this.createDefaultOWLOntology();
        namespaceManager.setModifiable("owl", false);
        namespaceManager.setModifiable("rdf", false);
        namespaceManager.setModifiable("rdfs", false);
        namespaceManager.setModifiable("xsd", false);
        this.setDefaultClsMetaCls(this.owlNamedClassClass);
        this.setDefaultSlotMetaCls(this.owlDatatypePropertyClass);
        this.setFrameNameValidator(new FrameNameValidator(){

            public String getErrorMessage(String name, Frame frame) {
                if (frame instanceof RDFUntypedResource) {
                    return "The name \"" + name + "\" is not a valid URI.";
                }
                String validName = AbstractOWLModel.this.getValidNamespaceFrameName(name);
                return "The name \"" + name + "\" is not a valid OWL identifier.\n" + "You might want to use \"" + validName + "\" instead.";
            }

            public boolean isValid(String name, Frame frame) {
                if (frame != null && !frame.isEditable()) {
                    return true;
                }
                if (frame instanceof RDFUntypedResource) {
                    if (name.equals(name.trim()) && name.length() > 4) {
                        try {
                            new URI(name);
                            return true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                NamespaceManager nsm = AbstractOWLModel.this.getNamespaceManager();
                return AbstractOWLModel.isValidOWLFrameName(nsm, name);
            }
        });
        this.initOWLFrameStore();
        this.defaultAnonymousTypes.add(this.rdfListClass);
        this.defaultAnonymousTypes.add(this.owlAllValuesFromClass);
        this.defaultAnonymousTypes.add(this.owlSomeValuesFromClass);
        this.defaultAnonymousTypes.add(this.owlHasValueClass);
        this.defaultAnonymousTypes.add(this.owlMinCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlMaxCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlCardinalityClass);
        this.defaultAnonymousTypes.add(this.owlComplementClassClass);
        this.defaultAnonymousTypes.add(this.owlIntersectionClassClass);
        this.defaultAnonymousTypes.add(this.owlUnionClassClass);
        this.defaultAnonymousTypes.add(this.owlEnumeratedClassClass);
        this.defaultAnonymousTypes.add(this.owlAllDifferentClass);
        this.defaultAnonymousTypes.add(this.owlDataRangeClass);
        this.bootstrapped = true;
        this.taskManager = new DefaultTaskManager();
        this.taskManager.setProgressDisplay(new NoopProgressDisplay());
        if (super.getProject() != null) {
            this.setProject(super.getProject());
        }
    }

    public void addClassListener(ClassListener listener) {
        if (!(listener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.addClsListener(listener);
    }

    public void addModelListener(ModelListener listener) {
        if (!(listener instanceof ModelAdapter)) {
            throw new IllegalArgumentException("Listener must be a ModelAdapter");
        }
        this.addKnowledgeBaseListener(listener);
    }

    public void addPropertyListener(PropertyListener listener) {
        if (!(listener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyAdapter");
        }
        this.addSlotListener(listener);
    }

    public void addPropertyValueListener(PropertyValueListener listener) {
        if (!(listener instanceof PropertyValueAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyValueAdapter");
        }
        this.addFrameListener(listener);
    }

    public RDFSLiteral asRDFSLiteral(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof RDFSLiteral) {
            return (RDFSLiteral)value;
        }
        return this.createRDFSLiteral(value);
    }

    public RDFObject asRDFObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RDFExternalResource) {
            return null;
        }
        if (object instanceof RDFResource) {
            return (RDFObject)object;
        }
        return this.createRDFSLiteral(object);
    }

    public List asRDFSLiterals(Collection values) {
        LinkedList<RDFSLiteral> result = new LinkedList<RDFSLiteral>();
        for (Object o : values) {
            if (o instanceof String) {
                String str = (String)o;
                if (DefaultRDFSLiteral.isRawValue(str)) {
                    result.add(new DefaultRDFSLiteral(this, str));
                    continue;
                }
                result.add(this.createRDFSLiteral(o));
                continue;
            }
            result.add((RDFSLiteral)o);
        }
        return result;
    }

    public void addResourceListener(ResourceListener listener) {
        if (!(listener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        this.addInstanceListener(listener);
    }

    public void adjustSystemClasses() {
        Slot[] thingSlots = new Slot[]{this.nameSlot, this.rdfsLabelProperty, this.rdfsIsDefinedByProperty, this.rdfsSeeAlsoProperty, this.owlVersionInfoProperty, this.owlDifferentFromProperty, this.owlSameAsProperty, this.rdfValueProperty, this.rdfsMemberProperty, this.protegeInferredTypeProperty};
        int i = 0;
        while (i < thingSlots.length) {
            Slot slot = thingSlots[i];
            Collection oldDomain = slot.getDirectDomain();
            if (oldDomain.size() != 1 || !oldDomain.contains(this.owlThingClass)) {
                for (Cls oldDomainCls : new ArrayList(oldDomain)) {
                    oldDomainCls.removeDirectTemplateSlot(slot);
                }
                this.owlThingClass.addDirectTemplateSlot(slot);
            }
            ++i;
        }
    }

    public void adjustThing() {
        this.getRootCls().setName("owl:Thing");
    }

    public abstract void initOWLFrameFactoryInvocationHandler();

    protected void initOWLFrameStore() {
        if (!(this.getFrameStores().get(0) instanceof OWLFrameStore)) {
            this.owlFrameStore = new OWLFrameStore(this);
            this.insertFrameStore((FrameStore)this.owlFrameStore);
        }
    }

    private Cls createSystemCls(String name, Cls superclass) {
        return this.createSystemCls(name, Collections.singleton(superclass), superclass.getDirectType());
    }

    private Cls createSystemCls(String name, Collection superclasses, Cls type) {
        return this.createCls(FrameID.createSystem((int)this.systemID++), name, superclasses, Collections.singleton(type), false);
    }

    protected SystemFrames createSystemFrames() {
        SystemFrames systemFrames = super.createSystemFrames();
        systemFrames.replaceFrame((Frame)new DefaultRDFProperty(this, Model.SlotID.DIRECT_SUPERSLOTS));
        return systemFrames;
    }

    public void bootstrap() {
        this.nameSlot = this.getSlot(":NAME");
        Cls standardCls = this.getCls(":STANDARD-CLASS");
        this.anonymousRootCls = this.createSystemCls(":OWL-ANONYMOUS-ROOT", this.getCls(":SYSTEM-CLASS"));
        this.owlClassMetaCls = this.createSystemCls(":OWL-CLASS", this.getCls(":CLASS"));
        this.owlClassMetaCls.setAbstract(true);
        this.rdfsNamedClassClass = this.createSystemCls("rdfs:Class", Arrays.asList(this.getRootCls(), this.owlClassMetaCls, standardCls), standardCls);
        this.rdfsNamedClassClass.setDirectType(this.rdfsNamedClassClass);
        this.owlClassMetaCls.setDirectType(this.rdfsNamedClassClass);
        this.owlNamedClassClass = this.createSystemCls("owl:Class", this.rdfsNamedClassClass);
        this.owlNamedClassClass.setDirectType(this.owlNamedClassClass);
        this.owlNamedClassClass = this.getCls("owl:Class");
        this.rdfsNamedClassClass.setDirectType(this.owlNamedClassClass);
        this.rdfsNamedClassClass = this.getCls("rdfs:Class");
        this.getRootCls().setDirectType(this.owlNamedClassClass);
        this.anonymousRootCls.setDirectType(this.rdfsNamedClassClass);
        this.anonymousClassMetaCls = this.createSystemCls("owl:AnonymousClass", Collections.singleton(this.owlClassMetaCls), this.rdfsNamedClassClass);
        this.anonymousClassMetaCls.setAbstract(true);
        this.owlEnumeratedClassClass = this.createSystemCls("owl:EnumeratedClass", this.anonymousClassMetaCls);
        List<Cls> slotClassSupers = Arrays.asList(this.getRootCls(), this.getCls(":STANDARD-SLOT"));
        this.rdfPropertyClass = this.createSystemCls("rdf:Property", slotClassSupers, this.owlNamedClassClass);
        this.rdfPropertyClass = this.getCls("rdf:Property");
        this.owlDatatypePropertyClass = this.createSystemCls("owl:DatatypeProperty", this.rdfPropertyClass);
        this.owlObjectPropertyClass = this.createSystemCls("owl:ObjectProperty", this.rdfPropertyClass);
        this.rdfsDomainProperty = this.createSystemSlot("rdfs:domain", this.rdfPropertyClass);
        this.rdfsDomainProperty.setValueType(ValueType.INSTANCE);
        this.rdfsRangeProperty = this.createSystemSlot("rdfs:range", this.rdfPropertyClass);
        this.rdfsRangeProperty.setValueType(ValueType.INSTANCE);
        this.rdfPropertyClass.addDirectTemplateSlot(this.rdfsDomainProperty);
        this.rdfPropertyClass.addDirectTemplateSlot(this.rdfsRangeProperty);
        this.owlInverseOfProperty = this.getSlot(":SLOT-INVERSE");
        this.owlInverseOfProperty.setDirectType(this.rdfPropertyClass);
        this.owlInverseOfProperty = this.getSlot(":SLOT-INVERSE");
        this.owlInverseOfProperty.setName("owl:inverseOf");
        this.owlInverseOfProperty.setValueType(ValueType.INSTANCE);
        this.owlInverseOfProperty.setAllowedClses((Collection)Collections.singleton(this.owlObjectPropertyClass));
        this.rdfsDatatypeClass = this.createSystemCls("rdfs:Datatype", Collections.singleton(this.owlThingClass), this.rdfsNamedClassClass);
        this.initRDFDatatypes();
        this.owlAnnotationPropertyClass = this.createSystemCls("owl:AnnotationProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.initInferredSlots();
        this.initRestrictionMetaclasses();
        this.owlLogicalClassClass = this.createSystemCls("owl:LogicalClass", this.anonymousClassMetaCls);
        this.owlComplementClassClass = this.createSystemCls("owl:ComplementClass", this.owlLogicalClassClass);
        this.owlIntersectionClassClass = this.createSystemCls("owl:IntersectionClass", this.owlLogicalClassClass);
        this.owlUnionClassClass = this.createSystemCls("owl:UnionClass", this.owlLogicalClassClass);
        this.owlDifferentFromProperty = this.createInstanceSlot("owl:differentFrom", this.rdfPropertyClass, this.getRootCls());
        this.owlDifferentFromProperty.setAllowsMultipleValues(true);
        this.owlDifferentFromProperty.addOwnSlotValue(this.rdfsRangeProperty, (Object)this.getRootCls());
        this.owlSameAsProperty = this.createInstanceSlot("owl:sameAs", this.rdfPropertyClass, this.getRootCls());
        this.owlSameAsProperty.setAllowsMultipleValues(true);
        this.owlSameAsProperty.addOwnSlotValue(this.rdfsRangeProperty, (Object)this.getRootCls());
        this.owlDisjointWithProperty = this.createInstanceSlot("owl:disjointWith", this.rdfPropertyClass, this.rdfsNamedClassClass);
        this.owlDisjointWithProperty.setAllowsMultipleValues(true);
        this.owlClassMetaCls.addDirectTemplateSlot(this.owlDisjointWithProperty);
        this.owlComplementOfProperty = this.createInstanceSlot("owl:complementOf", this.rdfPropertyClass, this.owlClassMetaCls);
        this.owlComplementClassClass.addDirectTemplateSlot(this.owlComplementOfProperty);
        this.owlIntersectionOfProperty = this.createInstanceSlot("owl:intersectionOf", this.rdfPropertyClass, this.rdfListClass);
        this.owlIntersectionClassClass.addDirectTemplateSlot(this.owlIntersectionOfProperty);
        this.owlUnionOfProperty = this.createInstanceSlot("owl:unionOf", this.rdfPropertyClass, this.rdfListClass);
        this.owlUnionClassClass.addDirectTemplateSlot(this.owlUnionOfProperty);
        this.owlEquivalentPropertyProperty = this.createInstanceSlot("owl:equivalentProperty", this.rdfPropertyClass, this.rdfPropertyClass);
        this.owlEquivalentPropertyProperty.setAllowsMultipleValues(true);
        this.rdfPropertyClass.addDirectTemplateSlot(this.owlEquivalentPropertyProperty);
        this.owlDatatypePropertyClass.setTemplateSlotAllowedClses(this.owlEquivalentPropertyProperty, (Collection)Collections.singleton(this.owlDatatypePropertyClass));
        this.owlObjectPropertyClass.setTemplateSlotAllowedClses(this.owlEquivalentPropertyProperty, (Collection)Collections.singleton(this.owlObjectPropertyClass));
        this.rdfsSubClassOfProperty = this.createInstanceSlot("rdfs:subClassOf", this.rdfPropertyClass, this.owlClassMetaCls);
        this.rdfsSubClassOfProperty.setAllowsMultipleValues(true);
        this.rdfsSubClassOfProperty.setAllowedClses((Collection)Collections.singleton(this.rdfsNamedClassClass));
        this.rdfsSubClassOfProperty.setOwnSlotValue(this.rdfsRangeProperty, (Object)this.rdfsNamedClassClass);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.rdfsSubClassOfProperty);
        this.rdfsSubPropertyOfProperty = this.getSlot(":DIRECT-SUPERSLOTS");
        this.rdfsSubPropertyOfProperty.setName("rdfs:subPropertyOf");
        this.rdfsSubPropertyOfProperty.setDirectType(this.rdfPropertyClass);
        this.rdfsSubPropertyOfProperty = (RDFProperty)this.getSlot("rdfs:subPropertyOf");
        this.owlEquivalentClassProperty = this.createInstanceSlot("owl:equivalentClass", this.rdfPropertyClass, this.owlClassMetaCls);
        this.owlEquivalentClassProperty.setAllowsMultipleValues(true);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.owlEquivalentClassProperty);
        this.rdfsLabelProperty = this.createAnnotationOWLDatatypeProperty("rdfs:label");
        this.setStringRange(this.rdfsLabelProperty);
        this.rdfsIsDefinedByProperty = this.createAnnotationOWLObjectProperty("rdfs:isDefinedBy");
        this.rdfsSeeAlsoProperty = this.createAnnotationOWLObjectProperty("rdfs:seeAlso");
        this.owlVersionInfoProperty = this.createAnnotationOWLDatatypeProperty("owl:versionInfo");
        this.setStringRange(this.owlVersionInfoProperty);
        this.rdfsCommentProperty = this.createAnnotationOWLDatatypeProperty("rdfs:comment");
        this.setStringRange(this.rdfsCommentProperty);
        this.rdfValueProperty = this.createSystemSlot("rdf:value", this.rdfPropertyClass);
        this.rdfValueProperty.setAllowsMultipleValues(true);
        this.rdfValueProperty.setValueType(ValueType.ANY);
        this.rdfsMemberProperty = this.createSystemSlot("rdfs:member", this.rdfPropertyClass);
        this.rdfsMemberProperty.setValueType(ValueType.INSTANCE);
        this.owlThingClass.addDirectTemplateSlot(this.rdfsMemberProperty);
        this.adjustSystemClasses();
        Cls directedBinaryRelationCls = this.getCls(":DIRECTED-BINARY-RELATION");
        directedBinaryRelationCls.addDirectSuperclass(this.getRootCls());
        directedBinaryRelationCls.setDirectType(this.owlNamedClassClass);
        this.initOntologyMetaclass();
        this.rdfPropertyClass = this.getCls("rdf:Property");
        this.owlFunctionalPropertyClass = this.createSystemCls("owl:FunctionalProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlInverseFunctionalPropertyClass = this.createSystemCls("owl:InverseFunctionalProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlSymmetricPropertyClass = this.createSystemCls("owl:SymmetricProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlTransitivePropertyClass = this.createSystemCls("owl:TransitiveProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.rdfExternalResourceClass = this.createSystemCls("protege:ExternalResource", Collections.singleton(this.getRootCls()), this.rdfsNamedClassClass);
        this.owlResourceURIProperty = this.createSystemSlot(":OWL-RESOURCE-URI", this.rdfPropertyClass);
        this.owlResourceURIProperty.setValueType(ValueType.STRING);
        this.owlResourceURIProperty.setAllowsMultipleValues(false);
        this.rdfExternalResourceClass.addDirectTemplateSlot(this.owlResourceURIProperty);
        this.owlNothingClass = this.createSystemCls("owl:Nothing", this.getRootClses(), this.owlNamedClassClass);
        this.rdfListClass = this.createSystemCls("rdf:List", this.getRootClses(), this.owlNamedClassClass);
        this.rdfFirstProperty = this.createSystemSlot("rdf:first", this.rdfPropertyClass);
        this.rdfFirstProperty.setValueType(ValueType.ANY);
        this.rdfFirstProperty.setAllowsMultipleValues(false);
        this.rdfRestSlot = this.createSystemSlot("rdf:rest", this.rdfPropertyClass);
        this.rdfRestSlot.setAllowsMultipleValues(false);
        this.rdfRestSlot.setValueType(ValueType.INSTANCE);
        this.rdfRestSlot.setAllowedClses((Collection)Collections.singleton(this.rdfListClass));
        this.rdfListClass.addDirectTemplateSlot(this.rdfFirstProperty);
        this.rdfListClass.addDirectTemplateSlot(this.rdfRestSlot);
        this.rdfNilIndividual = this.createSystemInstance("rdf:nil", this.rdfListClass);
        this.owlAllDifferentClass = this.createSystemCls("owl:AllDifferent", Collections.singleton(this.owlThingClass), this.rdfsNamedClassClass);
        this.owlDistinctMembersProperty = this.createSystemSlot("owl:distinctMembers", this.rdfPropertyClass);
        this.owlDistinctMembersProperty.setValueType(ValueType.INSTANCE);
        this.owlDistinctMembersProperty.setAllowedClses((Collection)Collections.singleton(this.rdfListClass));
        this.owlAllDifferentClass.addDirectTemplateSlot(this.owlDistinctMembersProperty);
        this.rdfsLiteralClass = this.createSystemCls("rdfs:Literal", this.getRootClses(), this.owlNamedClassClass);
        this.rdfsContainerClass = this.createSystemCls("rdfs:Container", this.getRootClses(), this.rdfsNamedClassClass);
        this.rdfAltClass = this.createSystemCls("rdf:Alt", this.rdfsContainerClass);
        this.rdfBagClass = this.createSystemCls("rdf:Bag", this.rdfsContainerClass);
        this.rdfSeqClass = this.createSystemCls("rdf:Seq", this.rdfsContainerClass);
        this.rdfObjectProperty = this.createSystemSlot("rdf:object", this.rdfPropertyClass);
        this.rdfObjectProperty.setValueType(ValueType.INSTANCE);
        this.rdfPredicateProperty = this.createSystemSlot("rdf:predicate", this.rdfPropertyClass);
        this.rdfPredicateProperty.setValueType(ValueType.INSTANCE);
        this.rdfSubjectProperty = this.createSystemSlot("rdf:subject", this.rdfPropertyClass);
        this.rdfSubjectProperty.setValueType(ValueType.INSTANCE);
        this.rdfTypeProperty = this.createSystemSlot("rdf:type", this.rdfPropertyClass);
        this.rdfTypeProperty.setValueType(ValueType.CLS);
        this.owlThingClass.addDirectTemplateSlot(this.rdfTypeProperty);
        this.rdfStatementClass = this.createSystemCls("rdf:Statement", this.getRootClses(), this.rdfsNamedClassClass);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfObjectProperty);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfPredicateProperty);
        this.rdfStatementClass.addDirectTemplateSlot(this.rdfSubjectProperty);
        this.owlDeprecatedClassClass = this.createSystemCls("owl:DeprecatedClass", Collections.singleton(this.rdfsNamedClassClass), this.rdfsNamedClassClass);
        this.owlDeprecatedPropertyClass = this.createSystemCls("owl:DeprecatedProperty", Collections.singleton(this.rdfPropertyClass), this.rdfsNamedClassClass);
        this.owlDataRangeClass = this.createSystemCls("owl:DataRange", this.getRootClses(), this.rdfsNamedClassClass);
        this.owlOneOfProperty = this.createSystemSlot("owl:oneOf", this.rdfPropertyClass);
        this.owlOneOfProperty.setValueType(ValueType.INSTANCE);
        this.owlOneOfProperty.setAllowedClses((Collection)Collections.singleton(this.rdfListClass));
        this.owlDataRangeClass.addDirectTemplateSlot(this.owlOneOfProperty);
        this.owlEnumeratedClassClass.addDirectTemplateSlot(this.owlOneOfProperty);
        this.setAbstract(this.owlThingClass, false);
        this.owlThingClass.addOwnSlotValue(this.rdfTypeProperty, this.owlNamedClassClass);
        this.adjustProtegeSystemFrames();
        if (!(OWLNames.ClsID.THING.equals((Object)this.owlThingClass.getFrameID()) && RDFSNames.ClsID.NAMED_CLASS.equals((Object)this.rdfsNamedClassClass.getFrameID()) && RDFNames.ClsID.PROPERTY.equals((Object)this.rdfPropertyClass.getFrameID()))) {
            throw new RuntimeException("Fatal Metaclass Error: FrameIDs mismatch.  Perhaps a database rebuild required?");
        }
    }

    private Slot createSystemSlot(String name, Cls type) {
        return this.createSlot(FrameID.createSystem((int)this.systemID++), name, Collections.singleton(type), Collections.EMPTY_LIST, false);
    }

    private void adjustProtegeSystemFrames() {
        this.getCls(":DIRECTED-BINARY-RELATION").setDirectType(this.owlNamedClassClass);
        Slot toSlot = this.getSlot(":FROM");
        Slot fromSlot = this.getSlot(":TO");
        fromSlot.setDirectType(this.owlObjectPropertyClass);
        toSlot.setDirectType(this.owlObjectPropertyClass);
        Cls constraintCls = this.getCls(":PAL-CONSTRAINT");
        constraintCls.setDirectType(this.rdfsNamedClassClass);
        this.getSlot(":PAL-DESCRIPTION").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-NAME").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-RANGE").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":PAL-STATEMENT").setDirectType(this.owlDatatypePropertyClass);
        this.getSlot(":SLOT-CONSTRAINTS").setDirectType(this.owlObjectPropertyClass);
    }

    private void setStringRange(Slot slot) {
        Frame datatype = this.getFrame("xsd:string");
        slot.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)datatype);
        slot.setValueType(ValueType.STRING);
    }

    private void initRDFDatatypes() {
        TypeMapper typeMapper = TypeMapper.getInstance();
        Iterator it = typeMapper.listTypes();
        while (it.hasNext()) {
            RDFDatatype type = (RDFDatatype)it.next();
            String uri = type.getURI();
            if (!uri.startsWith("http://www.w3.org/2001/XMLSchema")) continue;
            String name = "xsd:" + uri.substring("http://www.w3.org/2001/XMLSchema".length() + 1);
            this.createSystemInstance(name, this.rdfsDatatypeClass);
        }
        this.createSystemInstance("rdf:XMLLiteral", this.rdfsDatatypeClass);
        this.fillDatatypeSet(XMLSchemaDatatypes.floatTypes, this.floatDatatypes);
        this.fillDatatypeSet(XMLSchemaDatatypes.integerTypes, this.integerDatatypes);
    }

    private void fillDatatypeSet(XSDDatatype[] types, Set set) {
        int i = 0;
        while (i < types.length) {
            XSDDatatype datatype = types[i];
            String name = "xsd:" + datatype.getURI().substring("http://www.w3.org/2001/XMLSchema".length() + 1);
            set.add(this.getFrame(name));
            ++i;
        }
    }

    private Instance createSystemInstance(String name, Cls type) {
        return this.createInstance(FrameID.createSystem((int)this.systemID++), name, type, false);
    }

    public TaskManager getTaskManager() {
        if (this.taskManager == null) {
            this.taskManager = new DefaultTaskManager();
        }
        return this.taskManager;
    }

    private void initOntologyMetaclass() {
        this.owlOntologyClass = this.createSystemCls("owl:Ontology", Collections.singleton(this.owlThingClass), this.owlNamedClassClass);
        this.owlOntologyPrefixesProperty = this.createSystemSlot(":OWL-ONTOLOGY-PREFIXES", this.rdfPropertyClass);
        this.owlOntologyPrefixesProperty.setAllowsMultipleValues(true);
        this.owlOntologyPrefixesProperty.setValueType(ValueType.STRING);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlOntologyPrefixesProperty);
        this.owlImportsProperty = this.createSystemSlot("owl:imports", this.rdfPropertyClass);
        this.owlImportsProperty.setAllowsMultipleValues(true);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlImportsProperty);
        this.owlBackwardCompatibleWithProperty = this.createAnnotationOWLObjectProperty("owl:backwardCompatibleWith");
        this.owlBackwardCompatibleWithProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlBackwardCompatibleWithProperty);
        this.owlIncompatibleWithProperty = this.createAnnotationOWLObjectProperty("owl:incompatibleWith");
        this.owlIncompatibleWithProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlIncompatibleWithProperty);
        this.owlPriorVersionProperty = this.createAnnotationOWLObjectProperty("owl:priorVersion");
        this.owlPriorVersionProperty.setAllowedClses((Collection)Collections.EMPTY_LIST);
        this.owlOntologyClass.addDirectTemplateSlot(this.owlPriorVersionProperty);
    }

    private void initRestrictionMetaclasses() {
        this.owlOnPropertyProperty = this.createSystemSlot("owl:onProperty", this.rdfPropertyClass);
        this.owlOnPropertyProperty.setValueType(ValueType.INSTANCE);
        this.owlOnPropertyProperty.setAllowedClses((Collection)Collections.singleton(this.rdfPropertyClass));
        this.owlRestrictionClass = this.createSystemCls("owl:Restriction", this.anonymousClassMetaCls);
        this.owlRestrictionClass.addDirectTemplateSlot(this.owlOnPropertyProperty);
        Cls metaclass = this.rdfsNamedClassClass;
        this.owlAllValuesFromProperty = this.createSystemSlot("owl:allValuesFrom", this.rdfPropertyClass);
        this.owlAllValuesFromClass = this.createSystemCls("owl:AllValuesFromRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlAllValuesFromClass.addDirectTemplateSlot(this.owlAllValuesFromProperty);
        this.owlHasValueProperty = this.createSystemSlot("owl:hasValue", this.rdfPropertyClass);
        this.owlHasValueProperty.setAllowsMultipleValues(false);
        this.owlHasValueClass = this.createSystemCls("owl:HasValueRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlHasValueClass.addDirectTemplateSlot(this.owlHasValueProperty);
        RDFSDatatype cardiRange = this.getXSDint();
        this.owlMaxCardinalityProperty = this.createSystemSlot("owl:maxCardinality", this.rdfPropertyClass);
        this.owlMaxCardinalityProperty.setAllowsMultipleValues(false);
        this.owlMaxCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlMaxCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)cardiRange);
        this.owlMaxCardinalityClass = this.createSystemCls("owl:MaxCardinalityRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlMaxCardinalityClass.addDirectTemplateSlot(this.owlMaxCardinalityProperty);
        this.owlMinCardinalityProperty = this.createSystemSlot("owl:minCardinality", this.rdfPropertyClass);
        this.owlMinCardinalityProperty.setAllowsMultipleValues(false);
        this.owlMinCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlMinCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)cardiRange);
        this.owlMinCardinalityClass = this.createSystemCls("owl:MinCardinalityRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlMinCardinalityClass.addDirectTemplateSlot(this.owlMinCardinalityProperty);
        this.owlCardinalityProperty = this.createSystemSlot("owl:cardinality", this.rdfPropertyClass);
        this.owlCardinalityProperty.setAllowsMultipleValues(false);
        this.owlCardinalityProperty.setValueType(ValueType.INTEGER);
        this.owlCardinalityProperty.setDirectOwnSlotValue(this.rdfsRangeProperty, (Object)cardiRange);
        this.owlCardinalityClass = this.createSystemCls("owl:CardinalityRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlCardinalityClass.addDirectTemplateSlot(this.owlCardinalityProperty);
        this.owlValuesFromProperty = this.createSystemSlot("owl:valuesFrom", this.rdfPropertyClass);
        this.owlValuesFromProperty.setAllowsMultipleValues(false);
        this.owlValuesFromProperty.setValueType(ValueType.INSTANCE);
        this.owlMaxCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlMinCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlCardinalityClass.addDirectTemplateSlot(this.owlValuesFromProperty);
        this.owlSomeValuesFromProperty = this.createSystemSlot("owl:someValuesFrom", this.rdfPropertyClass);
        this.owlSomeValuesFromClass = this.createSystemCls("owl:SomeValuesFromRestriction", Collections.singleton(this.owlRestrictionClass), metaclass);
        this.owlSomeValuesFromClass.addDirectTemplateSlot(this.owlSomeValuesFromProperty);
    }

    private void initInferredSlots() {
        this.protegeClassificationStatusProperty = this.createSystemSlot("protege:classificationStatus", this.rdfPropertyClass);
        this.protegeClassificationStatusProperty.setAllowsMultipleValues(false);
        this.protegeClassificationStatusProperty.setValueType(ValueType.BOOLEAN);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeClassificationStatusProperty);
        Cls standardCls = this.getCls(":OWL-CLASS");
        this.protegeInferredSubclassesProperty = this.createInstanceSlot("protege:inferredSuperclassOf", this.rdfPropertyClass, standardCls);
        this.protegeInferredSubclassesProperty.setAllowsMultipleValues(true);
        this.protegeInferredSuperclassesProperty = this.createInstanceSlot("protege:inferredSubclassOf", this.rdfPropertyClass, standardCls);
        this.protegeInferredSuperclassesProperty.setAllowsMultipleValues(true);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeInferredSubclassesProperty);
        this.rdfsNamedClassClass.addDirectTemplateSlot(this.protegeInferredSuperclassesProperty);
        this.protegeInferredTypeProperty = this.createInstanceSlot("protege:inferredType", this.rdfPropertyClass, standardCls);
        this.protegeInferredTypeProperty.setAllowsMultipleValues(true);
    }

    public void removeClassListener(ClassListener listener) {
        this.removeClsListener(listener);
    }

    public void removeModelListener(ModelListener listener) {
        this.removeKnowledgeBaseListener(listener);
    }

    public void removePropertyListener(PropertyListener listener) {
        this.removeSlotListener(listener);
    }

    public void removePropertyValueListener(PropertyValueListener listener) {
        this.removeFrameListener(listener);
    }

    public void removeResourceListener(ResourceListener listener) {
        this.removeInstanceListener(listener);
    }

    public void setOWLClassDisplay(OWLClassDisplay renderer) {
        assert (renderer != null);
        this.owlClassRenderer = renderer;
    }

    public OWLJavaFactory getOWLJavaFactory() {
        return (OWLJavaFactory)super.getFrameFactory();
    }

    public void setOWLJavaFactory(OWLJavaFactory factory) {
        super.setFrameFactory((FrameFactory)factory);
    }

    public void setOWLProject(OWLProject owlProject) {
        this.owlProject = owlProject;
    }

    public PropertyValueValidator getPropertyValueValidator() {
        return this.propertyValueValidator;
    }

    public boolean isValidPropertyValue(RDFResource subject, RDFProperty predicate, Object value) {
        if (this.getPropertyValueValidator() == null) {
            return true;
        }
        return this.getPropertyValueValidator().isValidPropertyValue(subject, predicate, value);
    }

    public void setPropertyValueValidator(PropertyValueValidator validator) {
        this.propertyValueValidator = validator;
    }

    public void copyFacetValuesIntoNamedClses() {
        this.owlFrameStore.copyFacetValuesIntoNamedClses();
    }

    public String createNewResourceName(String partialLocalName) {
        String prefix;
        String namespace;
        if (this.getTripleStoreModel().getActiveTripleStore() != this.getTripleStoreModel().getTopTripleStore() && (namespace = this.getTripleStoreModel().getActiveTripleStore().getDefaultNamespace()) != null && (prefix = this.getNamespaceManager().getPrefix(namespace)) != null && prefix.length() > 0) {
            return this.getUniqueFrameName(String.valueOf(prefix) + ":" + partialLocalName);
        }
        return this.getUniqueFrameName(partialLocalName);
    }

    public OWLAllDifferent createOWLAllDifferent() {
        return (OWLAllDifferent)this.createInstance(null, this.owlAllDifferentClass);
    }

    public OWLAllValuesFrom createOWLAllValuesFrom() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLAllValuesFrom)this.createCls(null, parents, this.owlAllValuesFromClass, false);
    }

    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty property, RDFResource filler) {
        OWLAllValuesFrom result = this.createOWLAllValuesFrom();
        result.setOnProperty(property);
        result.setFiller(filler);
        return result;
    }

    public OWLAllValuesFrom createOWLAllValuesFrom(RDFProperty property, RDFSLiteral[] oneOfValues) {
        OWLAllValuesFrom allRestriction = this.createOWLAllValuesFrom();
        allRestriction.setOnProperty(property);
        OWLDataRange dataRange = this.createOWLDataRange(oneOfValues);
        allRestriction.setFiller(dataRange);
        return allRestriction;
    }

    public OWLDatatypeProperty createAnnotationOWLDatatypeProperty(String name) {
        OWLDatatypeProperty property = this.createOWLDatatypeProperty(name);
        property.setAllowsMultipleValues(true);
        property.addDirectType(this.owlAnnotationPropertyClass);
        return property;
    }

    public OWLObjectProperty createAnnotationOWLObjectProperty(String name) {
        OWLObjectProperty property = this.createOWLObjectProperty(name);
        property.setAllowsMultipleValues(true);
        property.addDirectType(this.owlAnnotationPropertyClass);
        return property;
    }

    public OWLCardinality createOWLCardinality() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLCardinality)this.createCls(null, parents, this.owlCardinalityClass, false);
    }

    public OWLCardinality createOWLCardinality(RDFProperty property, int value) {
        OWLCardinality cardiRestriction = this.createOWLCardinality();
        cardiRestriction.setOnProperty(property);
        cardiRestriction.setCardinality(value);
        return cardiRestriction;
    }

    public OWLCardinality createOWLCardinality(RDFProperty property, int value, RDFSClass qualifier) {
        OWLCardinality owlCardinality = this.createOWLCardinality(property, value);
        owlCardinality.setValuesFrom(qualifier);
        return owlCardinality;
    }

    public synchronized Cls createCls(FrameID id, String name, Collection directSuperclasses, Collection directTypes, boolean loadDefaults) {
        if (this.bootstrapped && name == null) {
            name = this.isDefaultAnonymousType(directTypes) ? this.getNextAnonymousResourceName() : this.createUniqueNewFrameName(DEFAULT_CLASS_NAME);
        }
        return super.createCls(id, name, directSuperclasses, directTypes, loadDefaults);
    }

    public OWLComplementClass createOWLComplementClass() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLComplementClass)this.createCls(null, parents, this.owlComplementClassClass, false);
    }

    public OWLComplementClass createOWLComplementClass(RDFSClass complement) {
        OWLComplementClass complementCls = this.createOWLComplementClass();
        complementCls.setComplement(complement);
        return complementCls;
    }

    public OWLDataRange createOWLDataRange() {
        return (OWLDataRange)this.getOWLDataRangeClass().createAnonymousInstance();
    }

    public OWLDataRange createOWLDataRange(RDFSLiteral[] values) {
        OWLDataRange dataRange = this.createOWLDataRange();
        RDFList list = this.createRDFList(Arrays.asList(values).iterator());
        dataRange.setPropertyValue(this.getOWLOneOfProperty(), list);
        return dataRange;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String name) {
        return this.createOWLDatatypeProperty(name, (OWLNamedClass)this.owlDatatypePropertyClass);
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String name, OWLNamedClass metaCls) {
        if (name == null) {
            name = this.createUniqueNewFrameName("DatatypeProperty");
        }
        OWLDatatypeProperty slot = null;
        if (this.inInit) {
            slot = (OWLDatatypeProperty)this.createSystemSlot(name, metaCls);
            this.owlThingClass.addDirectTemplateSlot(slot);
        } else {
            slot = (OWLDatatypeProperty)this.createSlot(name, metaCls, this.loadDefaults);
        }
        slot.setAllowsMultipleValues(true);
        slot.setValueType(ValueType.ANY);
        return slot;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String name, RDFSDatatype datatype) {
        OWLDatatypeProperty property = this.createOWLDatatypeProperty(name);
        property.setAllowsMultipleValues(true);
        property.setRange(datatype);
        return property;
    }

    public OWLDatatypeProperty createOWLDatatypeProperty(String name, RDFSLiteral[] dataRangeLiterals) {
        OWLDatatypeProperty property = this.createOWLDatatypeProperty(name);
        OWLDataRange range = this.createOWLDataRange(dataRangeLiterals);
        property.setRange(range);
        return property;
    }

    private void createDefaultOWLOntology() {
        if (this.getDefaultOWLOntology() == null) {
            this.createDefaultOWLOntologyReally();
        }
    }

    protected void createDefaultOWLOntologyReally() {
        Instance ontology = this.createInstance(":", this.owlOntologyClass);
        ontology.setDirectOwnSlotValue(this.rdfTypeProperty, (Object)this.owlOntologyClass);
        this.getNamespaceManager().setDefaultNamespace("http://www.owl-ontologies.com/unnamed.owl#");
        this.getNamespaceManager().setPrefix(RDF.getURI(), "rdf");
        this.getNamespaceManager().setPrefix(RDFS.getURI(), "rdfs");
        this.getNamespaceManager().setPrefix("http://www.w3.org/2002/07/owl#", "owl");
        this.getNamespaceManager().setPrefix("http://www.w3.org/2001/XMLSchema#", "xsd");
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new OWLFrameStoreManager(this);
    }

    public OWLEnumeratedClass createOWLEnumeratedClass() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLEnumeratedClass)this.createCls(null, parents, this.owlEnumeratedClassClass, false);
    }

    public OWLEnumeratedClass createOWLEnumeratedClass(Collection instances) {
        OWLEnumeratedClass enumerationCls = this.createOWLEnumeratedClass();
        enumerationCls.setOneOf(instances);
        return enumerationCls;
    }

    public RDFExternalResource createRDFExternalResource(String uri) {
        throw new RuntimeException("The class RDFExternalResource has been replaced with RDFUntypedResource");
    }

    public OWLHasValue createOWLHasValue() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLHasValue)this.createCls(null, parents, this.owlHasValueClass, false);
    }

    public OWLHasValue createOWLHasValue(RDFProperty property, Object value) {
        OWLHasValue restriction = this.createOWLHasValue();
        restriction.setOnProperty(property);
        restriction.setHasValue(value);
        return restriction;
    }

    public synchronized Instance createInstance(FrameID id, String name, Collection directTypes, boolean initializeDefaults) {
        if (name == null) {
            if (this.isDefaultAnonymousType(directTypes)) {
                name = this.getNextAnonymousResourceName();
            } else {
                Cls firstType = (Cls)directTypes.iterator().next();
                if (firstType instanceof RDFSNamedClass) {
                    name = this.createNewResourceName(((RDFSClass)firstType).getLocalName());
                }
            }
        }
        return super.createInstance(id, name, directTypes, initializeDefaults);
    }

    private Slot createInstanceSlot(String name, Cls directType, Cls allowedCls) {
        Slot slot = this.createSystemSlot(name, directType);
        slot.setValueType(ValueType.INSTANCE);
        slot.setAllowedClses(CollectionUtilities.createCollection((Object)allowedCls));
        return slot;
    }

    public OWLIntersectionClass createOWLIntersectionClass() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLIntersectionClass)this.createCls(null, parents, this.owlIntersectionClassClass, false);
    }

    public OWLIntersectionClass createOWLIntersectionClass(Collection clses) {
        OWLIntersectionClass intersectionCls = this.createOWLIntersectionClass();
        for (RDFSClass cls : clses) {
            intersectionCls.addOperand(cls);
        }
        return intersectionCls;
    }

    public RDFList createRDFList() {
        return (RDFList)this.rdfListClass.createDirectInstance(null);
    }

    public RDFList createRDFList(Iterator values) {
        return this.createListInstance(values, this.rdfListClass);
    }

    public RDFSClass createRDFSClassFromExpression(String parsableExpression) {
        try {
            OWLClassParser parser = this.getOWLClassDisplay().getParser();
            return parser.parseClass(this, parsableExpression);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public RDFSDatatype createRDFSDatatype(String name) {
        return (RDFSDatatype)this.rdfsDatatypeClass.createDirectInstance(name);
    }

    private RDFList createListInstance(Iterator values, Cls listCls) {
        RDFList li;
        if (!values.hasNext()) {
            return this.getRDFNil();
        }
        RDFList currentNode = li = (RDFList)listCls.createDirectInstance(null);
        while (values.hasNext()) {
            Object value = values.next();
            currentNode.setFirst(value);
            if (!values.hasNext()) continue;
            RDFList rest = (RDFList)listCls.createDirectInstance(null);
            currentNode.setRest(rest);
            currentNode = rest;
        }
        currentNode.setRest((RDFList)this.rdfNilIndividual);
        return li;
    }

    public OWLMaxCardinality createOWLMaxCardinality() {
        Collection parents = Collections.singleton(this.getAnonymousRootCls());
        return (OWLMaxCardinality)this.createCls(null, parents, this.owlMaxCardinalityClass, false);
    }

    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty property, int value) {
        OWLMaxCardinality maxCardiRestriction = this.createOWLMaxCardinality();
        maxCardiRestriction.setOnProperty(property);
        maxCardiRestriction.setCardinality(value);
        return maxCardiRestriction;
    }

    public OWLMaxCardinality createOWLMaxCardinality(RDFProperty property, int value, RDFSClass qualifier) {
        OWLMaxCardinality owlMaxCardinality = this.createOWLMaxCardinality(property, value);
        owlMaxCardinality.setValuesFrom(qualifier);
        return owlMaxCardinality;
    }

    public OWLMinCardinality createOWLMinCardinality() {
        Collection parents = Collections.singleton(this.anonymousRootCls);
        return (OWLMinCardinality)this.createCls(null, parents, this.owlMinCardinalityClass, false);
    }

    public OWLMinCardinality createOWLMinCardinality(RDFProperty property, int value) {
        OWLMinCardinality minCardiRestriction = this.createOWLMinCardinality();
        minCardiRestriction.setOnProperty(property);
        minCardiRestriction.setCardinality(value);
        return minCardiRestriction;
    }

    public OWLMinCardinality createOWLMinCardinality(RDFProperty property, int value, RDFSClass qualifier) {
        OWLMinCardinality owlMinCardinality = this.createOWLMinCardinality(property, value);
        owlMinCardinality.setValuesFrom(qualifier);
        return owlMinCardinality;
    }

    public OWLNamedClass createOWLNamedClass(String name) {
        return this.createOWLNamedClass(name, this.loadDefaults);
    }

    public OWLNamedClass createOWLNamedClass(String name, boolean loadDefaults) {
        return (OWLNamedClass)this.createCls(name, this.getRootClses(), this.owlNamedClassClass, loadDefaults);
    }

    public OWLNamedClass createOWLNamedClass(String name, OWLNamedClass metaCls) {
        return (OWLNamedClass)this.createCls(name, this.getRootClses(), metaCls, this.loadDefaults);
    }

    public OWLNamedClass createOWLNamedSubclass(String name, OWLNamedClass superclass) {
        OWLNamedClass result = this.createOWLNamedClass(name);
        if (!superclass.equals(this.getOWLThingClass())) {
            result.addSuperclass(superclass);
            result.removeSuperclass(this.getOWLThingClass());
        }
        return result;
    }

    public OWLObjectProperty createOWLObjectProperty(String name) {
        return this.createOWLObjectProperty(name, (OWLNamedClass)this.owlObjectPropertyClass);
    }

    public OWLObjectProperty createOWLObjectProperty(String name, OWLNamedClass metaCls) {
        if (name == null) {
            name = this.createUniqueNewFrameName("ObjectProperty");
        }
        OWLObjectProperty result = null;
        result = this.inInit ? (OWLObjectProperty)this.createSystemSlot(name, metaCls) : (OWLObjectProperty)this.createSlot(name, metaCls, this.loadDefaults);
        result.setAllowsMultipleValues(true);
        result.setValueType(ValueType.INSTANCE);
        return result;
    }

    public OWLObjectProperty createOWLObjectProperty(String name, Collection allowedClasses) {
        OWLObjectProperty slot = this.createOWLObjectProperty(name);
        slot.setUnionRangeClasses(allowedClasses);
        return slot;
    }

    public OWLOntology createOWLOntology(String prefix) {
        return (OWLOntology)this.createInstance(String.valueOf(prefix) + ":", this.owlOntologyClass);
    }

    public OWLOntology createOWLOntology(String name, String uri) {
        String prefix = this.getNamespaceManager().getPrefix(uri);
        return this.createOWLOntology(prefix);
    }

    public RDFSNamedClass createRDFSNamedClass(String name) {
        return this.createRDFSNamedClass(name, true);
    }

    public RDFSNamedClass createRDFSNamedClass(String name, boolean loadDefaults) {
        return (RDFSNamedClass)this.createCls(name, this.getRootClses(), this.rdfsNamedClassClass, loadDefaults);
    }

    public RDFSNamedClass createRDFSNamedClass(String name, Collection parents, RDFSClass rdfType) {
        return (RDFSNamedClass)this.createCls(name, parents, rdfType);
    }

    public RDFSNamedClass createRDFSNamedSubclass(String name, RDFSNamedClass superclass) {
        RDFSNamedClass result = this.createRDFSNamedClass(name);
        if (!superclass.equals(this.getOWLThingClass())) {
            result.addSuperclass(superclass);
            result.removeSuperclass(this.getOWLThingClass());
        }
        return result;
    }

    public RDFUntypedResource createRDFUntypedResource(String uri) {
        Instance instance = this.rdfExternalResourceClass.createDirectInstance(uri);
        return (RDFUntypedResource)instance;
    }

    public RDFProperty createRDFProperty(String name) {
        if (name == null) {
            name = this.createUniqueNewFrameName("RDFProperty");
        }
        RDFProperty property = (RDFProperty)this.createSlot(name, this.rdfPropertyClass, this.loadDefaults);
        property.setValueType(ValueType.ANY);
        property.setAllowsMultipleValues(true);
        return property;
    }

    public Triple createTriple(RDFResource subject, RDFProperty predicate, Object object) {
        return new DefaultTriple(subject, predicate, object);
    }

    public Set getAllImports() {
        HashSet<String> imports = new HashSet<String>();
        for (Object curImport : this.getOWLOntologies()) {
            OWLOntology ontology = (OWLOntology)curImport;
            for (Object impo : ontology.getImports()) {
                if (impo instanceof RDFResource) {
                    imports.add(((RDFResource)impo).getURI());
                    continue;
                }
                if (!(impo instanceof String)) continue;
                imports.add((String)impo);
            }
        }
        return imports;
    }

    public RDFSNamedClass createSubclass(String name, RDFSNamedClass superclass) {
        return (RDFSNamedClass)this.createCls(name, Collections.singleton(superclass));
    }

    public RDFSNamedClass createSubclass(String name, Collection superclasses) {
        return (RDFSNamedClass)this.createCls(name, superclasses);
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLSomeValuesFrom)this.createCls(null, parents, this.owlSomeValuesFromClass, false);
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty property, RDFResource filler) {
        OWLSomeValuesFrom someRestriction = this.createOWLSomeValuesFrom();
        someRestriction.setOnProperty(property);
        someRestriction.setFiller(filler);
        return someRestriction;
    }

    public OWLSomeValuesFrom createOWLSomeValuesFrom(RDFProperty property, RDFSLiteral[] oneOfValues) {
        OWLSomeValuesFrom someRestriction = this.createOWLSomeValuesFrom();
        someRestriction.setOnProperty(property);
        OWLDataRange dataRange = this.createOWLDataRange(oneOfValues);
        someRestriction.setFiller(dataRange);
        return someRestriction;
    }

    public RDFProperty createSubproperty(String name, RDFProperty superProperty) {
        return (RDFProperty)this.createSlot(name, superProperty.getProtegeType(), Collections.singleton(superProperty), true);
    }

    public boolean endTransaction() {
        return this.commitTransaction();
    }

    public QueryResults executeSPARQLQuery(String partialQueryText) throws Exception {
        String queryString = String.valueOf(SPARQLQueryResults.createPrefixDeclarations(this)) + partialQueryText;
        return SPARQLQueryResults.create(this, queryString);
    }

    public OWLUnionClass createOWLUnionClass() {
        Collection parents = CollectionUtilities.createCollection((Object)this.anonymousRootCls);
        return (OWLUnionClass)this.createCls(null, parents, this.owlUnionClassClass, false);
    }

    public OWLUnionClass createOWLUnionClass(Collection clses) {
        OWLUnionClass unionCls = this.createOWLUnionClass();
        for (RDFSClass cls : clses) {
            unionCls.addOperand(cls);
        }
        return unionCls;
    }

    public RDFSLiteral createRDFSLiteral(Object value) {
        return DefaultRDFSLiteral.create(this, value);
    }

    public RDFSLiteral createRDFSLiteral(String lexicalValue, RDFSDatatype datatype) {
        return DefaultRDFSLiteral.create((OWLModel)this, lexicalValue, datatype);
    }

    public RDFSLiteral createRDFSLiteral(String value, String language) {
        return DefaultRDFSLiteral.create((OWLModel)this, value, language);
    }

    public Object createRDFSLiteralOrString(String value, String language) {
        if (language != null && (language = language.trim()).length() > 0) {
            return this.createRDFSLiteral(value, language);
        }
        return value;
    }

    public static void deleteAllFrames(OWLModel owlModel) {
        OWLModel kb = owlModel;
        for (Instance instance : kb.getInstances()) {
            if (instance instanceof Cls || !instance.isEditable() && !instance.isIncluded() || instance.isSystem()) continue;
            kb.deleteFrame((Frame)instance);
        }
        ArrayList<Cls> metaClasses = new ArrayList<Cls>();
        for (Cls cls : owlModel.getUserDefinedOWLNamedClasses()) {
            if (!cls.isEditable() && !cls.isIncluded() || cls.isSystem() || !cls.isMetaCls()) continue;
            metaClasses.add(cls);
        }
        for (Cls cls : metaClasses) {
            for (Frame frame : cls.getInstances()) {
                kb.deleteFrame(frame);
            }
        }
        for (Cls cls : owlModel.getUserDefinedOWLNamedClasses()) {
            if (cls.getDirectType() == null || !cls.isEditable() && !cls.isIncluded() || cls.isSystem()) continue;
            kb.deleteFrame((Frame)cls);
        }
    }

    public void deleteCls(Cls cls) {
        if (cls instanceof OWLAnonymousClass && cls.getDirectSubclassCount() == 1) {
            Cls subCls = (Cls)cls.getDirectSubclasses().iterator().next();
            subCls.removeDirectSuperclass(cls);
            return;
        }
        super.deleteCls(cls);
    }

    public boolean ensureProtegeMetaOntologyImported() {
        OWLOntology owlOntology = this.getDefaultOWLOntology();
        for (String im : owlOntology.getImports()) {
            if (!im.equals(ProtegeNames.FILE)) continue;
            return false;
        }
        owlOntology.addImports(ProtegeNames.FILE);
        this.ensureProtegePrefixExists();
        return true;
    }

    private void ensureProtegePrefixExists() {
        if (this.getNamespaceManager().getPrefix(ProtegeNames.NS) == null) {
            String prefix = "protege";
            this.getNamespaceManager().setPrefix(ProtegeNames.NS, prefix);
            this.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/2005/08/07/xsp.owl#", "xsp");
        }
    }

    public Collection getOWLAllDifferents() {
        RDFSNamedClass metaCls = this.getOWLAllDifferentClass();
        return metaCls.getDirectInstances();
    }

    public RDFSNamedClass getOWLAllDifferentClass() {
        return (RDFSNamedClass)this.owlAllDifferentClass;
    }

    public Collection getOWLAnnotationProperties() {
        ArrayList<Slot> result = new ArrayList<Slot>();
        for (Slot slot : this.getSlots()) {
            if (!(slot instanceof RDFProperty) || !((RDFProperty)slot).isAnnotationProperty()) continue;
            result.add(slot);
        }
        return result;
    }

    public Cls getAnonymousRootCls() {
        return this.anonymousRootCls;
    }

    public synchronized String getBrowserText(Instance instance) {
        if (instance instanceof RDFResource) {
            if (instance instanceof OWLAnonymousClass) {
                return instance.getBrowserText();
            }
            if (instance.isDeleted()) {
                return "<deleted>";
            }
            Cls directType = instance.getDirectType();
            if (this.getProject() == null) {
                return this.getName((Frame)instance);
            }
            if (directType == null) {
                return this.getMissingTypeString(instance);
            }
            BrowserSlotPattern slotPattern = this.getProject().getBrowserSlotPattern(instance.getDirectType());
            if (slotPattern == null) {
                return this.getDisplaySlotNotSetString(instance);
            }
            String value = null;
            List elements = slotPattern.getElements();
            Slot slot = slotPattern.getFirstSlot();
            if (elements.size() == 1 && slot != null && !slot.equals(this.nameSlot) && slot.getValueType() == ValueType.STRING) {
                RDFSLiteral literal;
                String defaultLanguage = this.getDefaultLanguage();
                Collection values = null;
                values = slot instanceof RDFProperty ? ((RDFResource)instance).getPropertyValues((RDFProperty)slot) : instance.getOwnSlotValues(slot);
                if (defaultLanguage != null) {
                    for (Object rawText : values) {
                        if (!(rawText instanceof RDFSLiteral) || !defaultLanguage.equals((literal = (RDFSLiteral)rawText).getLanguage())) continue;
                        value = literal.getString();
                        break;
                    }
                }
                if (value == null) {
                    for (Object rawText : values) {
                        if (rawText instanceof RDFSLiteral) {
                            literal = (RDFSLiteral)rawText;
                            if (literal.getLanguage() != null) continue;
                            value = literal.getString();
                        } else {
                            value = rawText.toString();
                        }
                        break;
                    }
                }
            } else {
                value = slotPattern.getBrowserText(instance);
            }
            if (value == null) {
                value = this.getDisplaySlotPatternValueNotSetString(instance, slotPattern);
            }
            return value;
        }
        return super.getBrowserText(instance);
    }

    public Collection getChangedInferredClasses() {
        return this.getClsesWithClassificationStatus(3);
    }

    public RDFSNamedClass getCommonSuperclass(Collection classes) {
        HashSet<RDFSClass> cs = new HashSet<RDFSClass>();
        Iterator it = classes.iterator();
        RDFSNamedClass firstClass = (RDFSNamedClass)it.next();
        Collection supers = firstClass.getSuperclasses(true);
        for (RDFSClass superclass : supers) {
            if (!(superclass instanceof RDFSNamedClass)) continue;
            cs.add(superclass);
        }
        while (it.hasNext()) {
            RDFSNamedClass namedClass = (RDFSNamedClass)it.next();
            HashSet ss = new HashSet(namedClass.getSuperclasses(true));
            Iterator sit = cs.iterator();
            while (sit.hasNext()) {
                RDFSNamedClass c = (RDFSNamedClass)sit.next();
                if (ss.contains(c)) continue;
                sit.remove();
            }
        }
        ArrayList copy = new ArrayList(cs);
        for (RDFSNamedClass namedClass : copy) {
            cs.removeAll(namedClass.getSuperclasses(true));
        }
        return (RDFSNamedClass)cs.iterator().next();
    }

    public RDFProperty getProtegeClassificationStatusProperty() {
        return (RDFProperty)this.protegeClassificationStatusProperty;
    }

    private Collection getClsesWithClassificationStatus(int status) {
        RDFProperty slot = this.getProtegeClassificationStatusProperty();
        Collection matches = this.getFramesWithValue(slot, null, false, new Integer(status));
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (Frame frame : matches) {
            if (!(frame instanceof OWLNamedClass)) continue;
            result.add(frame);
        }
        return result;
    }

    public OWLDatatypeProperty getOWLDatatypeProperty(String name) {
        return (OWLDatatypeProperty)this.getSlot(name);
    }

    public OWLNamedClass getOWLDatatypePropertyClass() {
        return (OWLNamedClass)this.owlDatatypePropertyClass;
    }

    public RDFSNamedClass getOWLDeprecatedClassClass() {
        return (RDFSNamedClass)this.owlDeprecatedClassClass;
    }

    public String getDefaultLanguage() {
        String value;
        OWLOntology oi;
        RDFProperty metaSlot;
        if (this.isProtegeMetaOntologyImported() && (metaSlot = this.getRDFProperty(ProtegeNames.getDefaultLanguageSlotName())) != null && (oi = this.getDefaultOWLOntology()) != null && (value = (String)oi.getPropertyValue(metaSlot)) != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    public OWLOntology getDefaultOWLOntology() {
        return (OWLOntology)this.getFrame(":");
    }

    public Collection getDomainlessProperties() {
        return this.getRootCls().getDirectTemplateSlots();
    }

    public Set getFloatDatatypes() {
        return this.floatDatatypes;
    }

    public Set getIntegerDatatypes() {
        return this.integerDatatypes;
    }

    public RDFProperty getOWLDifferentFromProperty() {
        return (RDFProperty)this.owlDifferentFromProperty;
    }

    public RDFProperty getOWLDisjointWithProperty() {
        return (RDFProperty)this.owlDisjointWithProperty;
    }

    public RDFProperty getOWLEquivalentPropertyProperty() {
        return (RDFProperty)this.owlEquivalentPropertyProperty;
    }

    public RDFProperty getOWLOneOfProperty() {
        return (RDFProperty)this.owlOneOfProperty;
    }

    public OWLProject getOWLProject() {
        return this.owlProject;
    }

    public RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager(this);
            RepositoryFileManager man = new RepositoryFileManager(this);
            man.loadGlobalRepositories();
        }
        return this.repositoryManager;
    }

    public RDFExternalResource getRDFExternalResource(String uri) {
        for (RDFExternalResource eri : this.getRDFUntypedResourcesClass().getInstances(false)) {
            if (!uri.equals(eri.getResourceURI())) continue;
            return eri;
        }
        return null;
    }

    public RDFSClass getRDFExternalResourceClass() {
        return (RDFSNamedClass)this.rdfExternalResourceClass;
    }

    public RDFProperty getRDFFirstProperty() {
        return (RDFProperty)this.rdfFirstProperty;
    }

    public Collection getInconsistentClasses() {
        return this.getOWLNothing().getInferredSubclasses();
    }

    public Model getJenaModel() {
        if (this.jenaModel == null) {
            this.jenaModel = JenaModelFactory.createModel(this);
        }
        return this.jenaModel;
    }

    public RDFSNamedClass getOWLAnnotationPropertyClass() {
        return (RDFSNamedClass)this.owlAnnotationPropertyClass;
    }

    public OWLClassParser getOWLClassParser() {
        return this.getOWLClassDisplay().getParser();
    }

    public OWLClassDisplay getOWLClassDisplay() {
        return this.owlClassRenderer;
    }

    public RDFProperty getProtegeInferredSubclassesProperty() {
        return (RDFProperty)this.protegeInferredSubclassesProperty;
    }

    public RDFProperty getProtegeInferredSuperclassesProperty() {
        return (RDFProperty)this.protegeInferredSuperclassesProperty;
    }

    public RDFProperty getRDFSDomainProperty() {
        return (RDFProperty)this.rdfsDomainProperty;
    }

    public RDFProperty getRDFSIsDefinedByProperty() {
        return (RDFProperty)this.rdfsIsDefinedByProperty;
    }

    public RDFProperty getRDFSLabelProperty() {
        return (RDFProperty)this.rdfsLabelProperty;
    }

    public int getRDFResourceCount() {
        return this.getFrameCount() - 54;
    }

    public Collection getRDFResources() {
        Collection frames = this.getFrames();
        return AbstractOWLModel.getRDFResources(this, frames);
    }

    public Collection getRDFResourcesWithPropertyValue(RDFProperty property, Object value) {
        Collection frames = this.getFramesWithValue(property, null, false, value);
        return AbstractOWLModel.getRDFResources(this, frames);
    }

    public static Collection getRDFResources(KnowledgeBase kb, Collection frames) {
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (Frame frame : frames) {
            if (!(frame instanceof RDFResource)) continue;
            result.add(frame);
        }
        AbstractOWLModel.removeProtegeSystemResources(kb, result);
        return result;
    }

    public RDFSNamedClass getRDFListClass() {
        return (RDFSNamedClass)this.rdfListClass;
    }

    public RDFUntypedResource getRDFUntypedResource(String uri, boolean createOnDemand) {
        RDFUntypedResource r = (RDFUntypedResource)this.getFrame(uri);
        if (createOnDemand && r == null) {
            r = this.createRDFUntypedResource(uri);
        }
        return r;
    }

    public RDFSNamedClass getRDFUntypedResourcesClass() {
        return (RDFSNamedClass)this.rdfExternalResourceClass;
    }

    public Collection getResourceNameMatches(String nameExpression, int maxMatches) {
        Collection frames = this.getFrameNameMatches(nameExpression, maxMatches);
        return AbstractOWLModel.getRDFResources(this, frames);
    }

    public RDFSNamedClass getOWLDataRangeClass() {
        return (RDFSNamedClass)this.owlDataRangeClass;
    }

    public RDFProperty getOWLIntersectionOfProperty() {
        return (RDFProperty)this.owlIntersectionOfProperty;
    }

    public OWLNamedClass getOWLNamedClass(String name) {
        return (OWLNamedClass)this.getCls(name);
    }

    public OWLNamedClass getOWLNamedClassClass() {
        return (OWLNamedClass)this.owlNamedClassClass;
    }

    public RDFProperty getOWLValuesFromProperty() {
        return (RDFProperty)this.owlValuesFromProperty;
    }

    public Collection getMatchingResources(RDFProperty property, String matchString, int maxMatches) {
        Collection frames = this.getMatchingFrames(property, null, false, matchString, maxMatches);
        return AbstractOWLModel.getRDFResources(this, frames);
    }

    public String getNextAnonymousResourceName() {
        String name;
        while (this.getFrame(name = ANONYMOUS_BASE + this.anonCount) != null) {
            ++this.anonCount;
        }
        return name;
    }

    public RDFList getRDFNil() {
        return (RDFList)this.rdfNilIndividual;
    }

    public Collection getRDFProperties() {
        return AbstractOWLModel.getRDFResources(this, this.getSlots());
    }

    public RDFResource getRDFResource(String name) {
        return (RDFResource)this.getFrame(name);
    }

    public RDFResource getRDFResourceAs(String name, Class javaInterface) {
        RDFResource resource = this.getRDFResource(name);
        if (resource != null) {
            return resource.as(javaInterface);
        }
        return null;
    }

    public OWLIndividual getOWLIndividual(String name) {
        return (OWLIndividual)this.getFrame(name);
    }

    public OWLNamedClass getOWLNothing() {
        return (OWLNamedClass)this.owlNothingClass;
    }

    public Collection getOWLRestrictionsOnProperty(RDFProperty property) {
        return this.getFramesWithValue(this.owlOnPropertyProperty, null, false, property);
    }

    public Collection getSearchSynonymProperties() {
        HashSet<Frame> results = new HashSet<Frame>();
        String syns = this.getOWLProject().getSettingsMap().getString(SEARCH_SYNONYMS_KEY);
        if (syns != null) {
            String[] ss = syns.split(SEARCH_SYNONYMS_SEPARATOR);
            int i = 0;
            while (i < ss.length) {
                String s = ss[i];
                Frame frame = this.getFrame(s);
                if (frame instanceof Slot) {
                    results.add(frame);
                }
                ++i;
            }
        }
        return results;
    }

    public OWLObjectProperty getOWLObjectProperty(String name) {
        return (OWLObjectProperty)this.getSlot(name);
    }

    public OWLNamedClass getOWLObjectPropertyClass() {
        return (OWLNamedClass)this.owlObjectPropertyClass;
    }

    public Collection getOWLOntologies() {
        return this.owlOntologyClass.getInstances();
    }

    public OWLOntology getOWLOntologyByURI(String uri) {
        OWLOntology ont = null;
        try {
            URI properURI = new URI(uri);
            ont = (OWLOntology)this.getOWLOntologyByURI(properURI);
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        return ont;
    }

    public RDFResource getOWLOntologyByURI(URI uri) {
        String prefix;
        String uriString = uri.toString();
        if (!uriString.endsWith("/") && !uriString.endsWith("#")) {
            uriString = String.valueOf(uriString) + "#";
        }
        String name = (prefix = this.getNamespaceManager().getPrefix(uriString)) != null ? String.valueOf(prefix) + ":" : ":";
        return this.getRDFResource(name);
    }

    public OWLNamedClass getOWLOntologyClass() {
        return (OWLNamedClass)this.owlOntologyClass;
    }

    public Collection getOWLOntologyProperties() {
        return Arrays.asList(this.owlBackwardCompatibleWithProperty, this.owlIncompatibleWithProperty, this.owlPriorVersionProperty);
    }

    public Collection getOWLClasses() {
        return this.getRDFSClasses();
    }

    public OWLFrameStore getOWLFrameStore() {
        return this.owlFrameStore;
    }

    public RDFSNamedClass getOWLFunctionalPropertyClass() {
        return (RDFSNamedClass)this.owlFunctionalPropertyClass;
    }

    public RDFSNamedClass getOWLInverseFunctionalPropertyClass() {
        return (RDFSNamedClass)this.owlInverseFunctionalPropertyClass;
    }

    public Collection getOWLIndividuals() {
        return this.getOWLIndividuals(false);
    }

    public Collection getOWLIndividuals(boolean onlyVisibleClasses) {
        Collection result = this.getRDFIndividuals(this.listOWLNamedClasses(), onlyVisibleClasses);
        Iterator it = this.listOWLAnonymousClasses();
        while (it.hasNext()) {
            OWLAnonymousClass c = (OWLAnonymousClass)it.next();
            Collection instances = c.getInstances(false);
            for (Instance instance : instances) {
                result.add(instance);
            }
        }
        return result;
    }

    public OWLProperty getOWLProperty(String name) {
        return (OWLProperty)this.getSlot(name);
    }

    public Collection getOWLSystemResources() {
        ArrayList result = new ArrayList(Arrays.asList(this.getOWLSystemFramesArray()));
        result.addAll(this.rdfsDatatypeClass.getDirectInstances());
        return result;
    }

    protected Frame[] getOWLSystemFramesArray() {
        this.nameSlot = this.getSlot(":NAME");
        Frame[] frameArray = new Frame[87];
        this.owlAllValuesFromClass = this.getCls("owl:AllValuesFromRestriction");
        frameArray[0] = this.owlAllValuesFromClass;
        this.anonymousClassMetaCls = this.getCls("owl:AnonymousClass");
        frameArray[1] = this.anonymousClassMetaCls;
        this.anonymousRootCls = this.getCls(":OWL-ANONYMOUS-ROOT");
        frameArray[2] = this.anonymousRootCls;
        this.owlCardinalityClass = this.getCls("owl:CardinalityRestriction");
        frameArray[3] = this.owlCardinalityClass;
        this.owlComplementClassClass = this.getCls("owl:ComplementClass");
        frameArray[4] = this.owlComplementClassClass;
        this.owlEnumeratedClassClass = this.getCls("owl:EnumeratedClass");
        frameArray[5] = this.owlEnumeratedClassClass;
        this.owlHasValueClass = this.getCls("owl:HasValueRestriction");
        frameArray[6] = this.owlHasValueClass;
        this.owlIntersectionClassClass = this.getCls("owl:IntersectionClass");
        frameArray[7] = this.owlIntersectionClassClass;
        this.owlLogicalClassClass = this.getCls("owl:LogicalClass");
        frameArray[8] = this.owlLogicalClassClass;
        this.owlMaxCardinalityClass = this.getCls("owl:MaxCardinalityRestriction");
        frameArray[9] = this.owlMaxCardinalityClass;
        this.owlMinCardinalityClass = this.getCls("owl:MinCardinalityRestriction");
        frameArray[10] = this.owlMinCardinalityClass;
        this.owlOntologyPrefixesProperty = this.getSlot(":OWL-ONTOLOGY-PREFIXES");
        frameArray[11] = this.owlOntologyPrefixesProperty;
        this.owlRestrictionClass = this.getCls("owl:Restriction");
        frameArray[12] = this.owlRestrictionClass;
        this.owlSomeValuesFromClass = this.getCls("owl:SomeValuesFromRestriction");
        frameArray[13] = this.owlSomeValuesFromClass;
        this.owlUnionClassClass = this.getCls("owl:UnionClass");
        frameArray[14] = this.owlUnionClassClass;
        this.rdfExternalResourceClass = this.getCls("protege:ExternalResource");
        frameArray[15] = this.rdfExternalResourceClass;
        this.owlResourceURIProperty = this.getSlot(":OWL-RESOURCE-URI");
        frameArray[16] = this.owlResourceURIProperty;
        this.protegeClassificationStatusProperty = this.getSlot("protege:classificationStatus");
        frameArray[17] = this.protegeClassificationStatusProperty;
        this.protegeInferredTypeProperty = this.getSlot("protege:inferredType");
        frameArray[18] = this.protegeInferredTypeProperty;
        this.protegeInferredSubclassesProperty = this.getSlot("protege:inferredSuperclassOf");
        frameArray[19] = this.protegeInferredSubclassesProperty;
        this.protegeInferredSuperclassesProperty = this.getSlot("protege:inferredSubclassOf");
        frameArray[20] = this.protegeInferredSuperclassesProperty;
        this.owlAllDifferentClass = this.getCls("owl:AllDifferent");
        frameArray[21] = this.owlAllDifferentClass;
        this.owlAllValuesFromProperty = this.getSlot("owl:allValuesFrom");
        frameArray[22] = this.owlAllValuesFromProperty;
        this.owlAnnotationPropertyClass = this.getCls("owl:AnnotationProperty");
        frameArray[23] = this.owlAnnotationPropertyClass;
        this.owlBackwardCompatibleWithProperty = this.getSlot("owl:backwardCompatibleWith");
        frameArray[24] = this.owlBackwardCompatibleWithProperty;
        this.owlCardinalityProperty = this.getSlot("owl:cardinality");
        frameArray[25] = this.owlCardinalityProperty;
        this.rdfsCommentProperty = this.getSlot("rdfs:comment");
        frameArray[26] = this.rdfsCommentProperty;
        this.owlComplementOfProperty = this.getSlot("owl:complementOf");
        frameArray[27] = this.owlComplementOfProperty;
        this.owlDataRangeClass = this.getCls("owl:DataRange");
        frameArray[28] = this.owlDataRangeClass;
        this.owlDatatypePropertyClass = this.getCls("owl:DatatypeProperty");
        frameArray[29] = this.owlDatatypePropertyClass;
        this.rdfsDomainProperty = this.getSlot("rdfs:domain");
        frameArray[30] = this.rdfsDomainProperty;
        this.owlDeprecatedClassClass = this.getCls("owl:DeprecatedClass");
        frameArray[31] = this.owlDeprecatedClassClass;
        this.owlDeprecatedPropertyClass = this.getCls("owl:DeprecatedProperty");
        frameArray[32] = this.owlDeprecatedPropertyClass;
        this.owlFunctionalPropertyClass = this.getCls("owl:FunctionalProperty");
        frameArray[33] = this.owlFunctionalPropertyClass;
        this.owlInverseFunctionalPropertyClass = this.getCls("owl:InverseFunctionalProperty");
        frameArray[34] = this.owlInverseFunctionalPropertyClass;
        this.owlSymmetricPropertyClass = this.getCls("owl:SymmetricProperty");
        frameArray[35] = this.owlSymmetricPropertyClass;
        this.owlTransitivePropertyClass = this.getCls("owl:TransitiveProperty");
        frameArray[36] = this.owlTransitivePropertyClass;
        this.owlDifferentFromProperty = this.getSlot("owl:differentFrom");
        frameArray[37] = this.owlDifferentFromProperty;
        this.owlDisjointWithProperty = this.getSlot("owl:disjointWith");
        frameArray[38] = this.owlDisjointWithProperty;
        this.owlDistinctMembersProperty = this.getSlot("owl:distinctMembers");
        frameArray[39] = this.owlDistinctMembersProperty;
        this.owlEquivalentClassProperty = this.getSlot("owl:equivalentClass");
        frameArray[40] = this.owlEquivalentClassProperty;
        this.owlEquivalentPropertyProperty = this.getSlot("owl:equivalentProperty");
        frameArray[41] = this.owlEquivalentPropertyProperty;
        this.rdfFirstProperty = this.getSlot("rdf:first");
        frameArray[42] = this.rdfFirstProperty;
        this.owlHasValueProperty = this.getSlot("owl:hasValue");
        frameArray[43] = this.owlHasValueProperty;
        this.owlIncompatibleWithProperty = this.getSlot("owl:incompatibleWith");
        frameArray[44] = this.owlIncompatibleWithProperty;
        this.owlIntersectionOfProperty = this.getSlot("owl:intersectionOf");
        frameArray[45] = this.owlIntersectionOfProperty;
        this.owlValuesFromProperty = this.getSlot("owl:valuesFrom");
        frameArray[46] = this.owlValuesFromProperty;
        this.rdfsIsDefinedByProperty = this.getSlot("rdfs:isDefinedBy");
        frameArray[47] = this.rdfsIsDefinedByProperty;
        this.rdfsLabelProperty = this.getSlot("rdfs:label");
        frameArray[48] = this.rdfsLabelProperty;
        this.rdfListClass = this.getCls("rdf:List");
        frameArray[49] = this.rdfListClass;
        this.rdfsLiteralClass = this.getCls("rdfs:Literal");
        frameArray[50] = this.rdfsLiteralClass;
        this.rdfsSubPropertyOfProperty = this.getSlot("rdfs:subPropertyOf");
        frameArray[51] = this.rdfsSubPropertyOfProperty;
        this.rdfsSubClassOfProperty = this.getSlot("rdfs:subClassOf");
        frameArray[52] = this.rdfsSubClassOfProperty;
        this.owlInverseOfProperty = this.getSlot("owl:inverseOf");
        frameArray[53] = this.owlInverseOfProperty;
        this.owlMaxCardinalityProperty = this.getSlot("owl:maxCardinality");
        frameArray[54] = this.owlMaxCardinalityProperty;
        this.owlMinCardinalityProperty = this.getSlot("owl:minCardinality");
        frameArray[55] = this.owlMinCardinalityProperty;
        this.owlNamedClassClass = this.getCls("owl:Class");
        frameArray[56] = this.owlNamedClassClass;
        this.rdfNilIndividual = this.getInstance("rdf:nil");
        frameArray[57] = this.rdfNilIndividual;
        this.owlNothingClass = this.getCls("owl:Nothing");
        frameArray[58] = this.owlNothingClass;
        this.owlObjectPropertyClass = this.getCls("owl:ObjectProperty");
        frameArray[59] = this.owlObjectPropertyClass;
        this.owlOnPropertyProperty = this.getSlot("owl:onProperty");
        frameArray[60] = this.owlOnPropertyProperty;
        this.owlOntologyClass = this.getCls("owl:Ontology");
        frameArray[61] = this.owlOntologyClass;
        this.owlImportsProperty = this.getSlot("owl:imports");
        frameArray[62] = this.owlImportsProperty;
        this.owlClassMetaCls = this.getCls(":OWL-CLASS");
        frameArray[63] = this.owlClassMetaCls;
        this.owlOneOfProperty = this.getSlot("owl:oneOf");
        frameArray[64] = this.owlOneOfProperty;
        this.rdfPropertyClass = this.getCls("rdf:Property");
        frameArray[65] = this.rdfPropertyClass;
        this.owlPriorVersionProperty = this.getSlot("owl:priorVersion");
        frameArray[66] = this.owlPriorVersionProperty;
        this.rdfObjectProperty = this.getSlot("rdf:object");
        frameArray[67] = this.rdfObjectProperty;
        this.rdfPredicateProperty = this.getSlot("rdf:predicate");
        frameArray[68] = this.rdfPredicateProperty;
        this.rdfsRangeProperty = this.getSlot("rdfs:range");
        frameArray[69] = this.rdfsRangeProperty;
        this.rdfStatementClass = this.getCls("rdf:Statement");
        frameArray[70] = this.rdfStatementClass;
        this.rdfSubjectProperty = this.getSlot("rdf:subject");
        frameArray[71] = this.rdfSubjectProperty;
        this.rdfTypeProperty = this.getSlot("rdf:type");
        frameArray[72] = this.rdfTypeProperty;
        this.rdfValueProperty = this.getSlot("rdf:value");
        frameArray[73] = this.rdfValueProperty;
        this.rdfsNamedClassClass = this.getCls("rdfs:Class");
        frameArray[74] = this.rdfsNamedClassClass;
        this.rdfAltClass = this.getCls("rdf:Alt");
        frameArray[75] = this.rdfAltClass;
        this.rdfBagClass = this.getCls("rdf:Bag");
        frameArray[76] = this.rdfBagClass;
        this.rdfsContainerClass = this.getCls("rdfs:Container");
        frameArray[77] = this.rdfsContainerClass;
        this.rdfsDatatypeClass = this.getCls("rdfs:Datatype");
        frameArray[78] = this.rdfsDatatypeClass;
        this.rdfsMemberProperty = this.getSlot("rdfs:member");
        frameArray[79] = this.rdfsMemberProperty;
        this.rdfSeqClass = this.getCls("rdf:Seq");
        frameArray[80] = this.rdfSeqClass;
        this.rdfRestSlot = this.getSlot("rdf:rest");
        frameArray[81] = this.rdfRestSlot;
        this.owlSameAsProperty = this.getSlot("owl:sameAs");
        frameArray[82] = this.owlSameAsProperty;
        this.rdfsSeeAlsoProperty = this.getSlot("rdfs:seeAlso");
        frameArray[83] = this.rdfsSeeAlsoProperty;
        this.owlSomeValuesFromProperty = this.getSlot("owl:someValuesFrom");
        frameArray[84] = this.owlSomeValuesFromProperty;
        this.owlUnionOfProperty = this.getSlot("owl:unionOf");
        frameArray[85] = this.owlUnionOfProperty;
        this.owlVersionInfoProperty = this.getSlot("owl:versionInfo");
        frameArray[86] = this.owlVersionInfoProperty;
        return frameArray;
    }

    public OWLNamedClass getOWLThingClass() {
        return (OWLNamedClass)this.getRootCls();
    }

    public RDFProperty getProtegeAllowedParentProperty() {
        return this.getRDFProperty(String.valueOf(ProtegeNames.PROTEGE_PREFIX) + ":" + "allowedParent");
    }

    public ValueType getOWLValueType(String uri) {
        return XMLSchemaDatatypes.getValueType(uri);
    }

    public RDFIndividual getRDFIndividual(String name) {
        return (RDFIndividual)this.getFrame(name);
    }

    public Collection getRDFIndividuals() {
        return this.getRDFIndividuals(false);
    }

    public Collection getRDFIndividuals(boolean onlyVisibleClasses) {
        return this.getRDFIndividuals(this.listRDFSNamedClasses(), onlyVisibleClasses);
    }

    private Collection getRDFIndividuals(Iterator it, boolean onlyVisibleClasses) {
        HashSet<Instance> result = new HashSet<Instance>();
        while (it.hasNext()) {
            RDFSNamedClass c = (RDFSNamedClass)it.next();
            if (!c.isVisible() && onlyVisibleClasses) continue;
            Collection instances = c.getInstances(false);
            for (Instance instance : instances) {
                if (!(instance instanceof RDFIndividual) || instance instanceof OWLOntology || instance instanceof RDFList || instance instanceof OWLAllDifferent) continue;
                result.add(instance);
            }
        }
        return result;
    }

    public RDFSNamedClass getRDFSNamedClassClass() {
        return (RDFSNamedClass)this.rdfsNamedClassClass;
    }

    public RDFSNamedClass getRDFSNamedClass(String name) {
        return (RDFSNamedClass)this.getCls(name);
    }

    public RDFProperty getRDFProperty(String name) {
        return (RDFProperty)this.getSlot(name);
    }

    public RDFSNamedClass getRDFPropertyClass() {
        return (RDFSNamedClass)this.rdfPropertyClass;
    }

    public OWLDatatypeProperty getProtegeReadOnlyProperty() {
        if (this.isProtegeMetaOntologyImported()) {
            return (OWLDatatypeProperty)this.getSlot(ProtegeNames.getReadOnlySlotName());
        }
        return null;
    }

    public RDFSDatatype getRDFSDatatypeByName(String name) {
        return (RDFSDatatype)this.getFrame(name);
    }

    public RDFSDatatype getRDFSDatatypeByURI(String uri) {
        for (RDFSDatatype datatype : this.getRDFSDatatypes()) {
            if (!uri.equals(datatype.getURI())) continue;
            return datatype;
        }
        return null;
    }

    public RDFSDatatype getRDFSDatatypeOfValue(Object valueOrRDFSLiteral) {
        if (valueOrRDFSLiteral instanceof RDFSLiteral) {
            return ((RDFSLiteral)valueOrRDFSLiteral).getDatatype();
        }
        return DefaultRDFSLiteral.create(this, valueOrRDFSLiteral).getDatatype();
    }

    public Collection getRDFSDatatypes() {
        ArrayList<RDFResource> results = new ArrayList<RDFResource>();
        for (RDFResource datatype : this.rdfsDatatypeClass.getDirectInstances()) {
            if (datatype.isAnonymous()) continue;
            results.add(datatype);
        }
        return results;
    }

    public RDFProperty getRDFRestProperty() {
        return (RDFProperty)this.rdfRestSlot;
    }

    public RDFSDatatype getRDFXMLLiteralType() {
        if (this.xmlLiteralType == null) {
            this.xmlLiteralType = this.getRDFSDatatypeByName("rdf:XMLLiteral");
        }
        return this.xmlLiteralType;
    }

    public RDFSNamedClass[] getOWLRestrictionMetaclasses() {
        return new RDFSNamedClass[]{(RDFSNamedClass)this.owlAllValuesFromClass, (RDFSNamedClass)this.owlSomeValuesFromClass, (RDFSNamedClass)this.owlHasValueClass, (RDFSNamedClass)this.owlCardinalityClass, (RDFSNamedClass)this.owlMinCardinalityClass, (RDFSNamedClass)this.owlMaxCardinalityClass};
    }

    public synchronized Cls getRootCls() {
        if (this.owlThingClass == null) {
            this.owlThingClass = new DefaultOWLNamedClass(this, Model.ClsID.THING);
        }
        return this.owlThingClass;
    }

    public synchronized Cls getRootSlotMetaCls() {
        return this.getCls("rdf:Property");
    }

    public RDFProperty getOWLSameAsProperty() {
        return (RDFProperty)this.owlSameAsProperty;
    }

    public RDFProperty getOWLUnionOfProperty() {
        return (RDFProperty)this.owlUnionOfProperty;
    }

    public Cls getRDFSClassMetaClassCls() {
        return this.rdfsNamedClassClass;
    }

    public Cls getOWLNamedClassMetaClassCls() {
        return this.owlNamedClassClass;
    }

    public Cls getOWLDatatypePropertyMetaClassCls() {
        return this.owlDatatypePropertyClass;
    }

    public Cls getOWLObjectPropertyMetaClassCls() {
        return this.owlObjectPropertyClass;
    }

    public Cls getOWLAllDifferentClassCls() {
        return this.owlAllDifferentClass;
    }

    public Cls getRDFListCls() {
        return this.rdfListClass;
    }

    public Cls getOWLOntologyCls() {
        return this.owlOntologyClass;
    }

    public RDFProperty getProtegeSubclassesDisjointProperty() {
        if (this.isProtegeMetaOntologyImported()) {
            if (this.protegeSubclassesDisjointProperty == null) {
                this.protegeSubclassesDisjointProperty = this.getSlot(ProtegeNames.getSubclassesDisjointSlotName());
            }
            return (RDFProperty)this.protegeSubclassesDisjointProperty;
        }
        return null;
    }

    public RDFProperty getRDFTypeProperty() {
        return (RDFProperty)this.rdfTypeProperty;
    }

    public RDFProperty[] getSystemAnnotationProperties() {
        return new RDFProperty[]{(RDFProperty)this.rdfsSeeAlsoProperty, (RDFProperty)this.rdfsIsDefinedByProperty, (RDFProperty)this.rdfsLabelProperty, (RDFProperty)this.owlVersionInfoProperty, (RDFProperty)this.owlBackwardCompatibleWithProperty, (RDFProperty)this.owlIncompatibleWithProperty, (RDFProperty)this.owlPriorVersionProperty, (RDFProperty)this.rdfsCommentProperty};
    }

    public String getTodoAnnotationPrefix() {
        String value;
        OWLOntology oi;
        RDFProperty metaSlot = this.getRDFProperty(ProtegeNames.getTodoPrefixSlotName());
        if (metaSlot != null && (oi = this.getDefaultOWLOntology()) != null && (value = (String)oi.getPropertyValue(metaSlot)) != null) {
            return value;
        }
        return DEFAULT_TODO_PREFIX;
    }

    public OWLDatatypeProperty getTodoAnnotationProperty() {
        Object slot;
        OWLOntology oi;
        RDFProperty metaSlot = this.getRDFProperty(ProtegeNames.getTodoPropertySlotName());
        if (metaSlot != null && (oi = this.getDefaultOWLOntology()) != null && (slot = oi.getPropertyValue(metaSlot)) instanceof OWLDatatypeProperty) {
            return (OWLDatatypeProperty)slot;
        }
        return (OWLDatatypeProperty)this.getSlot("owl:versionInfo");
    }

    public String[] getUsedLanguages() {
        Collection values;
        OWLOntology oi;
        RDFProperty metaSlot;
        if (this.isProtegeMetaOntologyImported() && (metaSlot = this.getRDFProperty(ProtegeNames.getUsedLanguagesSlotName())) != null && (oi = this.getDefaultOWLOntology()) != null && (values = oi.getPropertyValues(metaSlot)).size() > 0) {
            return values.toArray(new String[0]);
        }
        return DEFAULT_USED_LANGUAGES;
    }

    public Collection getUserDefinedOWLNamedClasses() {
        return this.getUserDefinedInstances(this.owlNamedClassClass);
    }

    public Collection getUserDefinedRDFIndividuals(boolean onlyVisibleClasses) {
        ArrayList<RDFResource> result = new ArrayList<RDFResource>();
        for (RDFResource resource : this.getRDFIndividuals(onlyVisibleClasses)) {
            if (resource.isSystem()) continue;
            result.add(resource);
        }
        return result;
    }

    private Collection getUserDefinedInstances(Cls cls) {
        Collection instances = cls.getInstances();
        return this.getUserDefinedInstances(instances);
    }

    private Collection getUserDefinedInstances(Collection instances) {
        ArrayList<Frame> results = new ArrayList<Frame>();
        for (Frame frame : instances) {
            if (frame.isSystem()) continue;
            results.add(frame);
        }
        return results;
    }

    public Collection getUserDefinedOWLProperties() {
        ArrayList instances = new ArrayList();
        instances.addAll(this.owlDatatypePropertyClass.getInstances());
        instances.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getUserDefinedInstances(instances);
    }

    public Collection getUserDefinedOWLObjectProperties() {
        ArrayList instances = new ArrayList();
        instances.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getUserDefinedInstances(instances);
    }

    public Collection getUserDefinedOWLDatatypeProperties() {
        ArrayList instances = new ArrayList();
        instances.addAll(this.owlDatatypePropertyClass.getInstances());
        return this.getUserDefinedInstances(instances);
    }

    public Collection getUserDefinedRDFProperties() {
        return this.getUserDefinedInstances(this.rdfPropertyClass);
    }

    public Collection getUserDefinedRDFSNamedClasses() {
        return this.getUserDefinedInstances(this.rdfsNamedClassClass);
    }

    public String getValueTypeURI(ValueType valueType) {
        return XMLSchemaDatatypes.getValueTypeURI(valueType);
    }

    public Collection getVisibleUserDefinedOWLProperties() {
        ArrayList instances = new ArrayList();
        instances.addAll(this.owlDatatypePropertyClass.getInstances());
        instances.addAll(this.owlObjectPropertyClass.getInstances());
        return this.getVisibleUserDefinedInstances(instances);
    }

    private Collection getVisibleUserDefinedInstances(Cls cls) {
        Collection instances = cls.getInstances();
        return this.getVisibleUserDefinedInstances(instances);
    }

    private Collection getVisibleUserDefinedInstances(Collection instances) {
        ArrayList<Frame> results = new ArrayList<Frame>();
        for (Frame frame : instances) {
            if (frame.isSystem() || !frame.isVisible()) continue;
            results.add(frame);
        }
        return results;
    }

    public Collection getVisibleUserDefinedRDFProperties() {
        return this.getVisibleUserDefinedInstances(this.rdfPropertyClass);
    }

    public RDFSDatatype getXSDboolean() {
        if (this.xsdBoolean == null) {
            this.xsdBoolean = (RDFSDatatype)this.getFrame("xsd:boolean");
        }
        return this.xsdBoolean;
    }

    public RDFSDatatype getXSDdouble() {
        if (this.xsdDouble == null) {
            this.xsdDouble = (RDFSDatatype)this.getFrame("xsd:double");
        }
        return this.xsdDouble;
    }

    public RDFSDatatype getXSDfloat() {
        if (this.xsdFloat == null) {
            this.xsdFloat = (RDFSDatatype)this.getFrame("xsd:float");
        }
        return this.xsdFloat;
    }

    public RDFSDatatype getXSDlong() {
        if (this.xsdLong == null) {
            this.xsdLong = (RDFSDatatype)this.getFrame("xsd:long");
        }
        return this.xsdLong;
    }

    public RDFSDatatype getXSDint() {
        if (this.xsdInt == null) {
            this.xsdInt = (RDFSDatatype)this.getFrame("xsd:int");
        }
        return this.xsdInt;
    }

    public RDFSDatatype getXSDshort() {
        if (this.xsdShort == null) {
            this.xsdShort = (RDFSDatatype)this.getFrame("xsd:short");
        }
        return this.xsdShort;
    }

    public RDFSDatatype getXSDbyte() {
        if (this.xsdByte == null) {
            this.xsdByte = (RDFSDatatype)this.getFrame("xsd:byte");
        }
        return this.xsdByte;
    }

    public RDFSDatatype getXSDstring() {
        if (this.xsdString == null) {
            this.xsdString = (RDFSDatatype)this.getFrame("xsd:string");
        }
        return this.xsdString;
    }

    public RDFSDatatype getXSDbase64Binary() {
        if (this.xsdBase64Binary == null) {
            this.xsdBase64Binary = (RDFSDatatype)this.getFrame("xsd:base64Binary");
        }
        return this.xsdBase64Binary;
    }

    public RDFSDatatype getXSDdate() {
        if (this.xsdDate == null) {
            this.xsdDate = (RDFSDatatype)this.getFrame("xsd:date");
        }
        return this.xsdDate;
    }

    public RDFSDatatype getXSDtime() {
        if (this.xsdTime == null) {
            this.xsdTime = (RDFSDatatype)this.getFrame("xsd:time");
        }
        return this.xsdTime;
    }

    public RDFSDatatype getXSDdateTime() {
        if (this.xsdDateTime == null) {
            this.xsdDateTime = (RDFSDatatype)this.getFrame("xsd:dateTime");
        }
        return this.xsdDateTime;
    }

    public RDFSDatatype getXSDduration() {
        if (this.xsdDuration == null) {
            this.xsdDuration = (RDFSDatatype)this.getFrame("xsd:duration");
        }
        return this.xsdDuration;
    }

    public RDFSDatatype getXSDanyURI() {
        if (this.xsdAnyURI == null) {
            this.xsdAnyURI = (RDFSDatatype)this.getFrame("xsd:anyURI");
        }
        return this.xsdAnyURI;
    }

    public RDFSDatatype getXSDdecimal() {
        if (this.xsdDecimal == null) {
            this.xsdDecimal = (RDFSDatatype)this.getFrame("xsd:decimal");
        }
        return this.xsdDecimal;
    }

    public RDFSDatatype getXSDinteger() {
        if (this.xsdInteger == null) {
            this.xsdInteger = (RDFSDatatype)this.getFrame("xsd:integer");
        }
        return this.xsdInteger;
    }

    public RDFProperty getOWLVersionInfoProperty() {
        return (RDFProperty)this.owlVersionInfoProperty;
    }

    public RDFProperty getRDFSRangeProperty() {
        return (RDFProperty)this.rdfsRangeProperty;
    }

    public RDFProperty getRDFSSubPropertyOfProperty() {
        return (RDFProperty)this.rdfsSubPropertyOfProperty;
    }

    public boolean isAnonymousResource(RDFResource resource) {
        return resource.isAnonymous();
    }

    public boolean isAnonymousResourceName(String name) {
        return name.charAt(0) == '@';
    }

    public boolean isDefaultAnonymousType(Cls type) {
        return this.defaultAnonymousTypes.contains(type);
    }

    public boolean isDefaultAnonymousType(Collection types) {
        for (Cls type : types) {
            if (!this.isDefaultAnonymousType(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isOWLSystemFrame(Frame frame) {
        return this.getOWLSystemResources().contains(frame);
    }

    public boolean isProtegeMetaOntologyImported() {
        String slotName = ProtegeNames.getSubclassesDisjointSlotName();
        return this.getSlot(slotName) != null;
    }

    public boolean isValidResourceName(String name, RDFResource resource) {
        return this.isValidFrameName(name, (Frame)resource);
    }

    public boolean isTrueInstance(Instance instance) {
        return !(instance instanceof Slot) && !(instance instanceof Cls) && !(instance instanceof Facet) && !(instance instanceof OWLAllDifferent) && !(instance instanceof RDFList) && !(instance instanceof OWLOntology);
    }

    public Iterator listOWLAnonymousClasses() {
        ArrayList result = new ArrayList();
        for (Object o : this.getCls("owl:AnonymousClass").getInstances()) {
            if (!(o instanceof OWLAnonymousClass)) continue;
            result.add(o);
        }
        return result.iterator();
    }

    public Iterator listOWLNamedClasses() {
        ArrayList result = new ArrayList();
        for (Object o : this.getOWLNamedClassClass().getInstances(true)) {
            if (!(o instanceof OWLNamedClass)) continue;
            result.add(o);
        }
        return result.iterator();
    }

    public Iterator listRDFProperties() {
        return this.getRDFProperties().iterator();
    }

    public Iterator listRDFSNamedClasses() {
        ArrayList result = new ArrayList();
        for (Object o : this.getRDFSNamedClassClass().getInstances(true)) {
            if (!(o instanceof RDFSNamedClass)) continue;
            result.add(o);
        }
        return result.iterator();
    }

    public Iterator listReferences(Object object, int maxResults) {
        if (object instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        Iterator refs = this.getReferences(object, maxResults).iterator();
        ArrayList<DefaultTuple> results = new ArrayList<DefaultTuple>();
        while (refs.hasNext()) {
            Reference ref = (Reference)refs.next();
            if (!(ref.getFrame() instanceof RDFResource) || !(ref.getSlot() instanceof RDFProperty)) continue;
            results.add(new DefaultTuple((RDFResource)ref.getFrame(), (RDFProperty)ref.getSlot()));
        }
        return results.iterator();
    }

    public Iterator listSubjects(RDFProperty property) {
        return this.getOWLFrameStore().getFramesWithAnyDirectOwnSlotValue(property).iterator();
    }

    public synchronized Instance setDirectType(Instance instance, Cls type) {
        if (instance instanceof OWLProperty && type != null) {
            this.deleteRestrictionsDependingOnPropertyType((OWLProperty)instance, type);
        }
        if (instance instanceof OWLNamedClass && type.equals(this.rdfsNamedClassClass)) {
            this.deleteAnonymousSuperclasses((OWLNamedClass)instance);
        }
        return super.setDirectType(instance, type);
    }

    private void deleteAnonymousSuperclasses(OWLNamedClass namedOWLClass) {
        Collection oldNamedParents = namedOWLClass.getNamedSuperclasses();
        for (Cls superCls : new ArrayList(namedOWLClass.getSuperclasses(false))) {
            if (!(superCls instanceof OWLAnonymousClass)) continue;
            superCls.delete();
        }
        for (RDFSClass superCls : oldNamedParents) {
            if (namedOWLClass.isSubclassOf(superCls)) continue;
            namedOWLClass.addSuperclass(superCls);
        }
    }

    private void deleteRestrictionsDependingOnPropertyType(OWLProperty owlProperty, Cls type) {
        OWLNamedClass metaClass = null;
        metaClass = owlProperty instanceof OWLDatatypeProperty ? this.getOWLDatatypePropertyClass() : this.getOWLObjectPropertyClass();
        if (!type.hasSuperclass((Cls)metaClass)) {
            this.getOWLFrameStore().deleteQuantifierRestrictions(owlProperty);
        }
    }

    public void setLoadDefaults(boolean value) {
        this.loadDefaults = value;
    }

    public void setProject(Project project) {
        super.setProject(project);
        if (this.bootstrapped) {
            this.setOWLProject(new DefaultOWLProject(project));
            project.setPrettyPrintSlotWidgetLabels(false);
            Slot nameSlot = this.getSlot(":NAME");
            this.getRootCls().setDirectBrowserSlotPattern(new BrowserSlotPattern(nameSlot));
            project.setDefaultClsWidgetClassName(OWLFormWidget.class.getName());
            project.setWidgetMapper((WidgetMapper)new OWLWidgetMapper(this));
            if (project.isMultiUserServer()) {
                FrameStoreManager fsm = this.getFrameStoreManager();
                fsm.removeFrameStore((FrameStore)this.owlFrameStore);
                this.owlFrameStore = null;
            }
            this.protegeClassificationStatusProperty.setVisible(false);
            this.protegeInferredSuperclassesProperty.setVisible(false);
            this.protegeInferredSubclassesProperty.setVisible(false);
            this.owlOntologyClass.setVisible(false);
        }
    }

    public void setSearchSynonymProperties(Collection slots) {
        if (slots.isEmpty()) {
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, null);
        } else {
            String str = "";
            Iterator it = slots.iterator();
            while (it.hasNext()) {
                Slot slot = (Slot)it.next();
                str = String.valueOf(str) + slot.getName();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + SEARCH_SYNONYMS_SEPARATOR;
            }
            this.getOWLProject().getSettingsMap().setString(SEARCH_SYNONYMS_KEY, str);
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void addOWLTest(OWLTest test) {
        this.getOWLTestsSettingsMap().remove(test.getClass().getName());
    }

    public OWLTest[] getOWLTests() {
        Class[] classes = OWLTestLibrary.getOWLTestClasses();
        ArrayList<OWLTest> tests = new ArrayList<OWLTest>();
        HashSet disabledTestClasses = new HashSet();
        Iterator it = this.getOWLTestsSettingsMap().listKeys();
        while (it.hasNext()) {
            disabledTestClasses.add(it.next());
        }
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            if (!disabledTestClasses.contains(c.getName())) {
                tests.add(OWLTestLibrary.getOWLTest(c));
            }
            ++i;
        }
        return tests.toArray(new OWLTest[0]);
    }

    private SettingsMap getOWLTestGroupsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TESTGROUP_LIST_NAME);
    }

    private SettingsMap getOWLTestsSettingsMap() {
        return this.getOWLProject().getSettingsMap().getSettingsMap(TEST_LIST_NAME);
    }

    public boolean isAutoRepairEnabled() {
        return !Boolean.FALSE.equals(this.getOWLProject().getSettingsMap().getBoolean(AUTO_REPAIR_ENABLED));
    }

    public boolean isOWLTestGroupEnabled(String groupName) {
        return this.getOWLTestGroupsSettingsMap().getBoolean(groupName) == null;
    }

    public void removeOWLTest(OWLTest test) {
        String key = test.getClass().getName();
        this.getOWLTestsSettingsMap().setBoolean(key, true);
    }

    public void setAutoRepairEnabled(boolean value) {
        this.getOWLProject().getSettingsMap().setBoolean(AUTO_REPAIR_ENABLED, (Boolean)value);
    }

    public void setOWLTestGroupEnabled(String groupName, boolean value) {
        if (value) {
            this.getOWLTestGroupsSettingsMap().remove(groupName);
            Class[] classes = OWLTestLibrary.getOWLTestClasses();
            int i = 0;
            while (i < classes.length) {
                Class c = classes[i];
                OWLTest test = OWLTestLibrary.getOWLTest(c);
                if (groupName.equals(test.getGroup())) {
                    this.addOWLTest(test);
                }
                ++i;
            }
        } else {
            this.getOWLTestGroupsSettingsMap().setBoolean(groupName, true);
            OWLTest[] tests = this.getOWLTests();
            int i = 0;
            while (i < tests.length) {
                OWLTest test = tests[i];
                if (groupName.equals(test.getGroup())) {
                    this.removeOWLTest(test);
                }
                ++i;
            }
        }
    }

    public String createUniqueNewFrameName(String baseName) {
        return this.getUniqueFrameName(String.valueOf(this.getName()) + "_" + baseName);
    }

    public void defaultNamespaceChanged(String oldValue, String newValue) {
    }

    public String getResourceNameForURI(String uri) {
        if (uri.lastIndexOf(35) > 0) {
            return this.getFrameNameForURI(uri, true);
        }
        String match = uri.endsWith("/") ? uri : String.valueOf(uri) + "#";
        String prefix = this.getNamespaceManager().getPrefix(match);
        if (prefix != null) {
            return String.valueOf(prefix) + ":";
        }
        if (match.equals(this.getNamespaceManager().getDefaultNamespace())) {
            return ":";
        }
        return this.getFrameNameForURI(uri, true);
    }

    public String getFrameNameForURI(String uri, boolean generatePrefix) {
        String name;
        String localName = this.getLocalNameForURI(uri);
        String namespace = this.getNamespaceForURI(uri);
        NamespaceManager nsm = this.getNamespaceManager();
        if (nsm.getDefaultNamespace().equals(namespace)) {
            if (localName == null) {
                return ":";
            }
            return localName;
        }
        if (ProtegeNames.NS.equals(namespace) && this.getFrame(name = ":" + localName) != null) {
            return name;
        }
        String prefix = nsm.getPrefix(namespace);
        if (prefix == null) {
            String newPrefix = null;
            int i = 1;
            while (nsm.getNamespaceForPrefix(newPrefix = "p" + i++) != null) {
            }
            if (generatePrefix) {
                nsm.setPrefix(namespace, newPrefix);
            }
            prefix = newPrefix;
        }
        if (localName != null) {
            return String.valueOf(prefix) + ":" + localName;
        }
        return String.valueOf(prefix) + ":";
    }

    public RDFResource getRDFResourceByBrowserText(String text) {
        for (Instance instance : this.getInstances()) {
            if (!(instance instanceof RDFResource) || !instance.getBrowserText().equals(text)) continue;
            return (RDFResource)this.getInstance(instance.getName());
        }
        return null;
    }

    public RDFResource getRDFResourceByNameOrBrowserText(String text) {
        Instance result = this.getInstance(text);
        if (result instanceof RDFResource) {
            return (RDFResource)result;
        }
        result = this.getRDFResourceByBrowserText(text);
        if (result instanceof RDFResource) {
            return (RDFResource)result;
        }
        return null;
    }

    public int getRDFSClassCount() {
        return this.owlClassMetaCls.getInstanceCount() - 4;
    }

    public Collection getRDFSClasses() {
        ArrayList classes = new ArrayList(this.owlClassMetaCls.getInstances());
        AbstractOWLModel.removeProtegeSystemResources(this, classes);
        return classes;
    }

    public RDFSDatatypeFactory getRDFSDatatypeFactory() {
        return this.rdfsDatatypeFactory;
    }

    private static void removeProtegeSystemResources(KnowledgeBase kb, Collection frames) {
        if (frames.size() > 0) {
            Cls dbrClass = kb.getCls(":DIRECTED-BINARY-RELATION");
            frames.remove(dbrClass);
            frames.remove(kb.getCls(":PAL-CONSTRAINT"));
            frames.remove(kb.getCls(":OWL-ANONYMOUS-ROOT"));
            frames.remove(kb.getCls(":OWL-CLASS"));
            frames.remove(kb.getSlot(":OWL-ONTOLOGY-PREFIXES"));
            frames.remove(kb.getSlot(":OWL-RESOURCE-URI"));
            frames.remove(kb.getSlot(":SLOT-CONSTRAINTS"));
        }
    }

    public Collection getResourcesWithPrefix(String prefix) {
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (Frame frame : this.getFrames()) {
            String p;
            if (!(frame instanceof RDFResource) || !prefix.equals(p = ((RDFResource)frame).getNamespacePrefix())) continue;
            result.add(frame);
        }
        return result;
    }

    public String getLocalNameForResourceName(String frameName) {
        int index = frameName.indexOf(58);
        if (index >= 0) {
            return frameName.substring(index + 1);
        }
        return frameName;
    }

    public String getLocalNameForURI(String uri) {
        int index = Util.splitNamespace((String)uri);
        if (index == uri.length()) {
            return null;
        }
        return uri.substring(index);
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public String getNamespaceForResourceName(String resourceName) {
        int index = resourceName.indexOf(58);
        if (index > 0) {
            String prefix = resourceName.substring(0, index);
            String namespace = this.getNamespaceManager().getNamespaceForPrefix(prefix);
            return namespace;
        }
        return this.getNamespaceManager().getDefaultNamespace();
    }

    public String getNamespaceForURI(String uri) {
        int index = Util.splitNamespace((String)uri);
        if (index == uri.length()) {
            return uri;
        }
        return uri.substring(0, index);
    }

    public String getPrefixForResourceName(String frameName) {
        int index = frameName.indexOf(58);
        if (index >= 0) {
            return frameName.substring(0, index);
        }
        return null;
    }

    public String getUniqueFrameName(String name) {
        String baseName = name;
        int i = this.lastGen;
        while (this.getFrame(name = String.valueOf(baseName) + "_" + i++) != null) {
        }
        this.lastGen = i;
        return name;
    }

    public String getURIForResourceName(String name) {
        if (name.indexOf(35) < 0) {
            NamespaceManager nsm = this.getNamespaceManager();
            int column = name.indexOf(58);
            if (column == name.length() - 1) {
                String ns = null;
                if (column == 0) {
                    ns = nsm.getDefaultNamespace();
                } else {
                    String prefix = name.substring(0, column);
                    ns = nsm.getNamespaceForPrefix(prefix);
                }
                if (ns.endsWith("#") || ns.endsWith(":")) {
                    return ns.substring(0, ns.length() - 1);
                }
                return ns;
            }
            if (column >= 0) {
                String localName = name.substring(column + 1);
                if (column == 0) {
                    return String.valueOf(ProtegeNames.NS) + localName;
                }
                String prefix = name.substring(0, column);
                String namespace = nsm.getNamespaceForPrefix(prefix);
                return String.valueOf(namespace) + localName;
            }
            return String.valueOf(nsm.getDefaultNamespace()) + name;
        }
        return name;
    }

    public List getVisibleResources(Iterator iterator) {
        ArrayList<RDFResource> result = new ArrayList<RDFResource>();
        while (iterator.hasNext()) {
            RDFResource resource = (RDFResource)iterator.next();
            if (!resource.isVisible()) continue;
            result.add(resource);
        }
        return result;
    }

    public OWLDatatypeProperty getRDFSCommentProperty() {
        return (OWLDatatypeProperty)this.rdfsCommentProperty;
    }

    public String getValidNamespaceFrameName(String suggestedName) {
        return AbstractOWLModel.getValidOWLFrameName(this, suggestedName);
    }

    public static String getValidOWLFrameName(AbstractOWLModel kb, String suggestedName) {
        Assert.assertNotNull((Object)suggestedName);
        String name = suggestedName;
        if (name.startsWith(":")) {
            name = "_" + name.substring(1);
        }
        int first = name.indexOf(58) + 1;
        int i = 0;
        while (i < name.length()) {
            char c;
            if (i != first - 1 && !Character.isJavaIdentifierPart(c = name.charAt(i)) && VALID_SYMBOLS.indexOf(c) < 0) {
                name = name.replace(c, '_');
            }
            ++i;
        }
        if (name.length() == first) {
            name = "_" + name;
        } else if (!Character.isJavaIdentifierStart(name.charAt(first))) {
            int x = first == 0 ? first : first - 1;
            name = String.valueOf(name.substring(0, x)) + "_" + name.substring(first);
        }
        if (!name.equals(suggestedName)) {
            suggestedName = kb != null && kb.getFrame(name) != null ? kb.getUniqueFrameName(name) : name;
        }
        return suggestedName;
    }

    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.rdfPropertyClass.equals(cls) || this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    public boolean isValidOWLFrameName(String name) {
        return AbstractOWLModel.isValidOWLFrameName(this.getNamespaceManager(), name);
    }

    public static boolean isValidOWLFrameName(NamespaceManager nsm, String name) {
        if (name == null) {
            return false;
        }
        int index = name.indexOf(58);
        if (index >= 0) {
            if (index == name.length() - 1) {
                return false;
            }
            String prefix = name.substring(0, index);
            String localName = name.substring(index + 1);
            String namespace = nsm.getNamespaceForPrefix(prefix);
            if (namespace == null) {
                return false;
            }
            int lastIndex = name.lastIndexOf(58);
            if (index != lastIndex) {
                return false;
            }
            return AbstractOWLModel.isValidOWLFrameNamePart(localName);
        }
        return AbstractOWLModel.isValidOWLFrameNamePart(name);
    }

    private static boolean isValidOWLFrameNamePart(String name) {
        if (name.length() == 0) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && VALID_SYMBOLS.indexOf(c) < 0) {
                return false;
            }
            ++i;
        }
        return Character.isJavaIdentifierStart(name.charAt(0));
    }

    public void namespaceChanged(String prefix, String oldValue, String newValue) {
    }

    public void prefixAdded(String prefix) {
    }

    public void prefixChanged(String namespace, String oldPrefix, String newPrefix) {
        this.replacePrefixInInstances(oldPrefix, newPrefix);
    }

    public void prefixRemoved(String prefix) {
        this.replacePrefixInInstances(prefix, null);
    }

    public void replacePrefixInInstances(String oldPrefix, String newPrefix) {
        TripleStoreModel tsm = this.getTripleStoreModel();
        TripleStore activeTripleStore = tsm.getActiveTripleStore();
        Iterator it = tsm.listUserTripleStores();
        while (it.hasNext()) {
            TripleStore curTripleStore = (TripleStore)it.next();
            tsm.setActiveTripleStore(curTripleStore);
            Iterator resIt = curTripleStore.listHomeResources();
            while (resIt.hasNext()) {
                String localName;
                RDFResource resource = (RDFResource)resIt.next();
                if (resource.getNamespacePrefix() == null || !resource.getNamespacePrefix().equals(oldPrefix)) continue;
                String newName = localName = resource.getLocalName();
                if (newPrefix != null && newPrefix.length() > 0) {
                    newName = String.valueOf(newPrefix) + ":" + localName;
                }
                if (this.getFrame(newName) != null) {
                    newName = this.getUniqueFrameName(newName);
                }
                resource.setName(newName);
            }
        }
        tsm.setActiveTripleStore(activeTripleStore);
    }

    public void resetJenaModel() {
        this.jenaModel = null;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public RDFSNamedClass getRDFSDatatypeClass() {
        return (RDFSNamedClass)this.rdfsDatatypeClass;
    }

    public Collection getPropertyValueLiterals(RDFResource resource, RDFProperty property) {
        return this.owlFrameStore.getPropertyValueLiterals(resource, property);
    }

    public List getValueLiterals(List values) {
        return this.owlFrameStore.getLiteralValues(values);
    }

    public RDFProperty getRDFSSubClassOfProperty() {
        return (RDFProperty)this.rdfsSubClassOfProperty;
    }

    public RDFProperty getOWLEquivalentClassProperty() {
        return (RDFProperty)this.owlEquivalentClassProperty;
    }

    public RDFProperty getOWLInverseOfProperty() {
        return (RDFProperty)this.owlInverseOfProperty;
    }

    public RDFProperty getOWLDistinctMembersProperty() {
        return (RDFProperty)this.owlDistinctMembersProperty;
    }
}

