/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.tests.AbstractTripleStoreTestCase;

public class CreateRDFSDomainTestCase
extends AbstractTripleStoreTestCase {
    public void testDefaultDomain() {
        RDFResource propertyFrame = this.createRDFResource("property");
        this.ts.add(propertyFrame, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty property = this.owlModel.getRDFProperty(propertyFrame.getName());
        CreateRDFSDomainTestCase.assertSize(1, property.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)this.owlThing, property.getDirectDomain());
    }

    public void testDefaultDomainOfSubProperty() {
        RDFResource superpropertyFrame = this.createRDFResource("superproperty");
        RDFResource subpropertyFrame = this.createRDFResource("subproperty");
        this.ts.add(superpropertyFrame, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.ts.add(subpropertyFrame, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.ts.add(subpropertyFrame, this.owlModel.getRDFSSubPropertyOfProperty(), superpropertyFrame);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty subproperty = this.owlModel.getRDFProperty(subpropertyFrame.getName());
        CreateRDFSDomainTestCase.assertSize(0, subproperty.getDirectDomain());
        RDFProperty superproperty = this.owlModel.getRDFProperty(superpropertyFrame.getName());
        CreateRDFSDomainTestCase.assertSize(1, superproperty.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)this.owlThing, superproperty.getDirectDomain());
    }

    public void testSimpleDomain() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFResource propertyFrame = this.createRDFResource("property");
        this.ts.add(propertyFrame, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.ts.add(propertyFrame, this.owlModel.getRDFSDomainProperty(), cls);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty property = this.owlModel.getRDFProperty(propertyFrame.getName());
        CreateRDFSDomainTestCase.assertSize(1, property.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)cls, property.getDirectDomain());
        CreateRDFSDomainTestCase.assertSize(1, cls.getDirectTemplateSlots());
        CreateRDFSDomainTestCase.assertContains((Object)property, cls.getDirectTemplateSlots());
    }

    public void testMultipleDomains() {
        RDFSNamedClass clsA = this.owlModel.createRDFSNamedClass("A");
        RDFSNamedClass clsB = this.owlModel.createRDFSNamedClass("B");
        RDFResource propertyR = this.createRDFResource("property");
        this.ts.add(propertyR, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.ts.add(propertyR, this.owlModel.getRDFSDomainProperty(), clsA);
        this.ts.add(propertyR, this.owlModel.getRDFSDomainProperty(), clsB);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        Slot slot = this.owlModel.getSlot(propertyR.getName());
        CreateRDFSDomainTestCase.assertSize(1, slot.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)clsA, slot.getDirectDomain());
    }

    public void testUnionDomains() {
        RDFSNamedClass clsA = this.owlModel.createRDFSNamedClass("A");
        RDFSNamedClass clsB = this.owlModel.createRDFSNamedClass("B");
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(clsA);
        unionClass.addOperand(clsB);
        RDFResource propertyR = this.createRDFResource("property");
        this.ts.add(propertyR, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
        this.ts.add(propertyR, this.owlModel.getRDFSDomainProperty(), unionClass);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        Slot slot = this.owlModel.getSlot(propertyR.getName());
        CreateRDFSDomainTestCase.assertSize(2, slot.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)clsA, slot.getDirectDomain());
        CreateRDFSDomainTestCase.assertContains((Object)clsB, slot.getDirectDomain());
    }
}

