/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel model, String s) {
        if (s.trim().startsWith("http:")) {
            try {
                new URL(s);
                return true;
            }
            catch (MalformedURLException e) {
                System.err.println("[URL Repository Factory] Could not create a HTTP repository because the specified URL, " + s + " was malformed.");
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel model, String s) {
        try {
            return new HTTPRepository(new URL(s));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

