/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.List;

public class ClassInfo
extends Info {
    private List directSuperClassNames;
    private List directSubClassNames;

    public ClassInfo(OWLModel owlModel, String className) throws SWRLRuleEngineBridgeException {
        super(className);
        OWLNamedClass owlNamedClass = owlModel.getOWLNamedClass(className);
        if (owlNamedClass == null) {
            throw new InvalidClassNameException(className);
        }
        if (className.equals("owl:Thing")) {
            this.directSuperClassNames = new ArrayList();
            this.directSubClassNames = new ArrayList();
        } else {
            this.directSuperClassNames = ClassInfo.rdfResources2NamesList(owlNamedClass.getNamedSuperclasses());
            this.directSubClassNames = ClassInfo.rdfResources2NamesList(owlNamedClass.getNamedSubclasses());
        }
    }

    public List getDirectSuperClassNames() {
        return this.directSuperClassNames;
    }

    public List getDirectSubClassNames() {
        return this.directSubClassNames;
    }

    public String toString() {
        return "Class(name: " + this.getName() + ", directSubClassNames: " + this.directSubClassNames + ", directSuperClassNames: " + this.directSuperClassNames + ")";
    }
}

