/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CloneRuleAction
extends AbstractAction {
    private SWRLTable table;

    public CloneRuleAction(SWRLTable table, OWLModel owlModel) {
        super("Clone selected rule", OWLIcons.getAddIcon("SWRLImp", SWRLIcons.class));
        this.table = table;
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CloneRuleAction.this.updateEnabled();
            }
        });
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent e) {
        SWRLImp imp = this.table.getSelectedImp();
        final SWRLImp c = imp.createClone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CloneRuleAction.this.table.setSelectedRow(c);
            }
        });
    }

    private void updateEnabled() {
        this.setEnabled(this.table.getSelectedRowCount() == 1);
    }
}

