/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextAreaPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class CreateRuleAction
extends AbstractAction {
    private OWLModel owlModel;
    private SWRLTable table;

    public CreateRuleAction(SWRLTable table, OWLModel owlModel) {
        super("Create new rule...", OWLIcons.getCreateIcon("SWRLImp", SWRLIcons.class));
        this.owlModel = owlModel;
        this.table = table;
    }

    public void actionPerformed(ActionEvent e) {
        final SWRLImp newImp = new SWRLFactory(this.owlModel).createImp();
        if (SWRLTextAreaPanel.showEditDialog((Component)((Object)this.table), this.owlModel, newImp)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CreateRuleAction.this.table.setSelectedRow(newImp);
                }
            });
        } else {
            newImp.delete();
        }
    }
}

