/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTablePanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import javax.swing.SwingUtilities;

public class SWRLResultsPanel
extends ResultsPanel {
    private RDFResource instance;
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            if (SWRLResultsPanel.this.instance.equals(cls)) {
                SWRLResultsPanel.this.closeSoon();
            }
        }

        public void individualDeleted(RDFResource resource) {
            if (SWRLResultsPanel.this.instance.equals(resource)) {
                SWRLResultsPanel.this.closeSoon();
            }
        }

        public void propertyDeleted(RDFProperty property) {
            if (SWRLResultsPanel.this.instance.equals(property)) {
                SWRLResultsPanel.this.closeSoon();
            }
        }
    };
    private SWRLTablePanel tablePanel;

    public SWRLResultsPanel(RDFResource resource) {
        super(resource.getOWLModel());
        this.instance = resource;
        OWLModel owlModel = resource.getOWLModel();
        owlModel.addModelListener(this.listener);
        this.tablePanel = new SWRLTablePanel(owlModel, resource);
        this.add("Center", this.tablePanel);
    }

    private void closeSoon() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SWRLResultsPanel.this.close();
            }
        });
    }

    public void dispose() {
        this.tablePanel.dispose();
        OWLModel owlModel = this.instance.getOWLModel();
        owlModel.removeModelListener(this.listener);
    }

    public String getTabName() {
        return "SWRL Rules about " + this.instance.getBrowserText();
    }
}

