/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.owldl;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransitivePropertiesCannotBeFunctionalOWLDLTest
extends AbstractOWLTest
implements OWLDLTest,
RDFPropertyTest,
RepairableOWLTest {
    public TransitivePropertiesCannotBeFunctionalOWLDLTest() {
        super("OWL-DL Tests", null);
    }

    public static boolean fails(RDFProperty property) {
        if (property instanceof OWLObjectProperty && ((OWLObjectProperty)property).isTransitive()) {
            return TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(property, new HashSet());
        }
        return false;
    }

    private static boolean isFunctional(Slot slot, Set reached) {
        if (!reached.contains(slot)) {
            reached.add(slot);
            if (slot instanceof OWLObjectProperty) {
                OWLObjectProperty objectSlot = (OWLObjectProperty)slot;
                if (objectSlot.isFunctional() || objectSlot.isInverseFunctional()) {
                    return true;
                }
                for (Slot superSlot : slot.getDirectSuperslots()) {
                    if (!TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(superSlot, reached)) continue;
                    return true;
                }
                Slot inverseSlot = slot.getInverseSlot();
                if (inverseSlot != null && TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(inverseSlot, reached)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean repair(OWLTestResult testResult) {
        OWLProperty property = (OWLProperty)testResult.getHost();
        property.setFunctional(false);
        property.setInverseFunctional(false);
        return !TransitivePropertiesCannotBeFunctionalOWLDLTest.fails(property);
    }

    public List test(RDFProperty property) {
        if (TransitivePropertiesCannotBeFunctionalOWLDLTest.fails(property)) {
            return Collections.singletonList(new DefaultOWLTestResult("Transitive properties (or inverse or super properties of them) cannot be functional (or inverse functional) in OWL DL.", property, 3, this));
        }
        return Collections.EMPTY_LIST;
    }
}

