/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PropertyRangeRedundancyTest
extends AbstractOWLTest
implements RDFPropertyTest,
RepairableOWLTest {
    public PropertyRangeRedundancyTest() {
        super("Sanity Tests", "Range of a property should not contain redundant classes");
    }

    public static Collection fails(OWLObjectProperty slot) {
        HashSet<Cls> results = new HashSet<Cls>();
        Collection range = slot.getUnionRangeClasses();
        if (range.size() >= 2) {
            for (Cls subCls : range) {
                for (Cls superCls : range) {
                    if (superCls.equals(subCls) || !subCls.hasSuperclass(superCls)) continue;
                    results.add(subCls);
                }
            }
        }
        return results;
    }

    public boolean repair(OWLTestResult testResult) {
        RDFResource host = testResult.getHost();
        if (host instanceof OWLObjectProperty) {
            OWLObjectProperty slot = (OWLObjectProperty)host;
            Collection clses = PropertyRangeRedundancyTest.fails(slot);
            ArrayList newRange = new ArrayList(slot.getUnionRangeClasses());
            newRange.removeAll(clses);
            slot.setUnionRangeClasses(newRange);
            return PropertyRangeRedundancyTest.fails(slot).isEmpty();
        }
        return false;
    }

    public List test(RDFProperty property) {
        Collection failClses;
        if (property instanceof OWLObjectProperty && !(failClses = PropertyRangeRedundancyTest.fails((OWLObjectProperty)property)).isEmpty()) {
            String str = failClses.size() > 1 ? "es " : " ";
            Iterator it = failClses.iterator();
            while (it.hasNext()) {
                Cls cls = (Cls)it.next();
                str = String.valueOf(str) + cls.getBrowserText();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            return Collections.singletonList(new DefaultOWLTestResult("The range of " + property.getBrowserText() + " contains the redundant class" + str + ".", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

