/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class CopyPropertyValueAction
extends AbstractAction {
    private RDFProperty property;
    private Object value;
    private Collection targetFrames;
    private String type;

    public CopyPropertyValueAction(String type, RDFProperty property, Object value, Collection targetResources) {
        this(type, property, value, targetResources, "annotation");
    }

    public CopyPropertyValueAction(String type, RDFProperty property, Object value, Collection targetResources, String partialName) {
        this(type, property, value, targetResources, partialName, OWLIcons.getImageIcon("CopyAnnotation"));
    }

    public CopyPropertyValueAction(String type, RDFProperty property, Object value, Collection targetFrames, String partialLabel, Icon icon) {
        super("Copy " + partialLabel + " value into " + type + "...", icon);
        this.property = property;
        this.value = value;
        this.targetFrames = targetFrames;
        this.type = type;
    }

    public void actionPerformed(ActionEvent e) {
        block4: {
            int result;
            block3: {
                result = ProtegeUI.getModalDialogFactory().showConfirmCancelDialog(this.property.getOWLModel(), "Shall the selected value replace any existing values\nof the " + this.property.getName() + " property at all " + this.type + ",\n" + "if there already is exactly one value?", (String)this.getValue("Name"));
                if (result != 2) break block3;
                for (RDFResource resource : this.targetFrames) {
                    if (resource.getPropertyValues(this.property).size() == 1) {
                        resource.setPropertyValue(this.property, this.value);
                        continue;
                    }
                    resource.addPropertyValue(this.property, this.value);
                }
                break block4;
            }
            if (result != 1) break block4;
            for (RDFResource resource : this.targetFrames) {
                if (resource.getPropertyValues(this.property).size() == 1) continue;
                resource.addPropertyValue(this.property, this.value);
            }
        }
    }
}

