/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.form.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.classform.form.ClassFormSwitchableType;

public class SufficientlyExpressiveTestCase
extends AbstractJenaTestCase {
    public void testRDFSNamedClass() {
        RDFSNamedClass namedClass = this.owlModel.createRDFSNamedClass("Class");
        SufficientlyExpressiveTestCase.assertFalse((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }

    public void testOWLNamedClassWithoutRestrictions() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        SufficientlyExpressiveTestCase.assertTrue((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }

    public void testSuperclassOWLSomeValuesFrom() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, namedClass));
        SufficientlyExpressiveTestCase.assertTrue((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }

    public void testSuperclassOWLAllValuesFromOnly() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        namedClass.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, namedClass));
        SufficientlyExpressiveTestCase.assertFalse((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }

    public void testSuperclassClosureAxiom() {
        OWLNamedClass namedClass;
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass filler = namedClass = this.owlModel.createOWLNamedClass("Class");
        namedClass.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, filler));
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler));
        SufficientlyExpressiveTestCase.assertTrue((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }

    public void testSuperclassNonClosureAxiom() {
        OWLNamedClass namedClass;
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass filler = namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLNamedClass otherFiller = this.owlModel.createOWLNamedClass("Other");
        SufficientlyExpressiveTestCase.assertFalse((boolean)filler.equals(otherFiller));
        namedClass.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, filler));
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler));
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, otherFiller));
        SufficientlyExpressiveTestCase.assertFalse((boolean)new ClassFormSwitchableType().isSufficientlyExpressive(namedClass));
    }
}

