/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class ConvertToDefinedClassAction
extends ResourceAction {
    public ConvertToDefinedClassAction() {
        super("Convert to defined class", OWLIcons.getImageIcon("DefinedOWLClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            try {
                OWLNamedClass cls = (OWLNamedClass)this.getResource();
                this.getOWLModel().beginTransaction("Convert " + cls.getBrowserText() + " to defined class");
                ConvertToDefinedClassAction.performAction(cls);
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.getOWLModel().endTransaction();
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof ResourceDisplay && resource instanceof OWLNamedClass && resource.isEditable() && ((OWLNamedClass)resource).getDefinition() == null;
    }

    public static void performAction(OWLNamedClass namedClass) {
        OWLModel owlModel = namedClass.getOWLModel();
        ArrayList superclasses = new ArrayList(namedClass.getSuperclasses(false));
        superclasses.remove(namedClass.getOWLModel().getOWLThingClass());
        if (superclasses.size() == 1) {
            RDFSClass superclass = (RDFSClass)superclasses.iterator().next();
            superclass.addSuperclass(namedClass);
        } else if (superclasses.size() > 1) {
            OWLIntersectionClass intersectionCls = owlModel.createOWLIntersectionClass();
            for (RDFSClass superClass : superclasses) {
                intersectionCls.addOperand(superClass.createClone());
            }
            namedClass.setDefinition(intersectionCls);
            for (RDFSClass superClass : superclasses) {
                if (!(superClass instanceof OWLAnonymousClass)) continue;
                superClass.delete();
            }
        }
    }
}

