/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.LogicClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableClassDefinitionWidget;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPlugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SwitchClassDefinitionResourceDisplayPlugin
implements ResourceDisplayPlugin {
    private static final Logger log = Log.getLogger(SwitchClassDefinitionResourceDisplayPlugin.class);
    private static final String PROPERTY = "SwitchableClassDefinitionType";
    public static boolean showWarning = true;

    private SwitchableClassDefinitionWidget getSwitchableClassDefinitionWidget(JPanel hostPanel) {
        Container c = hostPanel.getParent();
        while (!(c instanceof ResourceDisplay)) {
            c = c.getParent();
        }
        return this.searchForWidget(c);
    }

    private SwitchableClassDefinitionWidget searchForWidget(Component component) {
        if (component instanceof SwitchableClassDefinitionWidget) {
            return (SwitchableClassDefinitionWidget)((Object)component);
        }
        if (component instanceof Container) {
            Component[] childComponents = ((Container)component).getComponents();
            int i = 0;
            while (i < childComponents.length) {
                if (childComponents[i] instanceof SwitchableClassDefinitionWidget) {
                    return (SwitchableClassDefinitionWidget)((Object)childComponents[i]);
                }
                ++i;
            }
            i = 0;
            while (i < childComponents.length) {
                SwitchableClassDefinitionWidget widget = this.searchForWidget(childComponents[i]);
                if (widget != null) {
                    return widget;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getDefaultClassView() {
        return ApplicationProperties.getString((String)PROPERTY, (String)LogicClassDefinitionWidgetType.class.getName());
    }

    public void initResourceDisplay(RDFResource resource, JPanel hostPanel) {
        SwitchableClassDefinitionWidget widget;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering initResourceDisplay - " + resource + ", " + hostPanel);
        }
        if (resource instanceof OWLNamedClass && (widget = this.getSwitchableClassDefinitionWidget(hostPanel)) != null) {
            OWLProject project = resource.getOWLModel().getOWLProject();
            String className = project.getSettingsMap().getString(PROPERTY);
            try {
                if (className != null) {
                    Class cls = PluginUtilities.forName((String)className);
                    if (cls != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("New class = " + className);
                        }
                        SwitchableType type = (SwitchableType)cls.newInstance();
                        widget.setActiveType(type.getWidgetClassType());
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No SwitchableType class found for resource" + resource);
                }
            }
            catch (Exception ex) {
                Log.emptyCatchBlock((Throwable)ex);
            }
            SwitchPanel switchPanel = new SwitchPanel(widget);
            switchPanel.updateStatus();
            hostPanel.add(switchPanel);
        }
    }

    public static void setClassesView(PropertyList sources, String activeClassName) {
        sources.setString(PROPERTY, activeClassName);
    }

    public static void setDefaultClassesView(String activeClassName) {
        ApplicationProperties.setString((String)PROPERTY, (String)activeClassName);
    }

    private class SwitchPanel
    extends JPanel {
        private Map types2RadioButton = new HashMap();
        private SwitchableClassDefinitionWidget widget;

        SwitchPanel(SwitchableClassDefinitionWidget widget) {
            this.widget = widget;
            this.setLayout(new BoxLayout(this, 0));
            ButtonGroup group = new ButtonGroup();
            final OWLModel owlModel = widget.getOWLModel();
            Iterator it = SwitchableClassDefinitionWidget.listSwitchableTypes();
            while (it.hasNext()) {
                final SwitchableType type = (SwitchableType)it.next();
                if (!type.isSuitable(owlModel)) continue;
                JRadioButton button = new JRadioButton(type.getButtonText());
                group.add(button);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SwitchPanel.this.switchTo(type);
                        owlModel.getOWLProject().getSettingsMap().setString(SwitchClassDefinitionResourceDisplayPlugin.PROPERTY, type.getWidgetClassType().getName());
                    }
                });
                this.add(button);
                this.add(Box.createHorizontalStrut(8));
                if (widget.getActiveWidgetClass() == type.getWidgetClassType()) {
                    button.setSelected(true);
                }
                this.types2RadioButton.put(type, button);
            }
        }

        private void switchTo(SwitchableType type) {
            this.widget.setActiveType(type.getWidgetClassType());
        }

        public void updateStatus() {
            RDFSNamedClass namedClass = (RDFSNamedClass)this.widget.getEditedResource();
            block0: for (SwitchableType type : this.types2RadioButton.keySet()) {
                JRadioButton button = this.getRadioButton(type);
                if (namedClass != null && !type.isSufficientlyExpressive(namedClass)) {
                    button.setEnabled(false);
                    button.setToolTipText("The selected class uses OWL features that cannot be displayed with the " + type.getButtonText() + ".");
                    if (!button.isSelected()) continue;
                    Iterator types = SwitchableClassDefinitionWidget.listSwitchableTypes();
                    while (types.hasNext()) {
                        SwitchableType otherType = (SwitchableType)types.next();
                        if (otherType == type || !otherType.isSufficientlyExpressive(namedClass)) continue;
                        JRadioButton otherButton = this.getRadioButton(otherType);
                        otherButton.setSelected(true);
                        this.switchTo(otherType);
                        if (!showWarning) continue block0;
                        ProtegeUI.getModalDialogFactory().showMessageDialog(namedClass.getOWLModel(), "The class " + namedClass.getBrowserText() + " uses OWL features\nthat cannot be displayed with the " + type.getButtonText() + ".\nWe therefore switch to the " + otherType.getButtonText() + ".");
                        showWarning = false;
                        continue block0;
                    }
                    continue;
                }
                button.setEnabled(true);
                button.setToolTipText(null);
            }
        }

        private JRadioButton getRadioButton(SwitchableType type) {
            return (JRadioButton)this.types2RadioButton.get(type);
        }
    }
}

