/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class DisjointClassesTableModel
extends AbstractTableModel
implements ClassDescriptionTableModel {
    private OWLNamedClass cls;
    private List rows = new ArrayList();
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            if (property.getName().equals("owl:disjointWith")) {
                DisjointClassesTableModel.this.clearRows();
                DisjointClassesTableModel.this.addRows();
            }
        }
    };

    public int addEmptyRow(int rowIndex) {
        int index = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(index, index);
        return index;
    }

    public boolean addRow(RDFSClass rdfsClass, int rowIndex) {
        this.addDisjointClass(rdfsClass);
        return true;
    }

    private void addDisjointClass(RDFSClass rdfsClass) {
        OWLModel owlModel = rdfsClass.getOWLModel();
        if (rdfsClass.equals(owlModel.getOWLThingClass())) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "You cannot make a class disjoint with owl:Thing.");
            return;
        }
        try {
            try {
                OWLNamedClass namedCls;
                owlModel.beginTransaction("Add " + rdfsClass.getBrowserText() + " to disjoint classes of " + this.getEditedCls().getBrowserText());
                this.getEditedCls().addDisjointClass(rdfsClass);
                if (rdfsClass instanceof OWLNamedClass && rdfsClass.isEditable() && !(namedCls = (OWLNamedClass)rdfsClass).getDisjointClasses().contains(this.getEditedCls())) {
                    namedCls.addDisjointClass(this.getEditedCls());
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    private void addRows() {
        Collection disjointClasses = this.cls.getDisjointClasses();
        for (RDFSClass disjointClass : disjointClasses) {
            this.insertRow(disjointClass);
        }
    }

    void clearRows() {
        int count = this.getRowCount();
        this.rows.clear();
        if (count > 0) {
            this.fireTableRowsDeleted(0, count - 1);
        }
    }

    public void deleteRow(int index) {
        RDFSClass disjointClass = this.getClass(index);
        OWLModel owlModel = disjointClass.getOWLModel();
        try {
            try {
                OWLNamedClass namedCls;
                owlModel.beginTransaction("Delete disjoint class " + disjointClass.getBrowserText() + " from " + this.getEditedCls().getBrowserText());
                if (disjointClass instanceof OWLNamedClass && disjointClass.isEditable() && (namedCls = (OWLNamedClass)disjointClass).getDisjointClasses().contains(this.getEditedCls())) {
                    namedCls.removeDisjointClass(this.getEditedCls());
                }
                this.cls.removeDisjointClass(disjointClass);
                this.fireTableRowsDeleted(index, index);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    public void displaySemanticError(String message) {
        OWLModel owlModel = this.cls == null ? null : this.cls.getOWLModel();
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Semantic Error");
    }

    public void dispose() {
        if (this.cls != null) {
            this.removeListeners();
        }
    }

    Cls getCls() {
        return this.cls;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int column) {
        return "Expression";
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public RDFSClass getClass(int rowIndex) {
        return (RDFSClass)this.rows.get(rowIndex);
    }

    public int getClassRow(RDFSClass cls) {
        return this.rows.indexOf(cls);
    }

    public OWLNamedClass getEditedCls() {
        return this.cls;
    }

    public RDFProperty getPredicate(int row) {
        return this.cls.getOWLModel().getOWLDisjointWithProperty();
    }

    public RDFResource getRDFResource(int row) {
        return this.getClass(row);
    }

    public RDFResource getSubject() {
        return this.cls;
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Icon getIcon(RDFResource resource) {
        int row;
        if (resource instanceof RDFSClass && this.isCellEditable(row = this.getRow((RDFSClass)resource), 0) && resource instanceof OWLNamedClass) {
            if (((OWLNamedClass)resource).isDefinedClass()) {
                return OWLIcons.getImageIcon("DefinedOWLClass");
            }
            return OWLIcons.getImageIcon("PrimitiveClass");
        }
        return ProtegeUI.getIcon(resource);
    }

    int getRow(Cls superCls) {
        return this.rows.indexOf(superCls);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rows.get(rowIndex) == null) {
            return "";
        }
        RDFSClass cls = this.getClass(rowIndex);
        return cls.getBrowserText();
    }

    private void insertRow(RDFSClass rdfsClass) {
        int index = this.rows.size();
        this.rows.add(index, rdfsClass);
        this.fireTableRowsInserted(index, index);
    }

    public boolean isAddEnabledAt(int rowIndex) {
        return this.isEditable();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        RDFSClass cls = this.getClass(rowIndex);
        return cls == null || this.isDeleteEnabledFor(cls);
    }

    public boolean isDeleteEnabledFor(RDFSClass cls) {
        if (cls != null) {
            OWLModel owlModel = cls.getOWLModel();
            RDFProperty disjointWithProperty = owlModel.getOWLDisjointWithProperty();
            return owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), disjointWithProperty, cls);
        }
        return false;
    }

    public boolean isEditable() {
        return this.getEditedCls().isEditable();
    }

    public boolean isRemoveEnabledFor(Cls otherClass) {
        for (Cls superCls : this.getEditedCls().getSuperclasses(false)) {
            if (!(superCls instanceof OWLNamedClass) || !((OWLNamedClass)superCls).getSubclassesDisjoint() || !superCls.getDirectSubclasses().contains(otherClass)) continue;
            return false;
        }
        OWLModel owlModel = this.getEditedCls().getOWLModel();
        return otherClass instanceof OWLNamedClass && owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), owlModel.getOWLDisjointWithProperty(), otherClass);
    }

    public void removeEmptyRow() {
        int rowIndex = this.rows.indexOf(null);
        if (rowIndex >= 0) {
            this.rows.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    private void removeListeners() {
        this.cls.removePropertyValueListener(this.valueListener);
    }

    public void setCls(OWLNamedClass newCls) {
        this.clearRows();
        if (this.cls != null) {
            this.removeListeners();
        }
        this.cls = newCls;
        if (this.cls != null) {
            this.cls.addPropertyValueListener(this.valueListener);
            this.addRows();
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        String text = (String)value;
        OWLModel owlModel = this.cls.getOWLModel();
        try {
            OWLClassParser parser = owlModel.getOWLClassParser();
            RDFSClass newClass = parser.parseClass(owlModel, text);
            RDFSClass oldClass = this.getClass(rowIndex);
            if (oldClass == null || !value.equals(oldClass)) {
                if (this.cls.getDisjointClasses().contains(newClass)) {
                    this.displaySemanticError("The class " + newClass.getBrowserText() + " is already a disjoint class of " + this.cls.getBrowserText() + ".");
                } else {
                    this.setValueAt(newClass, oldClass);
                }
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
    }

    private void setValueAt(RDFSClass newClass, RDFSClass oldClass) {
        OWLModel owlModel = newClass.getOWLModel();
        try {
            try {
                owlModel.beginTransaction("Change disjoint class to " + newClass.getBrowserText());
                this.addDisjointClass(newClass);
                if (oldClass != null) {
                    this.cls.removeDisjointClass(oldClass);
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }
}

