/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class NewRestrictionTreeNode
extends RestrictionTreeNode {
    private Cls metaCls;
    private PropertyRestrictionsTree tree;

    public NewRestrictionTreeNode(Cls metaCls, PropertyRestrictionsTree tree) {
        this.metaCls = metaCls;
        this.tree = tree;
    }

    public void checkExpression(String text) throws Throwable {
        RDFProperty property = this.getParentNode().getRDFProperty();
        String metaClsName = this.metaCls.getName();
        if (metaClsName.equals("owl:HasValueRestriction")) {
            DefaultOWLHasValue.checkFillerText(text, property);
        } else if (metaClsName.equals("owl:AllValuesFromRestriction") || metaClsName.equals("owl:SomeValuesFromRestriction")) {
            AbstractOWLQuantifierRestriction.checkFillerText(text, property);
        } else {
            AbstractOWLCardinalityBase.checkFillerText(text, property);
        }
    }

    public String getFillerText() {
        return "";
    }

    public Icon getIcon() {
        return RestrictionKindRenderer.getClsIcon(this.metaCls);
    }

    public char getOperator() {
        String name = this.metaCls.getName();
        if ("owl:AllValuesFromRestriction".equals(name)) {
            return '\u2200';
        }
        if ("owl:HasValueRestriction".equals(name)) {
            return '\u220b';
        }
        if ("owl:SomeValuesFromRestriction".equals(name)) {
            return '\u2203';
        }
        if ("owl:CardinalityRestriction".equals(name)) {
            return '=';
        }
        if ("owl:MaxCardinalityRestriction".equals(name)) {
            return '\u2264';
        }
        if ("owl:MinCardinalityRestriction".equals(name)) {
            return '\u2265';
        }
        return '?';
    }

    public Cls getRestrictionMetaCls() {
        return this.metaCls;
    }

    public RDFSClass getInheritedFromClass() {
        return null;
    }

    public boolean isInherited() {
        return false;
    }

    public void setUserObject(Object userObject) {
        KnowledgeBase kb = this.metaCls.getKnowledgeBase();
        OWLModel owlModel = (OWLModel)kb;
        try {
            OWLNamedClass cls = this.getParentNode().getRestrictedClass();
            owlModel.beginTransaction("Add restriction on property " + this.getParentNode().getRDFProperty().getBrowserText() + " at class " + cls.getBrowserText());
            Cls anonRootCls = owlModel.getCls(":OWL-ANONYMOUS-ROOT");
            OWLRestriction restriction = (OWLRestriction)kb.createCls(null, (Collection)Collections.singleton(anonRootCls), this.metaCls);
            restriction.setOnProperty(this.getParentNode().getRDFProperty());
            String text = (String)userObject;
            restriction.setFillerText(text);
            RDFSClass definition = cls.getDefinition();
            if (definition != null) {
                if (definition instanceof OWLIntersectionClass) {
                    ((OWLIntersectionClass)definition).addOperand(restriction);
                    owlModel.endTransaction();
                    this.tree.refill();
                } else {
                    OWLIntersectionClass intersectionCls = owlModel.createOWLIntersectionClass();
                    intersectionCls.addOperand(definition.createClone());
                    intersectionCls.addOperand(restriction);
                    cls.setDefinition(intersectionCls);
                    owlModel.endTransaction();
                }
            } else {
                cls.addSuperclass(restriction);
                owlModel.endTransaction();
            }
            this.tree.setSelectedRestriction(restriction);
        }
        catch (Exception ex) {
            OWLUI.handleError(owlModel, ex);
            owlModel.endTransaction();
        }
    }
}

