/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.CellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class SymbolTextArea
extends JTextArea
implements KeyListener,
SymbolEditor {
    private CellEditor cellEditor;
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel owlModel;
    private KeyEvent previousKeyPressed;
    private SyntaxConverter syntaxConverter;

    public SymbolTextArea(OWLModel kb, SymbolErrorDisplay errorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.owlModel = kb;
        this.resourceNameMatcher = resourceNameMatcher;
        this.errorDisplay = errorDisplay;
        this.syntaxConverter = syntaxConverter;
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (SymbolTextArea.this.previousKeyPressed != null) {
                    int keyCode = SymbolTextArea.this.previousKeyPressed.getKeyCode();
                    if (!SymbolTextField.isIdChar(SymbolTextArea.this.previousKeyPressed.getKeyChar()) && keyCode != 8 && keyCode != 127) {
                        SymbolTextArea.this.closeComboBox();
                    }
                }
            }
        });
        this.setFont(this.getFont().deriveFont(16.0f));
    }

    private void acceptSelectedFrame() {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        this.extendPartialName(prefix, ((Frame)this.comboBox.getSelectedItem()).getBrowserText());
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    public void assignExpression() {
        this.handleEnter();
    }

    public void backspace() {
        String selText = this.getSelectedText();
        if (selText != null && selText.length() > 0) {
            int start = this.getSelectionStart();
            try {
                this.getDocument().remove(start, this.getSelectionEnd() - start);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            this.setCaretPosition(start);
        } else {
            int pos = this.getCaretPosition();
            if (pos > 0) {
                try {
                    this.getDocument().remove(pos - 1, 1);
                }
                catch (BadLocationException ex) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                }
                this.setCaretPosition(pos - 1);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void cancelEditing() {
        this.handleEscape();
    }

    protected abstract void checkUniCodeExpression(String var1) throws Throwable;

    private void closeComboBox() {
        this.removeAll();
    }

    public void displayError() {
        try {
            String uniCodeText = this.getText();
            this.checkUniCodeExpression(uniCodeText);
            this.errorDisplay.displayError((Throwable)null);
        }
        catch (Throwable ex) {
            this.errorDisplay.displayError(ex);
        }
        this.requestFocus();
    }

    private void extendPartialName(String prefix, String fullName) {
        try {
            this.getDocument().remove(this.getCaretPosition() - prefix.length(), prefix.length());
            this.getDocument().insertString(this.getCaretPosition(), fullName, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean autoInsert) {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        String leftString = text.substring(0, i + 1);
        List resources = this.resourceNameMatcher.getMatchingResources(prefix, leftString, this.owlModel);
        if (autoInsert && resources.size() == 1) {
            RDFResource resource = (RDFResource)resources.get(0);
            this.extendPartialName(prefix, this.resourceNameMatcher.getInsertString(resource));
            this.closeComboBox();
        } else if (resources.size() > 1) {
            this.showComboBox(resources, i + 1);
        }
    }

    public String getIndentedClsString(OWLNAryLogicalClass cls, String indentation) {
        boolean first = indentation.length() == 0;
        String str = first ? "" : "(";
        char operator = cls instanceof OWLUnionClass ? (char)'\u2294' : '\u2293';
        Iterator it = cls.getOperands().iterator();
        while (it.hasNext()) {
            RDFSClass operand = (RDFSClass)it.next();
            str = String.valueOf(str) + indentation;
            str = operand instanceof OWLNAryLogicalClass ? String.valueOf(str) + this.getIndentedClsString((OWLNAryLogicalClass)operand, String.valueOf(indentation) + "    ") : String.valueOf(str) + operand.getBrowserText();
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + " " + operator + "\n";
        }
        if (!first) {
            str = String.valueOf(str) + ")";
        }
        return str;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private int getXOfPosition(int pos) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        return metrics.stringWidth(this.getText().substring(0, pos));
    }

    private boolean handleDown() {
        if (this.comboBox != null && this.comboBox.isVisible()) {
            int index = this.comboBox.getSelectedIndex();
            if (index < this.comboBox.getItemCount() - 1) {
                this.comboBox.setSelectedIndex(index + 1);
            }
            return true;
        }
        return false;
    }

    boolean handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedFrame();
            return true;
        }
        return false;
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else if (this.cellEditor != null) {
            this.cellEditor.cancelCellEditing();
        }
    }

    private boolean handleUp() {
        if (this.isComboBoxVisible()) {
            int index = this.comboBox.getSelectedIndex();
            if (index > 0) {
                this.comboBox.setSelectedIndex(index - 1);
            }
            return true;
        }
        return false;
    }

    public void insertText(String text) {
        this.insertText(text, text.length());
    }

    public void insertText(String text, int caretOffset) {
        String selText = this.getSelectedText();
        if (selText != null && selText.length() > 0) {
            int start = this.getSelectionStart();
            try {
                this.getDocument().remove(start, this.getSelectionEnd() - start);
                this.getDocument().insertString(start, text, null);
                this.setCaretPosition(start + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        } else {
            try {
                int pos = this.getCaretPosition();
                this.getDocument().insertString(pos, text, null);
                this.setCaretPosition(pos + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        this.updateErrorDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SymbolTextArea.this.requestFocus();
            }
        });
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    public void keyPressed(KeyEvent e) {
        this.updateErrorDisplay();
        this.previousKeyPressed = e;
        int code = e.getKeyCode();
        if (e.getKeyCode() == 9 || e.getKeyChar() == ' ' && (e.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            e.consume();
        } else {
            switch (code) {
                case 40: {
                    if (!this.handleDown()) break;
                    e.consume();
                    break;
                }
                case 38: {
                    if (!this.handleUp()) break;
                    e.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    e.consume();
                    break;
                }
                case 10: {
                    if (!this.handleEnter()) break;
                    e.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        this.updateErrorDisplay();
        this.perhapsUpdateSyntax(e);
        int code = e.getKeyCode();
        if (code != 40 && code != 38) {
            this.refreshComboBox();
        }
    }

    public void keyTyped(KeyEvent e) {
        this.perhapsUpdateSyntax(e);
    }

    private void perhapsUpdateSyntax(KeyEvent e) {
        if (this.syntaxConverter != null) {
            char ch = e.getKeyChar();
            int code = e.getKeyCode();
            if (!SymbolTextField.isIdChar(ch) && code != 8 && code != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String leftString;
            String text = this.getText();
            int pos = this.getCaretPosition();
            int i = pos - 1;
            while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
                --i;
            }
            String prefix = text.substring(i + 1, pos);
            List frames = this.resourceNameMatcher.getMatchingResources(prefix, leftString = text.substring(0, i + 1), this.owlModel);
            if (frames.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(frames, i + 1);
            }
        }
    }

    void replaceText(String text) {
        this.setText(text);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    private void showComboBox(List frames, int startIndex) {
        this.closeComboBox();
        Frame[] fs = frames.toArray(new Frame[0]);
        Arrays.sort(fs, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(fs);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int x = this.getXOfPosition(startIndex) - 16;
        String str = this.getText();
        int h = 1;
        int caretPosition = this.getCaretPosition();
        String part = "";
        int i = 0;
        while (i < caretPosition) {
            part = String.valueOf(part) + str.charAt(i);
            if (str.charAt(i) == '\n') {
                ++h;
                part = "";
            }
            ++i;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        x = fm.stringWidth(part);
        this.comboBox.setLocation(x, this.getRowHeight() * h);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((long)e.getModifiers() & 0x10L) != 0L) {
                    SymbolTextArea.this.acceptSelectedFrame();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    private void updateErrorDisplay() {
        String uniCodeText = this.getText();
        try {
            this.checkUniCodeExpression(uniCodeText);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable ex) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }
}

