/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AddResourceAction
extends ResourceSelectionAction {
    private AddablePropertyValuesComponent component;
    private boolean symmetric;

    public AddResourceAction(AddablePropertyValuesComponent component, boolean symmetric) {
        super("Add...", OWLIcons.getAddIcon("RDFIndividual"), true);
        this.component = component;
        this.symmetric = symmetric;
    }

    public Collection getSelectableResources() {
        AbstractCollection values;
        RDFResource subject = this.component.getSubject();
        RDFProperty predicate = this.component.getPredicate();
        OWLModel owlModel = subject.getOWLModel();
        if (this.isClassProperty()) {
            values = owlModel.getUserDefinedRDFSNamedClasses();
        } else {
            RDFSNamedClass type = (RDFSNamedClass)subject.getProtegeType();
            Collection clses = type.getUnionRangeClasses(predicate);
            if (clses.size() > 0 && !OWLUtil.containsAnonymousClass(clses)) {
                values = new HashSet();
                for (Cls cls : clses) {
                    if (!cls.isVisible()) continue;
                    values.addAll(cls.getInstances());
                }
            } else {
                values = predicate instanceof OWLProperty ? new ArrayList(owlModel.getOWLIndividuals(true)) : new ArrayList(owlModel.getRDFIndividuals(true));
            }
        }
        if (OWLUI.isExternalResourcesSupported(owlModel)) {
            values.addAll(owlModel.getRDFUntypedResourcesClass().getInstances(false));
        }
        values.remove(subject);
        values.removeAll(subject.getPropertyValues(predicate));
        return AbstractOWLModel.getRDFResources(owlModel, values);
    }

    private boolean isClassProperty() {
        RDFResource subject = this.component.getSubject();
        RDFProperty predicate = this.component.getPredicate();
        RDFSNamedClass type = (RDFSNamedClass)subject.getProtegeType();
        Collection clses = type.getUnionRangeClasses(predicate);
        RDFSNamedClass metaclass = predicate.getOWLModel().getRDFSNamedClassClass();
        if (clses.size() == 1) {
            RDFSClass range = (RDFSClass)clses.iterator().next();
            return range.equals(metaclass) || range.getSuperclasses(true).contains(metaclass);
        }
        return false;
    }

    private boolean isPropertyProperty() {
        RDFResource subject = this.component.getSubject();
        RDFProperty predicate = this.component.getPredicate();
        if (predicate.getValueType() == ValueType.INSTANCE) {
            RDFSNamedClass type = (RDFSNamedClass)subject.getProtegeType();
            Collection clses = type.getUnionRangeClasses(predicate);
            RDFSNamedClass metaclass = predicate.getOWLModel().getRDFPropertyClass();
            return clses.size() == 1 && ((RDFSClass)clses.iterator().next()).getSuperclasses(true).contains(metaclass);
        }
        return false;
    }

    public Collection pickResources() {
        Set result;
        RDFResource subject = this.component.getSubject();
        RDFProperty predicate = this.component.getPredicate();
        OWLModel owlModel = predicate.getOWLModel();
        if (OWLUI.isExternalResourcesSupported(owlModel)) {
            owlModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        if (this.isClassProperty()) {
            String title = "Select classes to add";
            result = ProtegeUI.getSelectionDialogFactory().selectClasses(this.component, owlModel, title);
        } else if (this.isPropertyProperty()) {
            String title = "Select properties to add";
            Collection properties = owlModel.getVisibleUserDefinedRDFProperties();
            result = ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this.component, owlModel, properties, title);
        } else {
            RDFSNamedClass type = (RDFSNamedClass)subject.getRDFType();
            Collection clses = type.getUnionRangeClasses(predicate);
            if (OWLUtil.containsAnonymousClass(clses) || clses.isEmpty()) {
                clses = Collections.singleton(owlModel.getOWLThingClass());
            }
            result = ProtegeUI.getSelectionDialogFactory().selectResourcesByType(this.component, owlModel, clses);
        }
        owlModel.getRDFUntypedResourcesClass().setVisible(false);
        return result;
    }

    public void resourceSelected(RDFResource resource) {
        RDFProperty predicate;
        RDFResource subject = this.component.getSubject();
        if (subject.getPropertyValues(predicate = this.component.getPredicate()).contains(resource)) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(subject.getOWLModel(), "The object " + resource.getBrowserText() + " is already in the list.");
        } else {
            this.component.addObject(resource, this.symmetric);
        }
    }
}

