/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.multiresource.MultiResourceListModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

public class MultiResourceList
extends SelectableList
implements TripleSelectable {
    private MultiResourceListModel listModel;
    private boolean symmetric;

    public MultiResourceList(RDFProperty predicate, boolean symmetric) {
        this.symmetric = symmetric;
        this.listModel = new MultiResourceListModel(predicate);
        this.setModel(this.listModel);
        this.setCellRenderer(this.createRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MultiResourceList.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)((Object)this)){

            protected JPopupMenu getPopupMenu() {
                return MultiResourceList.this.createPopupMenu();
            }

            protected void setSelection(JComponent c, int x, int y) {
                int i = 0;
                while (i < MultiResourceList.this.listModel.getSize()) {
                    if (MultiResourceList.this.getCellBounds(i, i).contains(x, y)) {
                        MultiResourceList.this.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
                MultiResourceList.this.clearSelection();
            }
        });
    }

    protected ListCellRenderer createRenderer() {
        return new ResourceRenderer(){

            public void load(Object value) {
                int row = MultiResourceList.this.listModel.getRowOf(value);
                if (row >= 0 && !MultiResourceList.this.listModel.isEditable(row)) {
                    this.setGrayedText(true);
                }
                super.load(value);
            }
        };
    }

    protected JPopupMenu createPopupMenu() {
        Object value;
        int[] sels = this.getSelectedIndices();
        if (sels.length == 1 && (value = this.listModel.getElementAt(sels[0])) instanceof RDFResource) {
            JPopupMenu menu = new JPopupMenu();
            RDFResource resource = (RDFResource)value;
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), resource);
            if (menu.getComponentCount() > 0) {
                return menu;
            }
        }
        return null;
    }

    public MultiResourceListModel getListModel() {
        return this.listModel;
    }

    public List getPrototypeTriples() {
        RDFResource subject = this.listModel.getSubject();
        RDFProperty predicate = this.listModel.getPredicate();
        return Collections.singletonList(new DefaultTriple(subject, predicate, null));
    }

    public List getSelectedTriples() {
        RDFResource subject = this.listModel.getSubject();
        RDFProperty predicate = this.listModel.getPredicate();
        ArrayList<DefaultTriple> results = new ArrayList<DefaultTriple>();
        for (Object object : this.getSelection()) {
            results.add(new DefaultTriple(subject, predicate, object));
        }
        return results;
    }

    protected void handleCreate() {
        RDFResource subject = this.listModel.getSubject();
        RDFProperty predicate = this.listModel.getPredicate();
        OWLModel owlModel = predicate.getOWLModel();
        RDFSNamedClass type = (RDFSNamedClass)subject.getRDFType();
        ArrayList<RDFSNamedClass> clses = new ArrayList<RDFSNamedClass>(type.getUnionRangeClasses(predicate));
        if (OWLUtil.containsAnonymousClass(clses) || clses.isEmpty()) {
            clses.clear();
            clses.add(owlModel.getOWLThingClass());
        } else if (OWLUI.isExternalResourcesSupported(owlModel)) {
            clses.add(owlModel.getRDFUntypedResourcesClass());
        }
        if (OWLUI.isExternalResourcesSupported(owlModel)) {
            owlModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        RDFSNamedClass cls = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), owlModel, clses, "Select type of new resource");
        owlModel.getRDFUntypedResourcesClass().setVisible(false);
        if (cls != null) {
            RDFSClass newcls;
            RDFResource instance = cls.createInstance(null);
            if (instance instanceof RDFUntypedResource) {
                OWLUtil.assignUniqueURI((RDFUntypedResource)instance);
            } else if (instance instanceof RDFSClass && (newcls = (RDFSClass)instance).getSuperclassCount() == 0) {
                newcls.addSuperclass(owlModel.getOWLThingClass());
            }
            subject.addPropertyValue(predicate, instance);
            if (this.symmetric) {
                instance.addPropertyValue(predicate, subject);
            }
            owlModel.getProject().show((Instance)instance);
        }
    }

    private void handleDoubleClick() {
        Project project = this.listModel.getPredicate().getOWLModel().getProject();
        int[] sels = this.getSelectedIndices();
        int i = 0;
        while (i < sels.length) {
            int sel = sels[i];
            Object value = this.listModel.getElementAt(sel);
            if (value instanceof RDFResource) {
                project.show((Instance)((RDFResource)value));
            }
            ++i;
        }
    }

    protected void handleRemove() {
        int[] sels = this.getSelectedIndices();
        HashSet<Object> valuesToRemove = new HashSet<Object>();
        int i = 0;
        while (i < sels.length) {
            int sel = sels[i];
            valuesToRemove.add(this.listModel.getElementAt(sel));
            ++i;
        }
        RDFProperty predicate = this.listModel.getPredicate();
        RDFResource subject = this.listModel.getSubject();
        for (Object e : valuesToRemove) {
            RDFResource other;
            subject.removePropertyValue(predicate, e);
            if (!this.symmetric || !(e instanceof RDFResource) || !(other = (RDFResource)e).getPropertyValues(predicate).contains(subject)) continue;
            other.removePropertyValue(predicate, subject);
        }
    }

    public boolean isRemoveEnabled() {
        int[] sels = this.getSelectedIndices();
        if (sels.length > 0) {
            int i = 0;
            while (i < sels.length) {
                int sel = sels[i];
                if (!this.isRemoveEnabled(sel)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isRemoveEnabled(int row) {
        return this.listModel.isEditable(row);
    }

    public void setSelectedTriples(Collection triples) {
        this.getSelectionModel().clearSelection();
        for (Triple triple : triples) {
            int row = this.listModel.getRowOf(triple.getObject());
            if (row < 0) continue;
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }
}

