/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleliteral;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public abstract class AbstractSingleLiteralComponent
extends AbstractPropertyValuesComponent {
    private JComboBox booleanComboBox;
    private JComboBox datatypeComboBox;
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            AbstractSingleLiteralComponent.this.handleDeleteAction();
        }
    };
    private JPanel mainPanel;
    private JTextComponent textComponent;
    private Component textComponentHolder;
    private static final String UNDEFINED = "undefined";
    private Action viewAction = new AbstractAction("View/edit value...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            AbstractSingleLiteralComponent.this.handleViewAction();
        }
    };

    public AbstractSingleLiteralComponent(RDFProperty predicate) {
        super(predicate);
        OWLModel owlModel = this.getOWLModel();
        this.datatypeComboBox = ComponentUtil.createDatatypeComboBox(owlModel);
        int height = this.datatypeComboBox.getPreferredSize().height;
        this.datatypeComboBox.setPreferredSize(new Dimension(80, height));
        this.datatypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractSingleLiteralComponent.this.assignTextFieldValue();
                AbstractSingleLiteralComponent.this.updateTextFieldAlignment((RDFSDatatype)AbstractSingleLiteralComponent.this.datatypeComboBox.getSelectedItem());
            }
        });
        this.booleanComboBox = new JComboBox<Object>(new Object[]{UNDEFINED, Boolean.FALSE, Boolean.TRUE});
        this.booleanComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractSingleLiteralComponent.this.assignBooleanComboBoxValue();
            }
        });
        this.textComponent = this.createTextComponent();
        this.textComponent.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractSingleLiteralComponent.this.assignTextFieldValue();
            }
        });
        this.textComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstractSingleLiteralComponent.this.assignTextFieldValue();
                }
            }
        });
        OWLUI.addCopyPastePopup(this.textComponent);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("East", this.datatypeComboBox);
        this.textComponentHolder = this.createTextComponentHolder(this.textComponent);
        this.mainPanel.add("Center", this.textComponentHolder);
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), this.mainPanel);
        lc.addHeaderButton(this.viewAction);
        lc.addHeaderButton(this.deleteAction);
        if (this.textComponentHolder instanceof JScrollPane) {
            lc.setVerticallyStretchable(true);
        }
        this.add((Component)((Object)lc));
    }

    protected abstract JTextComponent createTextComponent();

    protected abstract Component createTextComponentHolder(JTextComponent var1);

    private void assignBooleanComboBoxValue() {
        Object sel = this.booleanComboBox.getSelectedItem();
        if (UNDEFINED.equals(sel)) {
            this.getSubject().setPropertyValue(this.getPredicate(), null);
        } else {
            this.getSubject().setPropertyValue(this.getPredicate(), sel);
        }
    }

    private void assignTextFieldValue() {
        Object oldValue = this.getSubject().getPropertyValue(this.getPredicate());
        String text = this.textComponent.getText().trim();
        Object newValue = null;
        if (text.length() > 0) {
            RDFSDatatype datatype = this.getDatatype();
            if (this.getOWLModel().getXSDstring().equals(datatype)) {
                String language = null;
                if (oldValue instanceof RDFSLiteral) {
                    RDFSLiteral oldLiteral = (RDFSLiteral)oldValue;
                    if (oldLiteral.getLanguage() != null) {
                        language = oldLiteral.getLanguage();
                        newValue = this.getOWLModel().createRDFSLiteral(text, language);
                    } else {
                        newValue = text;
                    }
                } else {
                    newValue = text;
                }
            } else {
                newValue = this.getOWLModel().createRDFSLiteral(text, datatype);
            }
        }
        if (newValue == null) {
            this.getSubject().setPropertyValue(this.getPredicate(), null);
        } else {
            newValue = DefaultRDFSLiteral.getPlainValueIfPossible(newValue);
            Collection oldValues = this.getSubject().getPropertyValues(this.getPredicate(), true);
            if (!oldValues.contains(newValue)) {
                this.getSubject().setPropertyValue(this.getPredicate(), newValue);
            }
        }
    }

    private RDFSDatatype getDatatype() {
        return (RDFSDatatype)this.datatypeComboBox.getSelectedItem();
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void handleDeleteAction() {
        this.textComponent.setText("");
        this.assignTextFieldValue();
        this.resetDatatypeComboBox();
    }

    private void handleViewAction() {
        Object object = this.getObject();
        PropertyValueEditor editor = this.getEditor(object);
        if (editor != null) {
            Object newValue;
            if (this.getObject() == null) {
                object = editor.createDefaultValue(this.getSubject(), this.getPredicate());
            }
            if ((newValue = editor.editValue(null, this.getSubject(), this.getPredicate(), object)) != null) {
                this.getSubject().setPropertyValue(this.getPredicate(), newValue);
            }
        }
    }

    private boolean hasOnlyActiveValues() {
        if (this.getSubject() != null) {
            Collection values = this.getSubject().getPropertyValues(this.getPredicate());
            TripleStoreModel tsm = this.getOWLModel().getTripleStoreModel();
            for (Object value : values) {
                if (tsm.isActiveTriple(this.getSubject(), this.getPredicate(), value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isRangeDefined() {
        RDFResource resource = this.getSubject();
        RDFProperty property = this.getPredicate();
        return ComponentUtil.isRangeDefined(resource, property);
    }

    private void resetDatatypeComboBox() {
        RDFResource range = this.getPredicate().getRange();
        if (range instanceof RDFSDatatype) {
            this.setDatatypeComboBoxItem(range);
            this.updateTextFieldAlignment((RDFSDatatype)range);
        } else {
            Collection types = this.getSubject().getRDFTypes();
            for (RDFSClass type : types) {
                if (!(type instanceof OWLNamedClass)) continue;
                OWLNamedClass namedClass = (OWLNamedClass)type;
                RDFResource allValuesFrom = namedClass.getAllValuesFrom(this.getPredicate());
                if (allValuesFrom instanceof RDFSDatatype) {
                    this.setDatatypeComboBoxItem(allValuesFrom);
                    this.updateTextFieldAlignment((RDFSDatatype)allValuesFrom);
                    return;
                }
                RDFResource someValuesFrom = namedClass.getSomeValuesFrom(this.getPredicate());
                if (!(someValuesFrom instanceof RDFSDatatype)) continue;
                this.setDatatypeComboBoxItem(someValuesFrom);
                this.updateTextFieldAlignment((RDFSDatatype)someValuesFrom);
                return;
            }
        }
    }

    private void setDatatypeComboBoxItem(RDFResource range) {
        if (!this.datatypeComboBox.getSelectedItem().equals(range)) {
            this.datatypeComboBox.setSelectedItem(range);
        }
    }

    public void setSubject(RDFResource subject) {
        super.setSubject(subject);
        this.updateComboBoxVisibility();
        boolean editable = this.hasOnlyEditableValues();
        boolean b = editable && this.hasOnlyActiveValues() && subject.getHasValuesOnTypes(this.getPredicate()).isEmpty();
        this.textComponent.setEditable(b);
        this.booleanComboBox.setEnabled(b);
        this.datatypeComboBox.setEnabled(b && !this.isRangeDefined());
    }

    private void updateActionStatus() {
        boolean editable = this.hasOnlyEditableValues();
        this.deleteAction.setEnabled(this.getSubject() != null && this.getSubject().getPropertyValue(this.getPredicate()) != null && editable);
        Object object = this.getObject();
        PropertyValueEditor editor = this.getEditor(object);
        this.viewAction.setEnabled(editable && editor != null);
    }

    private void updateComboBoxVisibility() {
        OWLModel owlModel;
        boolean defaultDatatype;
        RDFProperty property = this.getPredicate();
        RDFSDatatype datatype = null;
        Collection types = this.getSubject().getRDFTypes();
        for (RDFSClass type : types) {
            OWLNamedClass namedClass;
            RDFResource allValuesFrom;
            if (!(type instanceof OWLNamedClass) || !((allValuesFrom = (namedClass = (OWLNamedClass)type).getAllValuesFrom(property)) instanceof RDFSDatatype)) continue;
            datatype = (RDFSDatatype)allValuesFrom;
        }
        if (datatype == null) {
            RDFResource range = property.getRange();
            if (range instanceof RDFSDatatype) {
                datatype = (RDFSDatatype)range;
            }
        } else if (datatype.getBaseDatatype() != null) {
            datatype = datatype.getBaseDatatype();
        }
        boolean bl = defaultDatatype = (owlModel = this.getOWLModel()).getXSDboolean().equals(datatype) || owlModel.getXSDstring().equals(datatype) || owlModel.getXSDint().equals(datatype) || owlModel.getXSDfloat().equals(datatype);
        if (defaultDatatype) {
            this.mainPanel.remove(this.datatypeComboBox);
        } else {
            this.mainPanel.add("East", this.datatypeComboBox);
        }
    }

    private void updateDatatypeComboBox(Object value) {
        RDFSDatatype type = this.getOWLModel().getRDFSDatatypeOfValue(value);
        if (type != null) {
            this.setDatatypeComboBoxItem(type);
            this.updateTextFieldAlignment(type);
        } else {
            this.updateDatatypeComboBox(this.getOWLModel().getXSDstring());
        }
    }

    private void updateTextFieldAlignment(RDFSDatatype type) {
        if (this.getOWLModel().getXSDboolean().equals(type)) {
            if (this.booleanComboBox.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.textComponentHolder);
                this.mainPanel.add("Center", this.booleanComboBox);
            }
        } else {
            boolean numericDatatype = type.isNumericDatatype();
            this.updateTextFieldAlignment(numericDatatype);
            if (this.textComponentHolder.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.booleanComboBox);
                this.mainPanel.add("Center", this.textComponentHolder);
            }
        }
    }

    protected void updateTextFieldAlignment(boolean numericDatatype) {
    }

    public void valuesChanged() {
        ArrayList values = new ArrayList(this.getObjects(true));
        Collection hasValues = this.getSubject().getHasValuesOnTypes(this.getPredicate());
        for (Object hasValue : hasValues) {
            if (values.contains(hasValue)) continue;
            values.add(hasValue);
        }
        Iterator it = values.iterator();
        if (it.hasNext()) {
            Object value = it.next();
            this.textComponent.setText("" + value);
            if (value instanceof Boolean) {
                this.booleanComboBox.setSelectedItem(value);
            }
            this.updateDatatypeComboBox(value);
        } else {
            this.textComponent.setText("");
            this.booleanComboBox.setSelectedItem(UNDEFINED);
            this.resetDatatypeComboBox();
        }
        this.updateActionStatus();
    }
}

