/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeRoot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ExistentialTreePanel
extends SelectableContainer
implements Hierarchy {
    private OWLObjectProperty existentialProperty;
    private HeaderComponent headerComponent;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private Cls root;
    private Slot superclassesSlot;
    private Action viewAction;

    public ExistentialTreePanel(Cls root, Slot superclassesSlot, OWLObjectProperty existentialProperty) {
        this.root = root;
        this.superclassesSlot = superclassesSlot;
        this.existentialProperty = existentialProperty;
        this.setPreferredSize(new Dimension(260, 400));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = (OWLModel)root.getKnowledgeBase();
        this.viewAction = this.createViewClsAction();
        SelectableTree tree = this.createTree(root);
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("Center", new JScrollPane((Component)tree));
        String label = this.getTitle();
        this.lc = new OWLLabeledComponent(label, this.mainPanel, true, false);
        this.viewAction.setEnabled(true);
        JLabel hlabel = ComponentFactory.createLabel((String)root.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        this.headerComponent = new HeaderComponent("CLASS BROWSER", "For Project", (JComponent)hlabel);
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.headerComponent);
        this.add("Center", (Component)this.lc);
    }

    private SelectableTree createTree(Cls root) {
        SelectableTree tree = this.createSelectableTree(this.viewAction, new ExistentialTreeRoot(root, this.superclassesSlot, this.existentialProperty));
        tree.setSelectionRow(0);
        tree.setAutoscrolls(true);
        this.setSelectable((Selectable)tree);
        tree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                ExistentialTreePanel.this.updateActions();
            }
        });
        tree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)tree){

            public JPopupMenu getPopupMenu() {
                return ExistentialTreePanel.this.getPopupMenu();
            }
        });
        return tree;
    }

    public Hierarchy createClone() {
        return new ExistentialTreePanel(this.root, this.superclassesSlot, this.existentialProperty);
    }

    private Action createCollapseAllAction() {
        return new AbstractAction("Collapse", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionCollapse((JTree)ExistentialTreePanel.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new AbstractAction("Expand", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionExpand((JTree)ExistentialTreePanel.this.getTree(), (int)100);
            }
        };
    }

    protected JPopupMenu createPopupMenu(Cls cls) {
        JPopupMenu menu = new JPopupMenu();
        if (cls.isVisible()) {
            Action action = this.getHideClsAction();
            if (cls.equals(this.owlModel.getOWLThingClass())) {
                action.setEnabled(false);
            }
            menu.add(action);
        } else {
            menu.add(this.getUnhideClsAction());
        }
        menu.addSeparator();
        menu.add(this.createExpandAllAction());
        menu.add(this.createCollapseAllAction());
        if (cls instanceof RDFResource) {
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), (RDFResource)cls);
        }
        return menu;
    }

    protected SelectableTree createSelectableTree(Action viewAction, LazyTreeRoot root) {
        SelectableTree tree = new SelectableTree(viewAction, root);
        tree.setCellRenderer((TreeCellRenderer)FrameRenderer.createInstance());
        return tree;
    }

    protected Action createViewClsAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object o) {
                ExistentialTreePanel.this.owlModel.getProject().show((Instance)((Cls)o));
            }
        };
    }

    public void expandRoot() {
        this.setExpandedCls(this.owlModel.getOWLThingClass(), true);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JTree getClsesTree() {
        return this.getTree();
    }

    public Cls getDisplayParent() {
        TreePath path = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        return o instanceof Cls ? (Cls)o : null;
    }

    protected OWLObjectProperty getExistentialProperty() {
        return this.existentialProperty;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    private Action getHideClsAction() {
        return new AbstractAction("Hide class", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : ExistentialTreePanel.this.getSelection()) {
                    cls.setVisible(false);
                }
            }
        };
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)selection);
            menu = this.createPopupMenu(cls);
        }
        return menu;
    }

    public RDFSClass getSelectedClass() {
        return this.getSelectedOWLClass();
    }

    public OWLClass getSelectedOWLClass() {
        JTree tree = this.getTree();
        if (tree.getSelectionCount() == 1) {
            TreePath path = tree.getSelectionPath();
            ExistentialTreeNode node = (ExistentialTreeNode)((Object)path.getLastPathComponent());
            return node.getOWLClass();
        }
        return null;
    }

    protected ExistentialTreeNode getSelectedNode() {
        JTree tree = this.getTree();
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            return (ExistentialTreeNode)((Object)path.getLastPathComponent());
        }
        return null;
    }

    public OWLClass getSelectedParentClass() {
        TreePath path;
        int count;
        JTree tree = this.getTree();
        if (tree.getSelectionCount() == 1 && (count = (path = tree.getSelectionPath()).getPathCount()) > 2) {
            ExistentialTreeNode node = (ExistentialTreeNode)((Object)path.getPathComponent(count - 2));
            return node.getOWLClass();
        }
        return null;
    }

    public String getTitle() {
        return StringUtilities.capitalize((String)this.existentialProperty.getBrowserText());
    }

    public String getType() {
        return "Existential Relationship";
    }

    protected JTree getTree() {
        return (JTree)this.getSelectable();
    }

    private Action getUnhideClsAction() {
        return new AbstractAction("Make class visible", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : ExistentialTreePanel.this.getSelection()) {
                    cls.setVisible(true);
                }
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource resource) {
        if (resource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)resource);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(Cls cls) {
        SelectableTree tree = this.createTree(cls);
        Component oldTree = this.mainPanel.getComponent(0);
        this.mainPanel.removeAll();
        ComponentUtilities.dispose((Component)oldTree);
        this.mainPanel.add("Center", new JScrollPane((Component)tree));
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        List path = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)path, (boolean)expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.add(c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)renderer);
    }

    public void setSelectedClass(RDFSClass cls) {
        this.setDisplayParent(cls);
    }

    public String toString() {
        return "SubsumptionTreePanel";
    }

    protected void updateActions() {
    }

    public static interface SuperClsesPanel {
        public void setCls(OWLNamedClass var1);
    }
}

