/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer.filter;

import edu.stanford.smi.protege.ui.SlotSubslotNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.explorer.filter.DefaultExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertySubpropertyRoot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ValidPropertyPanel
extends JPanel {
    private DefaultExplorerFilter filter;
    private JTree tree;

    public ValidPropertyPanel(OWLModel owlModel, DefaultExplorerFilter filter) {
        this.filter = filter;
        this.tree = new SelectableTree(null, (LazyTreeRoot)new OWLPropertySubpropertyRoot(owlModel));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ValidPropertyPanel.this.updateFilter();
            }
        });
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer()));
        OWLLabeledComponent lc = new OWLLabeledComponent("Show only Restrictions on Property", new JScrollPane(this.tree));
        lc.addHeaderButton(new AbstractAction("Clear selection", OWLIcons.getDeleteIcon()){

            public void actionPerformed(ActionEvent e) {
                ValidPropertyPanel.this.tree.clearSelection();
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.setPreferredSize(new Dimension(260, 260));
    }

    private void updateFilter() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.filter.setValidProperty(null);
        } else {
            SlotSubslotNode node = (SlotSubslotNode)path.getLastPathComponent();
            RDFProperty property = (RDFProperty)node.getUserObject();
            this.filter.setValidProperty(property);
        }
    }
}

