/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ExistentialMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.SubclassesMatrixFilter;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class ExistentialMatrixAction
extends ResourceAction {
    public ExistentialMatrixAction() {
        super("Show existential matrix of subclasses...", Icons.getBlankIcon(), "Search and View/");
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.getOWLModel();
        RDFSNamedClass parentClass = (RDFSNamedClass)this.getResource();
        final Collection slots = this.selectProperties(parentClass);
        if (!slots.isEmpty()) {
            SubclassesMatrixFilter filter = new SubclassesMatrixFilter(parentClass);
            MatrixTableModel tableModel = new MatrixTableModel(owlModel, filter){

                protected void addDefaultColumns() {
                    super.addDefaultColumns();
                    for (RDFProperty property : slots) {
                        this.addColumn(new ExistentialMatrixColumn(property));
                    }
                }
            };
            ClassMatrixPanel panel = new ClassMatrixPanel(owlModel, filter, tableModel);
            ResultsPanelManager.addResultsPanel(owlModel, panel, true);
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return resource instanceof RDFSNamedClass;
    }

    private Collection selectProperties(RDFSNamedClass parentClass) {
        Collection properties = ClassMatrixPanel.getPotentialProperties(parentClass);
        OWLModel owlModel = parentClass.getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this.getComponent(), owlModel, properties, "Select properties to show");
    }
}

