/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DatatypeSettingsPanel
extends JPanel {
    private boolean changed = false;
    private OWLModel owlModel;

    public DatatypeSettingsPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        JPanel visPanel = new JPanel();
        visPanel.setLayout(new BoxLayout(visPanel, 1));
        visPanel.setBorder(BorderFactory.createTitledBorder("Visibility"));
        ArrayList<RDFSDatatype> datatypes = new ArrayList<RDFSDatatype>();
        for (RDFSDatatype datatype : owlModel.getRDFSDatatypes()) {
            if (!datatype.isSystem()) continue;
            datatypes.add(datatype);
        }
        Box defaultTypesBox = this.createBox("Default Types", datatypes, new RDFSDatatype[]{owlModel.getXSDboolean(), owlModel.getXSDfloat(), owlModel.getXSDint(), owlModel.getXSDstring()});
        Box dateTypesBox = this.createBox("Date/Time Types", datatypes, new RDFSDatatype[]{owlModel.getXSDdate(), owlModel.getXSDdateTime(), owlModel.getXSDduration(), owlModel.getXSDtime()});
        Box extendedTypesBox = this.createBox("Uncommon Numeric Types", datatypes, new RDFSDatatype[]{owlModel.getXSDbyte(), owlModel.getXSDdecimal(), owlModel.getXSDdouble(), owlModel.getRDFSDatatypeByURI(XSD.integer.getURI()), owlModel.getXSDlong(), owlModel.getRDFSDatatypeByURI(XSD.negativeInteger.getURI()), owlModel.getRDFSDatatypeByURI(XSD.nonNegativeInteger.getURI()), owlModel.getRDFSDatatypeByURI(XSD.nonPositiveInteger.getURI()), owlModel.getRDFSDatatypeByURI(XSD.positiveInteger.getURI()), owlModel.getRDFSDatatypeByURI(XSD.unsignedByte.getURI()), owlModel.getRDFSDatatypeByURI(XSD.unsignedInt.getURI()), owlModel.getRDFSDatatypeByURI(XSD.unsignedLong.getURI()), owlModel.getRDFSDatatypeByURI(XSD.unsignedShort.getURI()), owlModel.getXSDshort()});
        Collections.sort(datatypes, new ResourceComparator());
        Box restBox = this.createBox("Other Types", datatypes, datatypes.toArray(new RDFSDatatype[0]));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add("North", defaultTypesBox);
        leftPanel.add("Center", dateTypesBox);
        leftPanel.add("South", extendedTypesBox);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add("Center", restBox);
        visPanel.setLayout(new GridLayout(1, 2, 8, 8));
        visPanel.add(leftPanel);
        visPanel.add(rightPanel);
        this.setLayout(new BorderLayout());
        this.add("North", visPanel);
    }

    private Box createBox(String title, List datatypes, RDFSDatatype[] types) {
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createTitledBorder(title));
        int i = 0;
        while (i < types.length) {
            RDFSDatatype datatype = types[i];
            datatypes.remove(datatype);
            box.add(new DatatypeCheckBox(datatype));
            ++i;
        }
        return box;
    }

    public boolean getRequiresReloadUI() {
        return false;
    }

    private class DatatypeCheckBox
    extends JCheckBox {
        private RDFSDatatype datatype;

        DatatypeCheckBox(RDFSDatatype datatype) {
            super(datatype.getName());
            this.datatype = datatype;
            this.setSelected(datatype.isVisible());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DatatypeCheckBox.this.handleChanged();
                }
            });
        }

        private void handleChanged() {
            this.datatype.setVisible(this.isSelected());
            DatatypeSettingsPanel.this.changed = true;
        }
    }
}

