/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreePanel;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class OWLMetadataTab
extends AbstractTabWidget
implements HostResourceDisplay {
    private ResourcePanel resourceDisplay;
    private ImportsTreePanel importsTreePanel;
    private SelectionListener treeSelectionListener;

    private JComponent createMainPanel() {
        this.treeSelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Set sel = OWLMetadataTab.this.importsTreePanel.getImportsTree().getSelectedResources();
                RDFResource res = (RDFResource)CollectionUtilities.getFirstItem((Collection)sel);
                OWLMetadataTab.this.resourceDisplay.setResource(res);
            }
        };
        this.importsTreePanel = new ImportsTreePanel(this.getOWLModel().getDefaultOWLOntology());
        this.importsTreePanel.getImportsTree().addSelectionListener(this.treeSelectionListener);
        this.resourceDisplay = ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 3);
        OWLOntology activeOntology = OWLUtil.getActiveOntology(this.getOWLModel());
        if (activeOntology != null) {
            this.displayHostResource(activeOntology);
        }
        JSplitPane mainSplitter = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        mainSplitter.setLeftComponent(this.importsTreePanel);
        mainSplitter.setRightComponent((Component)((Object)this.resourceDisplay));
        mainSplitter.setDividerLocation(250);
        return mainSplitter;
    }

    public void dispose() {
        super.dispose();
        this.importsTreePanel.getImportsTree().removeSelectionListener(this.treeSelectionListener);
        this.resourceDisplay = null;
        this.importsTreePanel = null;
        this.treeSelectionListener = null;
    }

    public void initialize() {
        this.setIcon(OWLIcons.getImageIcon("Metadata"));
        JComponent comp = this.createMainPanel();
        this.add(comp);
    }

    public String getLabel() {
        String label = "Metadata";
        TripleStore ts = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        OWLOntology ont = (OWLOntology)TripleStoreUtil.getFirstOntology(this.getOWLModel(), ts);
        if (ont != null) {
            String file = ont.getURI();
            int index = file.lastIndexOf(47);
            if (index < 0) {
                index = file.lastIndexOf(92);
            }
            if (index >= 0) {
                file = file.substring(index + 1);
            }
            if (file.length() > 25) {
                int endIndex = file.length();
                file = String.valueOf(file.substring(0, 10)) + "..." + file.substring(endIndex - 10, endIndex);
            }
            label = String.valueOf(label) + " (" + file + ")";
        }
        return label;
    }

    public static boolean isSuitable(Project p, Collection errors) {
        return OWLClassesTab.isSuitable(p, errors);
    }

    public void setOntologyInstance(OWLOntology oi) {
        this.setOntology(oi);
    }

    public void setOntology(OWLOntology ontology) {
        this.displayHostResource(ontology);
    }

    public boolean displayHostResource(RDFResource resource) {
        return this.importsTreePanel.displayHostResource(resource);
    }
}

