/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metrics;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ModelMetrics;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metrics.MetricObject;
import edu.stanford.smi.protegex.owl.ui.metrics.MetricRenderer;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MetricsPanel
extends JPanel {
    private JTree tree;
    public static final Icon headerIcon = OWLIcons.getImageIcon("metricsheadericon.png");
    public static final Icon dataIcon = OWLIcons.getImageIcon("metricsdataicon.png");

    public MetricsPanel(OWLModel model) {
        ModelMetrics ModelMetrics2 = new ModelMetrics(model);
        ModelMetrics2.calculateMetrics();
        this.tree = new JTree(this.createRootNode(ModelMetrics2));
        this.tree.setCellRenderer(new MetricRenderer());
        this.setLayout(new BorderLayout(7, 7));
        this.add(new JScrollPane(this.tree));
        this.expandTree();
    }

    public void expandTree() {
        this.tree.setSelectionRow(0);
        ComponentUtilities.fullSelectionExpand((JTree)this.tree, (int)100);
    }

    private TreeNode createRootNode(ModelMetrics metrics) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Metrics");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Classes");
        rootNode.add(node);
        DefaultMutableTreeNode namedClsNode = new DefaultMutableTreeNode("Named classes");
        node.add(namedClsNode);
        namedClsNode.add(this.createMetricNode("Total", metrics.getNamedClassCount()));
        namedClsNode.add(this.createMetricNode("Primitive", metrics.getPrimitiveClassCount()));
        namedClsNode.add(this.createMetricNode("Defined", metrics.getDefinedClassCount()));
        DefaultMutableTreeNode parentsNode = new DefaultMutableTreeNode("Parents");
        namedClsNode.add(parentsNode);
        parentsNode.add(this.createMetricNode("Mean (named)", metrics.getMeanParents()));
        parentsNode.add(this.createMetricNode("Mode (named)", metrics.getModeParents()));
        parentsNode.add(this.createMetricNode("Max (named)", metrics.getMaxParents()));
        DefaultMutableTreeNode inferredParentsNode = new DefaultMutableTreeNode("Inferred parents");
        namedClsNode.add(inferredParentsNode);
        inferredParentsNode.add(this.createMetricNode("Mean (named)", metrics.getMeanInferredParents()));
        inferredParentsNode.add(this.createMetricNode("Mode (named)", metrics.getModeInferredParents()));
        inferredParentsNode.add(this.createMetricNode("Max (named)", metrics.getMaxInferredParents()));
        DefaultMutableTreeNode siblingsNode = new DefaultMutableTreeNode("Siblings");
        namedClsNode.add(siblingsNode);
        siblingsNode.add(this.createMetricNode("Mean", metrics.getMeanSiblings()));
        siblingsNode.add(this.createMetricNode("Mode", metrics.getModeSiblings()));
        siblingsNode.add(this.createMetricNode("Max", metrics.getMaxSiblings()));
        DefaultMutableTreeNode anonClsNode = new DefaultMutableTreeNode("Anonymous Classes");
        node.add(anonClsNode);
        DefaultMutableTreeNode restrictionNode = new DefaultMutableTreeNode("Restrictions");
        anonClsNode.add(restrictionNode);
        restrictionNode.add(this.createMetricNode("Total", metrics.getRestrictionCount()));
        restrictionNode.add(this.createMetricNode("Existential", metrics.getSomeValuesFromCount()));
        restrictionNode.add(this.createMetricNode("Universal", metrics.getAllValuesFromCount()));
        restrictionNode.add(this.createMetricNode("Cardinality", metrics.getCardinalityCount()));
        restrictionNode.add(this.createMetricNode("MinCardinality", metrics.getMinCardinalityCount()));
        restrictionNode.add(this.createMetricNode("MaxCardinality", metrics.getMaxCardinalityCount()));
        restrictionNode.add(this.createMetricNode("HasValue", metrics.getHasValueCount()));
        DefaultMutableTreeNode propertiesNode = new DefaultMutableTreeNode("Properties");
        rootNode.add(propertiesNode);
        propertiesNode.add(this.createMetricNode("Total", metrics.getObjectPropertyCount()));
        propertiesNode.add(this.createMetricNode("Object", metrics.getObjectPropertyCount()));
        propertiesNode.add(this.createMetricNode("Datatype", metrics.getDatatypePropertyCount()));
        propertiesNode.add(this.createMetricNode("Annotation", metrics.getAnnotationPropertyCount()));
        propertiesNode.add(this.createMetricNode("Properties with a domain specified", metrics.getPropertDomainCount()));
        propertiesNode.add(this.createMetricNode("Properties with a range specified", metrics.getPropertyRangeCount()));
        propertiesNode.add(this.createMetricNode("Properties with an inverse specified", metrics.getInversePropertyCount()));
        return rootNode;
    }

    private DefaultMutableTreeNode createMetricNode(String name, Object value) {
        return new DefaultMutableTreeNode(new MetricObject(name, value));
    }

    private DefaultMutableTreeNode createMetricNode(String name, int value) {
        return this.createMetricNode(name, new Integer(value));
    }

    public Dimension getPreferredSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(400, screenSize.height / 2);
    }
}

