/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metrics.lang;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.DLExpressivityChecker;
import edu.stanford.smi.protegex.owl.ui.metrics.lang.DLExpressivityTableModel;
import edu.stanford.smi.protegex.owl.ui.metrics.lang.DLNamePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class DLExpressivityPanel
extends JPanel {
    private OWLModel owlModel;

    public DLExpressivityPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(12, 12));
        DLExpressivityChecker checker = new DLExpressivityChecker(this.owlModel);
        checker.check();
        JPanel holder = new JPanel(new BorderLayout(7, 7));
        holder.add((Component)new JLabel("The DL expressivity of this ontology is:"), "North");
        ArrayList list = new ArrayList(checker.getDL());
        DLNamePanel DLNamePanel2 = new DLNamePanel(list);
        DLNamePanel2.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        holder.add((Component)DLNamePanel2, "South");
        this.add((Component)holder, "North");
        JTable table = new JTable(new DLExpressivityTableModel(list));
        table.setRowHeight(55);
        table.setAutoResizeMode(4);
        table.getColumnModel().getColumn(0).setPreferredWidth(60);
        table.getColumnModel().getColumn(1).setPreferredWidth(600);
        table.getColumnModel().getColumn(1).setCellRenderer(new ExplanationRenderer());
        table.setShowGrid(true);
        table.setGridColor(Color.LIGHT_GRAY);
        this.add(new JScrollPane(table));
    }

    private class ExplanationRenderer
    implements TableCellRenderer {
        private JTextArea textArea = new JTextArea();

        public ExplanationRenderer() {
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.textArea.setText(value != null ? value.toString() : "");
            return this.textArea;
        }
    }
}

