/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;

public class EditProfilePanel
extends JPanel {
    private static JFileChooser fileChooser;
    private JTextField fileTextField;
    private OWLModel owlModel;
    private OntModel ontModel;
    private FeatureTreeNode rootNode;
    private JTree tree;
    private static final int NODE_UNSELECTED = 0;
    private static final int NODE_SELECTED = 1;
    private static final int NODE_SOME_SELECTED = 2;

    public EditProfilePanel(OWLModel owlModel, OntModel ontModel, String fileName, Collection selectedClasses) {
        this.owlModel = owlModel;
        this.ontModel = ontModel;
        this.rootNode = this.createRootNode(selectedClasses);
        this.tree = new JTree(this.rootNode);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                EditProfilePanel.this.handleMousePressed(e);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        OWLLabeledComponent lc = new OWLLabeledComponent("Allowable Features (Note: Work in progress!)", scrollPane);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.fileTextField = new JTextField(fileName);
        LabeledComponent fileNamePanel = new LabeledComponent("Save profile to file:", (Component)this.fileTextField);
        AbstractAction selectFileAction = new AbstractAction("Select output file", OWLIcons.getAddIcon("File")){

            public void actionPerformed(ActionEvent e) {
                EditProfilePanel.this.selectFile();
            }
        };
        fileNamePanel.addHeaderButton((Action)selectFileAction);
        this.add("South", (Component)fileNamePanel);
    }

    private FeatureTreeNode createNode(OntClass currentClass, Collection selectedClasses) {
        FeatureTreeNode node = new FeatureTreeNode(currentClass, selectedClasses);
        ArrayList<FeatureTreeNode> nodes = new ArrayList<FeatureTreeNode>();
        Iterator it = ProfilesManager.getSubclasses(this.ontModel, currentClass);
        while (it.hasNext()) {
            OntClass subClass = (OntClass)it.next();
            if (subClass.getLabel(null) == null) continue;
            FeatureTreeNode childNode = this.createNode(subClass, selectedClasses);
            nodes.add(childNode);
        }
        Collections.sort(nodes);
        for (FeatureTreeNode childNode : nodes) {
            node.add(childNode);
        }
        return node;
    }

    private OntModel createOntModel() {
        String namespace = "http://www.owl-ontologies.com/MyProfile.owl#";
        OntModel ontModel = ProfilesManager.createProfile(namespace);
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        ontModel.getDocumentManager().loadImport(ontModel, "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#");
        OntClass ontClass = ontModel.createClass(String.valueOf(namespace) + "MyProfile");
        this.rootNode.addSubclasses(ontModel, ontClass);
        return ontModel;
    }

    private FeatureTreeNode createRootNode(Collection selectedClasses) {
        OntClass rootClass = this.ontModel.getOntClass(OWLProfiles.RDF.getURI());
        Assert.assertNotNull((Object)rootClass);
        FeatureTreeNode root = this.createNode(rootClass, selectedClasses);
        root.updateSelection();
        return root;
    }

    private static Collection getSelectedClasses(OntModel ontModel) {
        OntClass ontClass = ProfilesManager.getCustomProfileFeaturesClass(ontModel);
        if (ontClass != null) {
            return ProfilesManager.getSelectedClasses(ontModel, ontClass);
        }
        return null;
    }

    private void handleMousePressed(MouseEvent e) {
        Rectangle r;
        int row = this.tree.getRowForLocation(e.getX(), e.getY());
        if (row >= 0 && row < this.tree.getRowCount() && (r = this.tree.getRowBounds(row)).contains(e.getX(), e.getY()) && e.getX() - r.x < 12) {
            TreePath path = this.tree.getPathForRow(row);
            FeatureTreeNode node = (FeatureTreeNode)path.getLastPathComponent();
            node.toggle();
            this.rootNode.updateSelection();
            this.tree.repaint();
        }
    }

    public void handleOK() {
        String fileName = this.fileTextField.getText();
        try {
            OntModel newOntModel = this.createOntModel();
            ProfilesManager.saveOntModel(newOntModel, fileName);
            ProfilesManager.clearCache(fileName);
            ProfilesManager.setProfile(this.owlModel, fileName);
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this, "Could not write to " + fileName + ":\n" + ex.toString(), "Error");
        }
    }

    private void selectFile() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            this.fileTextField.setText(file.getAbsolutePath());
        }
    }

    public static boolean showProfilePanelDialog(OWLModel owlModel) {
        try {
            OntModel ontModel = ProfilesManager.getProfileOntModel(owlModel);
            if (ontModel != null) {
                return EditProfilePanel.showProfilePanelDialog(owlModel, ontModel);
            }
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not find profile class:\n" + ProfilesManager.getProfile(owlModel), "Invalid Profile");
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not open profile:\n" + ex, "Error");
        }
        return false;
    }

    public static boolean showProfilePanelDialog(OWLModel owlModel, OntModel ontModel) {
        String fileName = null;
        String customProfileURI = ProfilesManager.getCustomProfileURI(owlModel);
        if (customProfileURI == null) {
            fileName = "MyProfile.owl";
        } else if (customProfileURI.startsWith("http://")) {
            int index = customProfileURI.lastIndexOf(47);
            fileName = customProfileURI.substring(index + 1);
        } else {
            fileName = customProfileURI;
        }
        return EditProfilePanel.showProfilePanelDialog(owlModel, ontModel, fileName);
    }

    public static boolean showProfilePanelDialog(OWLModel owlModel, OntModel ontModel, String fileName) {
        Collection selectedClasses = EditProfilePanel.getSelectedClasses(ontModel);
        EditProfilePanel panel = new EditProfilePanel(owlModel, ontModel, fileName, selectedClasses);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(owlModel.getProject()), panel, "Language Profile (" + fileName + ")", 11) == 1) {
            panel.handleOK();
            return true;
        }
        return false;
    }

    private class FeatureTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private int selection = 0;

        FeatureTreeNode(OntClass ontClass, Collection selectedClasses) {
            this.setUserObject(ontClass);
            if (selectedClasses.contains(ontClass)) {
                this.selection = 1;
            }
        }

        public void addSubclasses(OntModel targetModel, OntClass ontClass) {
            if (this.selection == 1) {
                OntClass c = (OntClass)this.getUserObject();
                OntClass targetClass = targetModel.getOntClass(c.getURI());
                targetClass.addSuperClass((Resource)ontClass);
            } else if (this.selection == 2) {
                Enumeration<TreeNode> enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    FeatureTreeNode childNode = (FeatureTreeNode)enumeration.nextElement();
                    childNode.addSubclasses(targetModel, ontClass);
                }
            }
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public Icon getIcon() {
            if (this.selection == 0) {
                return OWLIcons.getImageIcon("CheckBoxUnselected");
            }
            if (this.selection == 1) {
                return OWLIcons.getImageIcon("CheckBoxSelected");
            }
            if (this.selection == 2) {
                return OWLIcons.getImageIcon("CheckBoxSelectedGrayed");
            }
            return null;
        }

        public void toggle() {
            this.selection = this.selection == 2 || this.selection == 0 ? 1 : 0;
            this.transmitSelectionIntoChildren();
        }

        public String toString() {
            OntClass ontClass = (OntClass)this.getUserObject();
            return ontClass.getLabel(null);
        }

        public void transmitSelectionIntoChildren() {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                FeatureTreeNode childNode = (FeatureTreeNode)enumeration.nextElement();
                childNode.selection = this.selection;
                childNode.transmitSelectionIntoChildren();
            }
        }

        public void updateSelection() {
            Enumeration<TreeNode> enumeration = this.children();
            boolean equal = true;
            int firstValue = -1;
            while (enumeration.hasMoreElements()) {
                FeatureTreeNode childNode = (FeatureTreeNode)enumeration.nextElement();
                childNode.updateSelection();
                if (firstValue < 0) {
                    firstValue = childNode.selection;
                    continue;
                }
                if (childNode.selection == firstValue) continue;
                equal = false;
            }
            if (this.getChildCount() > 0) {
                this.selection = equal ? firstValue : 2;
            }
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            FeatureTreeNode node = (FeatureTreeNode)value;
            this.setIcon(node.getIcon());
            return this;
        }
    }
}

