/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

class UnionRangeClassesTableModel
extends AbstractTableModel
implements OWLTableModel {
    private PropertyWidget propertyWidget;
    private List rows = new ArrayList();

    UnionRangeClassesTableModel(PropertyWidget propertyWidget) {
        this.propertyWidget = propertyWidget;
    }

    public boolean addRow(RDFSClass aClass, int rowIndex) {
        RDFProperty property = this.getEditedProperty();
        OWLModel owlModel = property.getOWLModel();
        ArrayList<RDFSClass> newClses = new ArrayList<RDFSClass>();
        if (!(property instanceof OWLProperty) && !ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Union_Classes)) {
            newClses.add(aClass);
        } else {
            Collection clses = property.getUnionRangeClasses();
            for (RDFSClass oldClass : clses) {
                newClses.add(oldClass.createClone());
            }
            if (property.getSuperpropertyCount() > 0 && !property.isRangeDefined()) {
                this.removeSuperclasses(newClses, aClass);
            }
            if (!newClses.contains(aClass)) {
                newClses.add(aClass);
            }
        }
        try {
            try {
                aClass.getOWLModel().beginTransaction("Add " + aClass.getBrowserText() + " to range of " + property.getBrowserText());
                property.setUnionRangeClasses(newClses);
                property.synchronizeDomainAndRangeOfInverse();
            }
            catch (Exception ex) {
                OWLUI.handleError(aClass.getOWLModel(), ex);
            }
        }
        finally {
            aClass.getOWLModel().endTransaction();
        }
        return true;
    }

    public int addEmptyRow(int rowIndex) {
        int index = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(index, index);
        return index;
    }

    void clearRows() {
        int count = this.getRowCount();
        this.rows.clear();
        if (count > 0) {
            this.fireTableRowsDeleted(0, count - 1);
        }
    }

    public void deleteRow(int index) {
        RDFProperty property = this.getEditedProperty();
        RDFSClass cls = this.getClass(index);
        Collection clses = property.getUnionRangeClasses();
        ArrayList<RDFSClass> newClses = new ArrayList<RDFSClass>();
        for (RDFSClass oldClass : clses) {
            if (cls.equals(oldClass)) continue;
            newClses.add(oldClass.createClone());
        }
        try {
            property.getOWLModel().beginTransaction("Remove " + cls.getBrowserText() + " from range of " + cls.getBrowserText());
            if (newClses.isEmpty() && property.getSuperpropertyCount() > 0) {
                property.setRange(null);
                property.synchronizeDomainAndRangeOfInverse();
                property.getOWLModel().endTransaction();
                this.fireTableDataChanged();
            } else {
                property.setUnionRangeClasses(newClses);
                property.synchronizeDomainAndRangeOfInverse();
                property.getOWLModel().endTransaction();
                this.fireTableRowsDeleted(index, index);
            }
        }
        catch (Exception ex) {
            OWLUI.handleError(property.getOWLModel(), ex);
        }
    }

    public void displaySemanticError(String message) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.propertyWidget.getOWLModel(), message);
    }

    public void dispose() {
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int column) {
        return "Expression";
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public RDFSClass getClass(int rowIndex) {
        return (RDFSClass)this.rows.get(rowIndex);
    }

    public int getClassRow(RDFSClass cls) {
        return this.rows.indexOf(cls);
    }

    public OWLNamedClass getEditedCls() {
        return null;
    }

    RDFProperty getEditedProperty() {
        return (RDFProperty)this.propertyWidget.getEditedResource();
    }

    public Icon getIcon(RDFResource resource) {
        return ProtegeUI.getIcon(resource);
    }

    public RDFProperty getPredicate(int row) {
        return this.getEditedProperty().getOWLModel().getRDFSRangeProperty();
    }

    public RDFResource getRDFResource(int row) {
        return this.getClass(row);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public RDFResource getSubject() {
        return this.getEditedProperty();
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rows.get(rowIndex) == null) {
            return "";
        }
        RDFSClass cls = this.getClass(rowIndex);
        return cls.getBrowserText();
    }

    Collection getValues() {
        RDFProperty property = this.getEditedProperty();
        return property.getUnionRangeClasses();
    }

    private void insertRow(RDFSClass cls) {
        int index = this.rows.size();
        this.rows.add(index, cls);
        this.fireTableRowsInserted(index, index);
    }

    public boolean isAddEnabledAt(int rowIndex) {
        return this.isEditable();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public boolean isDeleteEnabledFor(RDFSClass cls) {
        return !this.isInherited(cls);
    }

    public boolean isEditable() {
        return this.getEditedProperty().isEditable();
    }

    boolean isInherited(RDFSClass cls) {
        RDFProperty property = this.getEditedProperty();
        Collection values = property.getUnionRangeClasses();
        return property.getRange() == null || !values.contains(cls);
    }

    void refill() {
        this.clearRows();
        Collection values = this.getValues();
        for (RDFSClass cls : values) {
            this.insertRow(cls);
        }
    }

    public void removeEmptyRow() {
        int rowIndex = this.rows.indexOf(null);
        if (rowIndex >= 0) {
            this.rows.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    private void removeSuperclasses(Collection clses, RDFSClass aClass) {
        Iterator it = clses.iterator();
        while (it.hasNext()) {
            RDFSClass rdfsClass = (RDFSClass)it.next();
            if (!aClass.isSubclassOf(rdfsClass)) continue;
            it.remove();
        }
    }

    public void setCls(OWLNamedClass cls) {
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        String text = (String)value;
        if (text.trim().length() == 0) {
            this.removeEmptyRow();
            return;
        }
        try {
            OWLModel owlModel = this.propertyWidget.getOWLModel();
            OWLClassParser parser = owlModel.getOWLClassParser();
            RDFSClass newClass = parser.parseClass(owlModel, text);
            RDFSClass oldClass = this.getClass(rowIndex);
            RDFProperty property = this.getEditedProperty();
            if (oldClass == null || !value.equals(oldClass)) {
                if (newClass instanceof OWLUnionClass) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Please do not assign unions as range.  The range in Protege has union\nsemantics, i.e. if you assign A or B, then this is equivalent to adding\nA and B separately in two rows.  Please convert your union into single rows.");
                    newClass.delete();
                } else {
                    Collection clses = property.getUnionRangeClasses();
                    if (clses.contains(newClass)) {
                        this.displaySemanticError("The class " + newClass.getBrowserText() + " is already in the union range of " + property.getBrowserText() + ".");
                    } else {
                        ArrayList<RDFSClass> newClses = new ArrayList<RDFSClass>();
                        for (RDFSClass old : clses) {
                            if (old.equals(oldClass)) {
                                newClses.add(newClass);
                                continue;
                            }
                            newClses.add(old.createClone());
                        }
                        if (oldClass == null) {
                            newClses.add(newClass);
                        }
                        property.setUnionRangeClasses(newClses);
                    }
                }
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
    }
}

