/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.refactoring;

import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.refactoring.RefactorResourceAction;
import edu.stanford.smi.protegex.owl.ui.refactoring.RenameAcrossFilesPanel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class RenameAcrossFilesAction
extends RefactorResourceAction {
    private static final String PROPERTY = "RenameAcrossFiles";

    public RenameAcrossFilesAction() {
        super("Rename across files...", OWLIcons.getImageIcon(PROPERTY));
    }

    public void actionPerformed(ActionEvent e) {
        RDFResource resource = this.getResource();
        String oldPropertyValue = resource.getOWLModel().getOWLProject().getSettingsMap().getString(PROPERTY);
        String[] files = new String[]{};
        if (oldPropertyValue != null) {
            files = oldPropertyValue.split(",");
        }
        RenameAcrossFilesPanel panel = new RenameAcrossFilesPanel(resource, files);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(resource.getProject()), panel, "Rename " + resource.getName() + " across files...", 11) == 1) {
            Iterator it = panel.getSelectedFiles();
            String newPropertyValue = "";
            while (it.hasNext()) {
                File file = (File)it.next();
                String f = file.getAbsolutePath();
                newPropertyValue = String.valueOf(newPropertyValue) + f;
                if (!it.hasNext()) continue;
                newPropertyValue = String.valueOf(newPropertyValue) + ",";
            }
            resource.getOWLModel().getOWLProject().getSettingsMap().setString(PROPERTY, newPropertyValue);
            String newName = panel.getNewName();
            if (!newName.equals(resource.getName())) {
                OWLModel owlModel = resource.getOWLModel();
                if (owlModel.isValidResourceName(newName, resource)) {
                    RenameAcrossFilesAction.performAction(resource, newName, panel.getSelectedFiles());
                } else {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "This is not a valid name.");
                }
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        if (resource instanceof RDFResource) {
            return !resource.isSystem() && !resource.isAnonymous();
        }
        return false;
    }

    public static void performAction(RDFResource resource, String newName, Iterator files) {
        OWLModel owlModel = resource.getOWLModel();
        String oldURI = resource.getURI();
        resource.setName(newName);
        String newURI = resource.getURI();
        ModalProgressBarManager man = new ModalProgressBarManager("Renaming across files...");
        man.setProgressValue(0.0);
        Set filesSet = Jena.set(files);
        int step = 0;
        man.start();
        HashSet okFiles = new HashSet();
        HashSet<File> errorFiles = new HashSet<File>();
        for (File file : filesSet) {
            man.setProgressText(file.getAbsolutePath());
            man.setProgressValue((double)step / (double)filesSet.size());
            System.out.println("[RenameAcrossFilesAction] " + file);
            try {
                RenameAcrossFilesAction.performAction(resource.getProject(), file, oldURI, newURI, okFiles);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                errorFiles.add(file);
            }
            ++step;
        }
        man.stop();
        String msg = "";
        if (okFiles.isEmpty()) {
            msg = String.valueOf(msg) + "No files were changed.\n";
        } else {
            msg = String.valueOf(msg) + "The following files were changed:\n";
            for (File file : okFiles) {
                msg = String.valueOf(msg) + " - " + file.getAbsolutePath() + "\n";
            }
        }
        if (!errorFiles.isEmpty()) {
            msg = String.valueOf(msg) + "The following files had an error:\n";
            for (File file : errorFiles) {
                msg = String.valueOf(msg) + " - " + file.getAbsolutePath() + "\n";
            }
        }
        ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "The resource " + oldURI + "\nwas renamed to " + newURI + "\n" + msg);
    }

    public static void performAction(Project project, File file, String oldURI, String newURI, Collection okFiles) throws IOException {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntDocumentManager dm = new OntDocumentManager();
        SimpleGraphMaker sgm = (SimpleGraphMaker)((ModelMakerImpl)spec.getModelMaker()).getGraphMaker();
        Set toGo = Jena.set((Iterator)sgm.listGraphs());
        Iterator i = toGo.iterator();
        while (i.hasNext()) {
            sgm.removeGraph((String)i.next());
        }
        dm.clearCache();
        String path = String.valueOf(new File(Jena.getOntPolicyFilePath(project)).toURI().toString()) + ";" + new File(new File("etc"), "ont-policy.rdf").toURI().toString();
        dm.setMetadataSearchPath(path, true);
        spec.setDocumentManager(dm);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ontModel.read((InputStream)new FileInputStream(file), "http://www.owl-ontologies.com/unnamed.owl#", "RDF/XML-ABBREV");
        Resource oldResource = ontModel.getResource(oldURI);
        if (ontModel.contains(oldResource, null, null) || ontModel.contains(null, null, (RDFNode)oldResource) || oldResource.canAs(Property.class) && ontModel.contains(null, (Property)oldResource.as(Property.class), null)) {
            System.out.println("[RenameAcrossFilesAction]   References found, now renaming...");
            Jena.renameResource(ontModel, oldResource, newURI);
            JenaOWLModel.save(file, ontModel, "RDF/XML-ABBREV", ontModel.getNsPrefixURI(""));
            okFiles.add(file);
        }
    }
}

