/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileBrowserPanel
extends JPanel {
    private Action browseAction;
    private JTextField fileNameField;
    private boolean showOnlyFolders;
    private WizardPage wizardPage;
    private JCheckBox forceReadOnlyCheckBox;
    private JCheckBox recursiveCheckBox;

    public FileBrowserPanel(WizardPage wizardPage, String label, boolean showOnlyFolders, String helpText) {
        this.wizardPage = wizardPage;
        this.showOnlyFolders = showOnlyFolders;
        this.fileNameField = new JTextField();
        LabeledComponent lc = new LabeledComponent(label, (Component)this.fileNameField);
        this.browseAction = new AbstractAction("Browse...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent e) {
                FileBrowserPanel.this.browse();
            }
        };
        wizardPage.setPageComplete(false);
        lc.addHeaderButton(this.browseAction);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JPanel holder = new JPanel(new BorderLayout(7, 7));
        holder.add((Component)lc, "North");
        JPanel checkBoxHolder = new JPanel(new BorderLayout(3, 3));
        holder.add((Component)checkBoxHolder, "South");
        this.forceReadOnlyCheckBox = new JCheckBox("Force Read-Only", true);
        checkBoxHolder.add((Component)this.forceReadOnlyCheckBox, "North");
        this.recursiveCheckBox = new JCheckBox("Include sub-folders");
        if (showOnlyFolders) {
            checkBoxHolder.add((Component)this.recursiveCheckBox, "South");
        }
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)holder, "North");
        if (helpText != null) {
            this.add((Component)OWLUI.createHelpPanel(helpText, null, 160), "South");
        }
        this.fileNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FileBrowserPanel.this.validateFileName();
            }

            public void removeUpdate(DocumentEvent e) {
                FileBrowserPanel.this.validateFileName();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnlyCheckBox.isSelected();
    }

    public boolean isRecursive() {
        return this.recursiveCheckBox.isSelected();
    }

    public void browse() {
        JFileChooser chooser = new JFileChooser();
        if (this.showOnlyFolders) {
            chooser.setFileSelectionMode(1);
        }
        if (chooser.showOpenDialog(this) == 0) {
            this.fileNameField.setText(this.getPathName(chooser.getSelectedFile()));
        }
    }

    public String getPathName(File file) {
        return file.getPath();
    }

    public File getFile() {
        return new File(this.fileNameField.getText());
    }

    public boolean validateFileName() {
        File f = new File(this.fileNameField.getText());
        if (f.isDirectory() != this.showOnlyFolders) {
            this.wizardPage.setPageComplete(false);
            return false;
        }
        this.wizardPage.setPageComplete(true);
        return true;
    }
}

