/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceFilterListModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ResourceSelectionComboBox
extends JComboBox
implements KeyListener {
    private Color oldBackground;
    private Component host;
    private ResourceSelectionListener listener;
    private ResourceFilterListModel model;

    public ResourceSelectionComboBox(Collection resources, ResourceSelectionListener aListener) {
        this(null, resources, aListener);
    }

    public ResourceSelectionComboBox(Component aHost, Collection resources, ResourceSelectionListener aListener) {
        this(aHost, resources, aListener, (ListCellRenderer)new FrameRenderer());
    }

    public ResourceSelectionComboBox(Component aHost, Collection resources, ResourceSelectionListener aListener, ListCellRenderer renderer) {
        this.host = aHost;
        this.listener = aListener;
        this.setRenderer(renderer);
        this.setBackground(Color.white);
        this.model = new ResourceFilterListModel(resources);
        this.setModel(this.model);
        if (this.host != null) {
            this.oldBackground = this.host.getBackground();
            this.host.setBackground(this.oldBackground.darker());
            this.updateBounds();
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    ResourceSelectionComboBox.this.host.setBackground(ResourceSelectionComboBox.this.oldBackground);
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((long)e.getModifiers() & 0x10L) != 0L) {
                    ResourceSelectionComboBox.this.okay();
                }
            }
        });
    }

    public void keyPressed(KeyEvent e) {
        char ch;
        int code = e.getKeyCode();
        if (e.getKeyCode() == 8) {
            this.setPopupVisible(false);
            this.model.backspace();
            this.updateBounds();
            this.showPopup();
        } else if (e.getKeyCode() == 10) {
            this.okay();
        }
        if (code != 8 && code != 27 && OWLTextField.isIdChar(ch = e.getKeyChar())) {
            this.setPopupVisible(false);
            this.model.addChar(ch);
            this.updateBounds();
            this.showPopup();
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.getParent().remove(this);
        this.setVisible(false);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void okay() {
        RDFResource selected = (RDFResource)this.getSelectedItem();
        if (selected != null) {
            this.listener.resourceSelected(selected);
        }
        this.setPopupVisible(false);
    }

    public static void selectFrame(Collection resources, JComponent host, int x, ResourceSelectionListener listener) {
        ResourceSelectionComboBox.selectResource(resources, host, x, listener, (ListCellRenderer)new FrameRenderer());
    }

    public static void selectResource(Collection resources, JComponent host, int x, ResourceSelectionListener listener, ListCellRenderer renderer) {
        ResourceSelectionComboBox cb = new ResourceSelectionComboBox(host, resources, listener, renderer);
        host.removeAll();
        host.add(cb);
        cb.setLocation(x, host.getHeight());
        cb.addKeyListener(cb);
        cb.showPopup();
        cb.requestFocus();
    }

    private void updateBounds() {
        if (this.host != null) {
            int width = this.getPreferredSize().width + 20;
            this.setSize(width, 0);
            this.setLocation(0, this.host.getHeight());
        }
    }
}

