/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.TaskManager;
import edu.stanford.smi.protegex.owl.testing.OWLModelTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.testing.AbstractOWLModelTestAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class OWLTestAction
extends AbstractOWLModelTestAction {
    public String getIconFileName() {
        return "Test";
    }

    public String getName() {
        return "Run ontology tests...";
    }

    protected List run(OWLTest[] tests, Task task) {
        TaskManager taskManager = this.owlModel.getTaskManager();
        ArrayList results = new ArrayList();
        double count = tests.length * 4;
        int j = 0;
        int i = 0;
        while (i < tests.length && !task.isCancelled()) {
            try {
                OWLTest test = tests[i];
                String className = test.getClass().getName();
                int index = className.lastIndexOf(46);
                taskManager.setMessage(task, className.substring(index + 1));
                taskManager.setProgress(task, (int)((double)j++ / count * 100.0));
                if (test instanceof OWLModelTest) {
                    this.runOWLModelTest(results, (OWLModelTest)test);
                }
                taskManager.setProgress(task, (int)((double)j++ / count * 100.0));
                if (test instanceof RDFSClassTest) {
                    this.runOWLClsTest(results, (RDFSClassTest)test);
                }
                taskManager.setProgress(task, (int)((double)j++ / count * 100.0));
                if (test instanceof RDFPropertyTest) {
                    this.runOWLPropertyTest(results, (RDFPropertyTest)test);
                }
                taskManager.setProgress(task, (int)((double)j++ / count * 100.0));
                if (test instanceof RDFResourceTest) {
                    this.runOWLInstanceTest(results, (RDFResourceTest)test);
                }
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            ++i;
        }
        return results;
    }
}

