/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLDocumentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterFactory;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;

public class OWLModelWriter {
    private OWLModel model;
    private TripleStore tripleStore;
    private XMLWriter xmlWriter;

    public OWLModelWriter(OWLModel model, TripleStore tripleStore, Writer writer) {
        this.model = model;
        this.tripleStore = tripleStore;
        XMLWriterNamespaceManager nsm = Util.getNamespacePrefixes(model.getNamespaceManager(), model.getNamespaceManager().getDefaultNamespace());
        String ontologyName = Util.getOntologyName(model, tripleStore);
        this.xmlWriter = XMLWriterFactory.getInstance().createXMLWriter(writer, nsm, ontologyName);
    }

    public OWLModelWriter(OWLModel model, TripleStore tripleStore, XMLWriter xmlWriter) {
        this.model = model;
        this.tripleStore = tripleStore;
        this.xmlWriter = xmlWriter;
    }

    public XMLWriter getXmlWriter() {
        return this.xmlWriter;
    }

    public void write() throws IOException {
        RDFXMLDocumentWriter docWriter = new RDFXMLDocumentWriter(this.xmlWriter, Collections.singleton(this.getContentWriter(this.model, this.tripleStore)));
        docWriter.writeDocument();
    }

    protected RDFXMLContentWriter getContentWriter(OWLModel model, TripleStore tripleStore) {
        return new OWLModelContentWriter(model, tripleStore);
    }
}

