/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.syntax.sirpac;

import edu.stanford.db.xml.util.QName;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public class Element {
    String m_sNamespace = null;
    private String m_sName = null;
    private Hashtable m_attributes = new Hashtable();
    private Vector m_children = new Vector();
    private String m_sResource = null;
    private String m_sID = null;
    private String m_sBagID = null;
    private String m_sAbout = null;
    private String m_sAboutEach = null;
    private String m_sAboutEachPrefix = null;
    private Vector m_vTargets = new Vector();
    private boolean m_bDone = false;
    private String m_sPrefix = null;

    public Element(String string, String string2, AttributeList attributeList) {
        this.m_sNamespace = string;
        this.m_sName = string2;
        if (attributeList != null) {
            int n = attributeList.getLength();
            if (attributeList != null) {
                int n2 = 0;
                while (n2 < n) {
                    String string3 = attributeList.getName(n2);
                    String string4 = attributeList.getValue(n2);
                    this.m_attributes.put(new QName(string3), string4);
                    ++n2;
                }
            }
        }
    }

    public Element(String string, String string2, Attributes attributes) {
        this.m_sNamespace = string;
        this.m_sName = string2;
        if (attributes != null) {
            int n = attributes.getLength();
            if (attributes != null) {
                int n2 = 0;
                while (n2 < n) {
                    this.m_attributes.put(new QName(attributes.getURI(n2), attributes.getLocalName(n2)), attributes.getValue(n2));
                    ++n2;
                }
            }
        }
    }

    public Element(String string, AttributeList attributeList) {
        this(null, string, attributeList);
    }

    public String ID() {
        return this.m_sID;
    }

    public void ID(String string) {
        this.m_sID = string;
    }

    public void ID(String string, String string2) {
        this.m_sID = Element.makeAbsolute(string, string2);
    }

    public String about() {
        return this.m_sAbout;
    }

    public void about(String string) {
        this.m_sAbout = string;
    }

    public void about(String string, String string2) {
        this.m_sAbout = Element.makeAbsolute(string, string2);
    }

    public String aboutEach() {
        return this.m_sAboutEach;
    }

    public void aboutEach(String string) {
        this.m_sAboutEach = string;
    }

    public void aboutEach(String string, String string2) {
        this.m_sAboutEach = Element.makeAbsolute(string, string2);
    }

    public String aboutEachPrefix() {
        return this.m_sAboutEachPrefix;
    }

    public void aboutEachPrefix(String string) {
        this.m_sAboutEachPrefix = string;
    }

    public void aboutEachPrefix(String string, String string2) {
        this.m_sAboutEachPrefix = Element.makeAbsolute(string, string2);
    }

    public void addAttribute(QName qName, String string) {
        if (qName == null) {
            this.m_attributes.put(qName, string);
        }
    }

    public void addChild(Element element) {
        this.m_children.addElement(element);
    }

    public void addTarget(Element element) {
        this.m_vTargets.addElement(element);
    }

    public Enumeration attributes() {
        return this.m_attributes.keys();
    }

    public String bagID() {
        return this.m_sBagID;
    }

    public void bagID(String string) {
        this.m_sBagID = string;
    }

    public void bagID(String string, String string2) {
        this.m_sBagID = Element.makeAbsolute(string, string2);
    }

    public Enumeration children() {
        return this.m_children.elements();
    }

    public boolean done() {
        return this.m_bDone;
    }

    public void done(boolean bl) {
        this.m_bDone = bl;
    }

    public String getAttribute(QName qName) {
        return (String)this.m_attributes.get(qName);
    }

    public String getAttribute(String string) {
        return (String)this.m_attributes.get(new QName(string));
    }

    public void linearize(int n, PrintStream printStream) {
        Object object;
        Object object2;
        int n2 = 0;
        while (n2 < n) {
            printStream.print(" ");
            ++n2;
        }
        System.out.print("Element " + this.name() + " (");
        Enumeration enumeration = this.m_attributes.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (QName)enumeration.nextElement();
            object = (String)this.m_attributes.get(object2);
            System.out.print(" " + object2 + "=" + (String)object);
        }
        System.out.print(")\n");
        object2 = this.children();
        while (object2.hasMoreElements()) {
            object = (Element)object2.nextElement();
            ((Element)object).linearize(n + 2, printStream);
        }
    }

    public String localName() {
        return this.m_sName;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element = new Element("", null);
        System.err.println(Element.makeAbsolute(stringArray[0], stringArray[1]));
    }

    public static String makeAbsolute(String string, String string2) {
        if (string != null && string.indexOf(58) > 0) {
            return string;
        }
        String string3 = new String();
        if (string != null && string2 != null) {
            if (string.startsWith("#") && string2.endsWith("#")) {
                return String.valueOf(string2) + string.substring(1);
            }
            if (string.startsWith("..")) {
                try {
                    URL uRL = new URL(new URL(string2), string);
                    string3 = uRL.toString();
                }
                catch (Exception exception) {
                    System.err.println("RDF Resource - cannot combine " + string2 + " with " + string);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    string3 = string;
                }
                catch (Exception exception) {
                    if (string.startsWith("#")) {
                        try {
                            URL uRL = new URL(new URL(string2), string);
                            string3 = uRL.toString();
                        }
                        catch (Exception exception2) {
                            string3 = String.valueOf(string2) + string;
                        }
                    }
                    string3 = String.valueOf(string2) + string;
                }
            }
            return string3;
        }
        return string;
    }

    public String name() {
        return this.m_sNamespace != null ? String.valueOf(this.m_sNamespace) + this.m_sName : this.m_sName;
    }

    public String namespace() {
        return this.m_sNamespace;
    }

    public String prefix() {
        if (this.m_sPrefix != null) {
            return String.valueOf(this.m_sPrefix) + ":";
        }
        return "";
    }

    public void prefix(String string) {
        this.m_sPrefix = string;
    }

    public void removeAttribute(QName qName) {
        this.m_attributes.remove(qName);
    }

    public String resource() {
        return this.m_sResource;
    }

    public void resource(String string) {
        this.m_sResource = string;
    }

    public void resource(String string, String string2) {
        this.m_sResource = Element.makeAbsolute(string, string2);
    }

    public Element target() {
        if (this.m_vTargets.size() == 0) {
            return null;
        }
        return (Element)this.m_vTargets.elementAt(0);
    }

    public Enumeration targets() {
        return this.m_vTargets.elements();
    }

    public String toString() {
        Object object;
        String string = "[Element " + this.name() + "(";
        Enumeration enumeration = this.attributes();
        while (enumeration.hasMoreElements()) {
            object = (QName)enumeration.nextElement();
            String string2 = this.getAttribute((QName)object);
            string = String.valueOf(string) + object + "=" + string2 + " ";
        }
        string = String.valueOf(string) + ")<";
        object = this.children();
        while (object.hasMoreElements()) {
            string = String.valueOf(string) + object.nextElement().toString();
            if (!object.hasMoreElements()) continue;
            string = String.valueOf(string) + ",";
        }
        string = String.valueOf(string) + ">]";
        return string;
    }
}

