/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki.datatypes;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;
import org.daml.kazuki.Datatypes;

public class XSDgYear {
    private int year = 0;
    public static Map1 objectMapper = new ObjectMapper();

    public XSDgYear(XSDDateTime xSDDateTime) {
        this.setYear(xSDDateTime.getYears());
    }

    public XSDgYear(int n) {
        this.setYear(n);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getYear();
        if (n < 0) {
            stringBuffer.append("-");
            n *= -1;
        }
        if (n == 0) {
            stringBuffer.append("0000");
        } else if (n < 10) {
            stringBuffer.append("000");
            stringBuffer.append(n);
        } else if (n < 100) {
            stringBuffer.append("00");
            stringBuffer.append(n);
        } else if (n < 1000) {
            stringBuffer.append("0");
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getgYear(literal);
            }
            throw new IllegalArgumentException("RDF Statement expected while converting an XSDgYear.");
        }
    }
}

