/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.triplestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameFactoryInvocationHandler;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class DatabaseTripleStore
extends AbstractTripleStore {
    private OWLFrameFactoryInvocationHandler handler;
    private OWLJavaFactory javaFactory;

    public DatabaseTripleStore(OWLDatabaseModel owlModel, TripleStoreModel tripleStoreModel, NarrowFrameStore frameStore) {
        super(owlModel, tripleStoreModel, frameStore);
        this.javaFactory = new OWLJavaFactory(owlModel);
        this.handler = new OWLFrameFactoryInvocationHandler();
    }

    public boolean addValue(Instance subject, Slot slot, Object object) {
        this.addValueFast(subject, slot, object);
        return true;
    }

    public RDFResource getHomeResource(String name) {
        Set values = this.frameStore.getFrames(this.nameSlot, null, false, (Object)name);
        if (values.isEmpty()) {
            return null;
        }
        Instance instance = (Instance)values.iterator().next();
        return this.getRDFResource(instance);
    }

    private RDFResource getRDFResource(Instance instance) {
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        Collection directTypes = instance.getDirectTypes();
        Object in = null;
        if (directTypes.isEmpty()) {
            return new DefaultRDFProperty(this.owlModel, instance.getFrameID());
        }
        boolean allClasses = true;
        Iterator it = directTypes.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Cls) continue;
            allClasses = false;
        }
        if (allClasses) {
            in = instance instanceof Cls ? this.javaFactory.createCls(instance.getFrameID(), directTypes) : (instance instanceof Slot ? this.javaFactory.createSlot(instance.getFrameID(), directTypes) : this.javaFactory.createSimpleInstance(instance.getFrameID(), directTypes));
        }
        if (!(in instanceof RDFResource)) {
            return new DefaultRDFProperty(this.owlModel, instance.getFrameID());
        }
        return (RDFResource)in;
    }

    protected Collection getReferences(Object search) {
        Collection s = super.getReferences(search);
        if (s.isEmpty()) {
            return s;
        }
        for (ReferenceImpl reference : s) {
            Instance newFrame = this.handler.convertInstance((Instance)reference.getFrame());
            Slot newSlot = (Slot)this.handler.convertInstance((Instance)reference.getSlot());
            reference.set((Frame)newFrame, newSlot, reference.getFacet(), reference.isTemplate());
        }
        return s;
    }

    public String getName() {
        return this.getNarrowFrameStore().getName();
    }

    protected Collection getValues(Instance instance, Slot slot) {
        return this.wrap(super.getValues(instance, slot));
    }

    public Iterator listObjects(RDFResource subject, RDFProperty property) {
        return this.wrap(super.listObjects(subject, property));
    }

    public Iterator listSubjects(RDFProperty property) {
        return this.wrap(super.listSubjects(property));
    }

    public Iterator listTriples() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Iterator wrap(Iterator it) {
        ArrayList<Instance> results = new ArrayList<Instance>();
        while (it.hasNext()) {
            Instance next = (Instance)it.next();
            if (next instanceof RDFResource) {
                results.add(next);
                continue;
            }
            RDFResource resource = this.getRDFResource(next);
            results.add(resource);
        }
        return results.iterator();
    }

    public Collection wrap(Collection c) {
        return this.handler.convertCollection(c);
    }
}

